// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.medialive;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.medialive.MultiplexProgramArgs;
import com.pulumi.aws.medialive.inputs.MultiplexProgramState;
import com.pulumi.aws.medialive.outputs.MultiplexProgramMultiplexProgramSettings;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS MediaLive MultiplexProgram.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.medialive.Multiplex;
 * import com.pulumi.aws.medialive.MultiplexArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs;
 * import com.pulumi.aws.medialive.MultiplexProgram;
 * import com.pulumi.aws.medialive.MultiplexProgramArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state(&#34;available&#34;)
 *             .build());
 * 
 *         var exampleMultiplex = new Multiplex(&#34;exampleMultiplex&#34;, MultiplexArgs.builder()        
 *             .availabilityZones(            
 *                 available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]),
 *                 available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[1]))
 *             .multiplexSettings(MultiplexMultiplexSettingsArgs.builder()
 *                 .transportStreamBitrate(1000000)
 *                 .transportStreamId(1)
 *                 .transportStreamReservedBitrate(1)
 *                 .maximumVideoBufferDelayMilliseconds(1000)
 *                 .build())
 *             .startMultiplex(true)
 *             .tags(Map.of(&#34;tag1&#34;, &#34;value1&#34;))
 *             .build());
 * 
 *         var exampleMultiplexProgram = new MultiplexProgram(&#34;exampleMultiplexProgram&#34;, MultiplexProgramArgs.builder()        
 *             .programName(&#34;example_program&#34;)
 *             .multiplexId(exampleMultiplex.id())
 *             .multiplexProgramSettings(MultiplexProgramMultiplexProgramSettingsArgs.builder()
 *                 .programNumber(1)
 *                 .preferredChannelPipeline(&#34;CURRENTLY_ACTIVE&#34;)
 *                 .videoSettings(MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs.builder()
 *                     .constantBitrate(100000)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import MediaLive MultiplexProgram using the `id`, or a combination of &#34;`program_name`/`multiplex_id`&#34;. For example:
 * 
 * ```sh
 *  $ pulumi import aws:medialive/multiplexProgram:MultiplexProgram example example_program/1234567
 * ```
 * 
 */
@ResourceType(type="aws:medialive/multiplexProgram:MultiplexProgram")
public class MultiplexProgram extends com.pulumi.resources.CustomResource {
    /**
     * Multiplex ID.
     * 
     */
    @Export(name="multiplexId", refs={String.class}, tree="[0]")
    private Output<String> multiplexId;

    /**
     * @return Multiplex ID.
     * 
     */
    public Output<String> multiplexId() {
        return this.multiplexId;
    }
    /**
     * MultiplexProgram settings. See Multiplex Program Settings for more details.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="multiplexProgramSettings", refs={MultiplexProgramMultiplexProgramSettings.class}, tree="[0]")
    private Output</* @Nullable */ MultiplexProgramMultiplexProgramSettings> multiplexProgramSettings;

    /**
     * @return MultiplexProgram settings. See Multiplex Program Settings for more details.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<Optional<MultiplexProgramMultiplexProgramSettings>> multiplexProgramSettings() {
        return Codegen.optional(this.multiplexProgramSettings);
    }
    /**
     * Unique program name.
     * 
     */
    @Export(name="programName", refs={String.class}, tree="[0]")
    private Output<String> programName;

    /**
     * @return Unique program name.
     * 
     */
    public Output<String> programName() {
        return this.programName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public MultiplexProgram(String name) {
        this(name, MultiplexProgramArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public MultiplexProgram(String name, MultiplexProgramArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public MultiplexProgram(String name, MultiplexProgramArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:medialive/multiplexProgram:MultiplexProgram", name, args == null ? MultiplexProgramArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private MultiplexProgram(String name, Output<String> id, @Nullable MultiplexProgramState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:medialive/multiplexProgram:MultiplexProgram", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static MultiplexProgram get(String name, Output<String> id, @Nullable MultiplexProgramState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new MultiplexProgram(name, id, state, options);
    }
}
