// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.medialive;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.medialive.MultiplexArgs;
import com.pulumi.aws.medialive.inputs.MultiplexState;
import com.pulumi.aws.medialive.outputs.MultiplexMultiplexSettings;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS MediaLive Multiplex.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.medialive.Multiplex;
 * import com.pulumi.aws.medialive.MultiplexArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state(&#34;available&#34;)
 *             .build());
 * 
 *         var example = new Multiplex(&#34;example&#34;, MultiplexArgs.builder()        
 *             .availabilityZones(            
 *                 available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]),
 *                 available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[1]))
 *             .multiplexSettings(MultiplexMultiplexSettingsArgs.builder()
 *                 .transportStreamBitrate(1000000)
 *                 .transportStreamId(1)
 *                 .transportStreamReservedBitrate(1)
 *                 .maximumVideoBufferDelayMilliseconds(1000)
 *                 .build())
 *             .startMultiplex(true)
 *             .tags(Map.of(&#34;tag1&#34;, &#34;value1&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import MediaLive Multiplex using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:medialive/multiplex:Multiplex example 12345678
 * ```
 * 
 */
@ResourceType(type="aws:medialive/multiplex:Multiplex")
public class Multiplex extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Multiplex.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Multiplex.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * A list of availability zones. You must specify exactly two.
     * 
     */
    @Export(name="availabilityZones", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> availabilityZones;

    /**
     * @return A list of availability zones. You must specify exactly two.
     * 
     */
    public Output<List<String>> availabilityZones() {
        return this.availabilityZones;
    }
    /**
     * Multiplex settings. See Multiplex Settings for more details.
     * 
     */
    @Export(name="multiplexSettings", refs={MultiplexMultiplexSettings.class}, tree="[0]")
    private Output</* @Nullable */ MultiplexMultiplexSettings> multiplexSettings;

    /**
     * @return Multiplex settings. See Multiplex Settings for more details.
     * 
     */
    public Output<Optional<MultiplexMultiplexSettings>> multiplexSettings() {
        return Codegen.optional(this.multiplexSettings);
    }
    /**
     * name of Multiplex.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return name of Multiplex.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Whether to start the Multiplex. Defaults to `false`.
     * 
     */
    @Export(name="startMultiplex", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> startMultiplex;

    /**
     * @return Whether to start the Multiplex. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> startMultiplex() {
        return Codegen.optional(this.startMultiplex);
    }
    /**
     * A map of tags to assign to the Multiplex. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the Multiplex. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Multiplex(String name) {
        this(name, MultiplexArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Multiplex(String name, MultiplexArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Multiplex(String name, MultiplexArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:medialive/multiplex:Multiplex", name, args == null ? MultiplexArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Multiplex(String name, Output<String> id, @Nullable MultiplexState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:medialive/multiplex:Multiplex", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Multiplex get(String name, Output<String> id, @Nullable MultiplexState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Multiplex(name, id, state, options);
    }
}
