// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.macie2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.macie2.OrganizationAdminAccountArgs;
import com.pulumi.aws.macie2.inputs.OrganizationAdminAccountState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage an [Amazon Macie Organization Admin Account](https://docs.aws.amazon.com/macie/latest/APIReference/admin.html).
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.OrganizationAdminAccount;
 * import com.pulumi.aws.macie2.OrganizationAdminAccountArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account(&#34;exampleAccount&#34;);
 * 
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount(&#34;exampleOrganizationAdminAccount&#34;, OrganizationAdminAccountArgs.builder()        
 *             .adminAccountId(&#34;ID OF THE ADMIN ACCOUNT&#34;)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_macie2_organization_admin_account` using the id. For example:
 * 
 * ```sh
 *  $ pulumi import aws:macie2/organizationAdminAccount:OrganizationAdminAccount example abcd1
 * ```
 * 
 */
@ResourceType(type="aws:macie2/organizationAdminAccount:OrganizationAdminAccount")
public class OrganizationAdminAccount extends com.pulumi.resources.CustomResource {
    /**
     * The AWS account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.
     * 
     */
    @Export(name="adminAccountId", refs={String.class}, tree="[0]")
    private Output<String> adminAccountId;

    /**
     * @return The AWS account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.
     * 
     */
    public Output<String> adminAccountId() {
        return this.adminAccountId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public OrganizationAdminAccount(String name) {
        this(name, OrganizationAdminAccountArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public OrganizationAdminAccount(String name, OrganizationAdminAccountArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public OrganizationAdminAccount(String name, OrganizationAdminAccountArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:macie2/organizationAdminAccount:OrganizationAdminAccount", name, args == null ? OrganizationAdminAccountArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private OrganizationAdminAccount(String name, Output<String> id, @Nullable OrganizationAdminAccountState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:macie2/organizationAdminAccount:OrganizationAdminAccount", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static OrganizationAdminAccount get(String name, Output<String> id, @Nullable OrganizationAdminAccountState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new OrganizationAdminAccount(name, id, state, options);
    }
}
