// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.macie2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.macie2.ClassificationJobArgs;
import com.pulumi.aws.macie2.inputs.ClassificationJobState;
import com.pulumi.aws.macie2.outputs.ClassificationJobS3JobDefinition;
import com.pulumi.aws.macie2.outputs.ClassificationJobScheduleFrequency;
import com.pulumi.aws.macie2.outputs.ClassificationJobUserPausedDetail;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage an [AWS Macie Classification Job](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html).
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.ClassificationJob;
 * import com.pulumi.aws.macie2.ClassificationJobArgs;
 * import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var testAccount = new Account(&#34;testAccount&#34;);
 * 
 *         var testClassificationJob = new ClassificationJob(&#34;testClassificationJob&#34;, ClassificationJobArgs.builder()        
 *             .jobType(&#34;ONE_TIME&#34;)
 *             .s3JobDefinition(ClassificationJobS3JobDefinitionArgs.builder()
 *                 .bucketDefinitions(ClassificationJobS3JobDefinitionBucketDefinitionArgs.builder()
 *                     .accountId(&#34;ACCOUNT ID&#34;)
 *                     .buckets(&#34;S3 BUCKET NAME&#34;)
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testAccount)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_macie2_classification_job` using the id. For example:
 * 
 * ```sh
 *  $ pulumi import aws:macie2/classificationJob:ClassificationJob example abcd1
 * ```
 * 
 */
@ResourceType(type="aws:macie2/classificationJob:ClassificationJob")
public class ClassificationJob extends com.pulumi.resources.CustomResource {
    /**
     * The date and time, in UTC and extended RFC 3339 format, when the job was created.
     * 
     */
    @Export(name="createdAt", refs={String.class}, tree="[0]")
    private Output<String> createdAt;

    /**
     * @return The date and time, in UTC and extended RFC 3339 format, when the job was created.
     * 
     */
    public Output<String> createdAt() {
        return this.createdAt;
    }
    /**
     * The custom data identifiers to use for data analysis and classification.
     * 
     */
    @Export(name="customDataIdentifierIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> customDataIdentifierIds;

    /**
     * @return The custom data identifiers to use for data analysis and classification.
     * 
     */
    public Output<List<String>> customDataIdentifierIds() {
        return this.customDataIdentifierIds;
    }
    /**
     * A custom description of the job. The description can contain as many as 200 characters.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output<String> description;

    /**
     * @return A custom description of the job. The description can contain as many as 200 characters.
     * 
     */
    public Output<String> description() {
        return this.description;
    }
    /**
     * Specifies whether to analyze all existing, eligible objects immediately after the job is created.
     * 
     */
    @Export(name="initialRun", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> initialRun;

    /**
     * @return Specifies whether to analyze all existing, eligible objects immediately after the job is created.
     * 
     */
    public Output<Optional<Boolean>> initialRun() {
        return Codegen.optional(this.initialRun);
    }
    @Export(name="jobArn", refs={String.class}, tree="[0]")
    private Output<String> jobArn;

    public Output<String> jobArn() {
        return this.jobArn;
    }
    @Export(name="jobId", refs={String.class}, tree="[0]")
    private Output<String> jobId;

    public Output<String> jobId() {
        return this.jobId;
    }
    /**
     * The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
     * 
     */
    @Export(name="jobStatus", refs={String.class}, tree="[0]")
    private Output<String> jobStatus;

    /**
     * @return The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
     * 
     */
    public Output<String> jobStatus() {
        return this.jobStatus;
    }
    /**
     * The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don&#39;t specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
     * 
     */
    @Export(name="jobType", refs={String.class}, tree="[0]")
    private Output<String> jobType;

    /**
     * @return The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don&#39;t specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
     * 
     */
    public Output<String> jobType() {
        return this.jobType;
    }
    /**
     * A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     * 
     */
    @Export(name="namePrefix", refs={String.class}, tree="[0]")
    private Output<String> namePrefix;

    /**
     * @return Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     * 
     */
    public Output<String> namePrefix() {
        return this.namePrefix;
    }
    /**
     * The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
     * 
     */
    @Export(name="s3JobDefinition", refs={ClassificationJobS3JobDefinition.class}, tree="[0]")
    private Output<ClassificationJobS3JobDefinition> s3JobDefinition;

    /**
     * @return The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
     * 
     */
    public Output<ClassificationJobS3JobDefinition> s3JobDefinition() {
        return this.s3JobDefinition;
    }
    /**
     * The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
     * 
     */
    @Export(name="samplingPercentage", refs={Integer.class}, tree="[0]")
    private Output<Integer> samplingPercentage;

    /**
     * @return The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
     * 
     */
    public Output<Integer> samplingPercentage() {
        return this.samplingPercentage;
    }
    /**
     * The recurrence pattern for running the job. To run the job only once, don&#39;t specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
     * 
     */
    @Export(name="scheduleFrequency", refs={ClassificationJobScheduleFrequency.class}, tree="[0]")
    private Output<ClassificationJobScheduleFrequency> scheduleFrequency;

    /**
     * @return The recurrence pattern for running the job. To run the job only once, don&#39;t specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
     * 
     */
    public Output<ClassificationJobScheduleFrequency> scheduleFrequency() {
        return this.scheduleFrequency;
    }
    /**
     * A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * If the current status of the job is `USER_PAUSED`, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn&#39;t resumed. This value is present only if the value for `job-status` is `USER_PAUSED`.
     * 
     */
    @Export(name="userPausedDetails", refs={List.class,ClassificationJobUserPausedDetail.class}, tree="[0,1]")
    private Output<List<ClassificationJobUserPausedDetail>> userPausedDetails;

    /**
     * @return If the current status of the job is `USER_PAUSED`, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn&#39;t resumed. This value is present only if the value for `job-status` is `USER_PAUSED`.
     * 
     */
    public Output<List<ClassificationJobUserPausedDetail>> userPausedDetails() {
        return this.userPausedDetails;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ClassificationJob(String name) {
        this(name, ClassificationJobArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ClassificationJob(String name, ClassificationJobArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ClassificationJob(String name, ClassificationJobArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:macie2/classificationJob:ClassificationJob", name, args == null ? ClassificationJobArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ClassificationJob(String name, Output<String> id, @Nullable ClassificationJobState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:macie2/classificationJob:ClassificationJob", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ClassificationJob get(String name, Output<String> id, @Nullable ClassificationJobState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ClassificationJob(name, id, state, options);
    }
}
