// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.macie2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.macie2.ClassificationExportConfigurationArgs;
import com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationState;
import com.pulumi.aws.macie2.outputs.ClassificationExportConfigurationS3Destination;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage an [Amazon Macie Classification Export Configuration](https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html).
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.ClassificationExportConfiguration;
 * import com.pulumi.aws.macie2.ClassificationExportConfigurationArgs;
 * import com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationS3DestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account(&#34;exampleAccount&#34;);
 * 
 *         var exampleClassificationExportConfiguration = new ClassificationExportConfiguration(&#34;exampleClassificationExportConfiguration&#34;, ClassificationExportConfigurationArgs.builder()        
 *             .s3Destination(ClassificationExportConfigurationS3DestinationArgs.builder()
 *                 .bucketName(aws_s3_bucket.example().bucket())
 *                 .keyPrefix(&#34;exampleprefix/&#34;)
 *                 .kmsKeyArn(aws_kms_key.example().arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_macie2_classification_export_configuration` using the account ID and region. For example:
 * 
 * ```sh
 *  $ pulumi import aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration example 123456789012:us-west-2
 * ```
 * 
 */
@ResourceType(type="aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration")
public class ClassificationExportConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * Configuration block for a S3 Destination. Defined below
     * 
     */
    @Export(name="s3Destination", refs={ClassificationExportConfigurationS3Destination.class}, tree="[0]")
    private Output</* @Nullable */ ClassificationExportConfigurationS3Destination> s3Destination;

    /**
     * @return Configuration block for a S3 Destination. Defined below
     * 
     */
    public Output<Optional<ClassificationExportConfigurationS3Destination>> s3Destination() {
        return Codegen.optional(this.s3Destination);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ClassificationExportConfiguration(String name) {
        this(name, ClassificationExportConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ClassificationExportConfiguration(String name, @Nullable ClassificationExportConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ClassificationExportConfiguration(String name, @Nullable ClassificationExportConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration", name, args == null ? ClassificationExportConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ClassificationExportConfiguration(String name, Output<String> id, @Nullable ClassificationExportConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ClassificationExportConfiguration get(String name, Output<String> id, @Nullable ClassificationExportConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ClassificationExportConfiguration(name, id, state, options);
    }
}
