// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.location;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.location.TrackerAssociationArgs;
import com.pulumi.aws.location.inputs.TrackerAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS Location Tracker Association.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.location.GeofenceCollection;
 * import com.pulumi.aws.location.GeofenceCollectionArgs;
 * import com.pulumi.aws.location.Tracker;
 * import com.pulumi.aws.location.TrackerArgs;
 * import com.pulumi.aws.location.TrackerAssociation;
 * import com.pulumi.aws.location.TrackerAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleGeofenceCollection = new GeofenceCollection(&#34;exampleGeofenceCollection&#34;, GeofenceCollectionArgs.builder()        
 *             .collectionName(&#34;example&#34;)
 *             .build());
 * 
 *         var exampleTracker = new Tracker(&#34;exampleTracker&#34;, TrackerArgs.builder()        
 *             .trackerName(&#34;example&#34;)
 *             .build());
 * 
 *         var exampleTrackerAssociation = new TrackerAssociation(&#34;exampleTrackerAssociation&#34;, TrackerAssociationArgs.builder()        
 *             .consumerArn(exampleGeofenceCollection.collectionArn())
 *             .trackerName(exampleTracker.trackerName())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Location Tracker Association using the `tracker_name|consumer_arn`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:location/trackerAssociation:TrackerAssociation example &#34;tracker_name|consumer_arn&#34;
 * ```
 * 
 */
@ResourceType(type="aws:location/trackerAssociation:TrackerAssociation")
public class TrackerAssociation extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
     * 
     */
    @Export(name="consumerArn", refs={String.class}, tree="[0]")
    private Output<String> consumerArn;

    /**
     * @return The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
     * 
     */
    public Output<String> consumerArn() {
        return this.consumerArn;
    }
    /**
     * The name of the tracker resource to be associated with a geofence collection.
     * 
     */
    @Export(name="trackerName", refs={String.class}, tree="[0]")
    private Output<String> trackerName;

    /**
     * @return The name of the tracker resource to be associated with a geofence collection.
     * 
     */
    public Output<String> trackerName() {
        return this.trackerName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public TrackerAssociation(String name) {
        this(name, TrackerAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public TrackerAssociation(String name, TrackerAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public TrackerAssociation(String name, TrackerAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:location/trackerAssociation:TrackerAssociation", name, args == null ? TrackerAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private TrackerAssociation(String name, Output<String> id, @Nullable TrackerAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:location/trackerAssociation:TrackerAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static TrackerAssociation get(String name, Output<String> id, @Nullable TrackerAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new TrackerAssociation(name, id, state, options);
    }
}
