// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class KeyPairState extends com.pulumi.resources.ResourceArgs {

    public static final KeyPairState Empty = new KeyPairState();

    /**
     * The ARN of the Lightsail key pair.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return The ARN of the Lightsail key pair.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The MD5 public key fingerprint for the encrypted private key.
     * 
     */
    @Import(name="encryptedFingerprint")
    private @Nullable Output<String> encryptedFingerprint;

    /**
     * @return The MD5 public key fingerprint for the encrypted private key.
     * 
     */
    public Optional<Output<String>> encryptedFingerprint() {
        return Optional.ofNullable(this.encryptedFingerprint);
    }

    /**
     * the private key material, base 64 encoded and encrypted with the given `pgp_key`. This is only populated when creating a new key and `pgp_key` is supplied.
     * 
     */
    @Import(name="encryptedPrivateKey")
    private @Nullable Output<String> encryptedPrivateKey;

    /**
     * @return the private key material, base 64 encoded and encrypted with the given `pgp_key`. This is only populated when creating a new key and `pgp_key` is supplied.
     * 
     */
    public Optional<Output<String>> encryptedPrivateKey() {
        return Optional.ofNullable(this.encryptedPrivateKey);
    }

    /**
     * The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     * 
     */
    @Import(name="fingerprint")
    private @Nullable Output<String> fingerprint;

    /**
     * @return The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     * 
     */
    public Optional<Output<String>> fingerprint() {
        return Optional.ofNullable(this.fingerprint);
    }

    /**
     * The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    @Import(name="namePrefix")
    private @Nullable Output<String> namePrefix;

    public Optional<Output<String>> namePrefix() {
        return Optional.ofNullable(this.namePrefix);
    }

    /**
     * An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
     * 
     */
    @Import(name="pgpKey")
    private @Nullable Output<String> pgpKey;

    /**
     * @return An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
     * 
     */
    public Optional<Output<String>> pgpKey() {
        return Optional.ofNullable(this.pgpKey);
    }

    /**
     * the private key, base64 encoded. This is only populated when creating a new key, and when no `pgp_key` is provided.
     * 
     */
    @Import(name="privateKey")
    private @Nullable Output<String> privateKey;

    /**
     * @return the private key, base64 encoded. This is only populated when creating a new key, and when no `pgp_key` is provided.
     * 
     */
    public Optional<Output<String>> privateKey() {
        return Optional.ofNullable(this.privateKey);
    }

    /**
     * The public key material. This public key will be imported into Lightsail
     * 
     */
    @Import(name="publicKey")
    private @Nullable Output<String> publicKey;

    /**
     * @return The public key material. This public key will be imported into Lightsail
     * 
     */
    public Optional<Output<String>> publicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    /**
     * A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     * &gt; **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     * &gt; **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    private KeyPairState() {}

    private KeyPairState(KeyPairState $) {
        this.arn = $.arn;
        this.encryptedFingerprint = $.encryptedFingerprint;
        this.encryptedPrivateKey = $.encryptedPrivateKey;
        this.fingerprint = $.fingerprint;
        this.name = $.name;
        this.namePrefix = $.namePrefix;
        this.pgpKey = $.pgpKey;
        this.privateKey = $.privateKey;
        this.publicKey = $.publicKey;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(KeyPairState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private KeyPairState $;

        public Builder() {
            $ = new KeyPairState();
        }

        public Builder(KeyPairState defaults) {
            $ = new KeyPairState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn The ARN of the Lightsail key pair.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn The ARN of the Lightsail key pair.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param encryptedFingerprint The MD5 public key fingerprint for the encrypted private key.
         * 
         * @return builder
         * 
         */
        public Builder encryptedFingerprint(@Nullable Output<String> encryptedFingerprint) {
            $.encryptedFingerprint = encryptedFingerprint;
            return this;
        }

        /**
         * @param encryptedFingerprint The MD5 public key fingerprint for the encrypted private key.
         * 
         * @return builder
         * 
         */
        public Builder encryptedFingerprint(String encryptedFingerprint) {
            return encryptedFingerprint(Output.of(encryptedFingerprint));
        }

        /**
         * @param encryptedPrivateKey the private key material, base 64 encoded and encrypted with the given `pgp_key`. This is only populated when creating a new key and `pgp_key` is supplied.
         * 
         * @return builder
         * 
         */
        public Builder encryptedPrivateKey(@Nullable Output<String> encryptedPrivateKey) {
            $.encryptedPrivateKey = encryptedPrivateKey;
            return this;
        }

        /**
         * @param encryptedPrivateKey the private key material, base 64 encoded and encrypted with the given `pgp_key`. This is only populated when creating a new key and `pgp_key` is supplied.
         * 
         * @return builder
         * 
         */
        public Builder encryptedPrivateKey(String encryptedPrivateKey) {
            return encryptedPrivateKey(Output.of(encryptedPrivateKey));
        }

        /**
         * @param fingerprint The MD5 public key fingerprint as specified in section 4 of RFC 4716.
         * 
         * @return builder
         * 
         */
        public Builder fingerprint(@Nullable Output<String> fingerprint) {
            $.fingerprint = fingerprint;
            return this;
        }

        /**
         * @param fingerprint The MD5 public key fingerprint as specified in section 4 of RFC 4716.
         * 
         * @return builder
         * 
         */
        public Builder fingerprint(String fingerprint) {
            return fingerprint(Output.of(fingerprint));
        }

        /**
         * @param name The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        public Builder namePrefix(@Nullable Output<String> namePrefix) {
            $.namePrefix = namePrefix;
            return this;
        }

        public Builder namePrefix(String namePrefix) {
            return namePrefix(Output.of(namePrefix));
        }

        /**
         * @param pgpKey An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
         * 
         * @return builder
         * 
         */
        public Builder pgpKey(@Nullable Output<String> pgpKey) {
            $.pgpKey = pgpKey;
            return this;
        }

        /**
         * @param pgpKey An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
         * 
         * @return builder
         * 
         */
        public Builder pgpKey(String pgpKey) {
            return pgpKey(Output.of(pgpKey));
        }

        /**
         * @param privateKey the private key, base64 encoded. This is only populated when creating a new key, and when no `pgp_key` is provided.
         * 
         * @return builder
         * 
         */
        public Builder privateKey(@Nullable Output<String> privateKey) {
            $.privateKey = privateKey;
            return this;
        }

        /**
         * @param privateKey the private key, base64 encoded. This is only populated when creating a new key, and when no `pgp_key` is provided.
         * 
         * @return builder
         * 
         */
        public Builder privateKey(String privateKey) {
            return privateKey(Output.of(privateKey));
        }

        /**
         * @param publicKey The public key material. This public key will be imported into Lightsail
         * 
         * @return builder
         * 
         */
        public Builder publicKey(@Nullable Output<String> publicKey) {
            $.publicKey = publicKey;
            return this;
        }

        /**
         * @param publicKey The public key material. This public key will be imported into Lightsail
         * 
         * @return builder
         * 
         */
        public Builder publicKey(String publicKey) {
            return publicKey(Output.of(publicKey));
        }

        /**
         * @param tags A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * &gt; **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * &gt; **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        public KeyPairState build() {
            return $;
        }
    }

}
