// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DistributionOriginArgs extends com.pulumi.resources.ResourceArgs {

    public static final DistributionOriginArgs Empty = new DistributionOriginArgs();

    /**
     * The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
     * 
     */
    @Import(name="name", required=true)
    private Output<String> name;

    /**
     * @return The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     * The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
     * 
     */
    @Import(name="protocolPolicy")
    private @Nullable Output<String> protocolPolicy;

    /**
     * @return The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
     * 
     */
    public Optional<Output<String>> protocolPolicy() {
        return Optional.ofNullable(this.protocolPolicy);
    }

    /**
     * The AWS Region name of the origin resource.
     * 
     */
    @Import(name="regionName", required=true)
    private Output<String> regionName;

    /**
     * @return The AWS Region name of the origin resource.
     * 
     */
    public Output<String> regionName() {
        return this.regionName;
    }

    /**
     * The resource type of the origin resource (e.g., Instance).
     * 
     */
    @Import(name="resourceType")
    private @Nullable Output<String> resourceType;

    /**
     * @return The resource type of the origin resource (e.g., Instance).
     * 
     */
    public Optional<Output<String>> resourceType() {
        return Optional.ofNullable(this.resourceType);
    }

    private DistributionOriginArgs() {}

    private DistributionOriginArgs(DistributionOriginArgs $) {
        this.name = $.name;
        this.protocolPolicy = $.protocolPolicy;
        this.regionName = $.regionName;
        this.resourceType = $.resourceType;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DistributionOriginArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DistributionOriginArgs $;

        public Builder() {
            $ = new DistributionOriginArgs();
        }

        public Builder(DistributionOriginArgs defaults) {
            $ = new DistributionOriginArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param name The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
         * 
         * @return builder
         * 
         */
        public Builder name(Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param protocolPolicy The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
         * 
         * @return builder
         * 
         */
        public Builder protocolPolicy(@Nullable Output<String> protocolPolicy) {
            $.protocolPolicy = protocolPolicy;
            return this;
        }

        /**
         * @param protocolPolicy The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
         * 
         * @return builder
         * 
         */
        public Builder protocolPolicy(String protocolPolicy) {
            return protocolPolicy(Output.of(protocolPolicy));
        }

        /**
         * @param regionName The AWS Region name of the origin resource.
         * 
         * @return builder
         * 
         */
        public Builder regionName(Output<String> regionName) {
            $.regionName = regionName;
            return this;
        }

        /**
         * @param regionName The AWS Region name of the origin resource.
         * 
         * @return builder
         * 
         */
        public Builder regionName(String regionName) {
            return regionName(Output.of(regionName));
        }

        /**
         * @param resourceType The resource type of the origin resource (e.g., Instance).
         * 
         * @return builder
         * 
         */
        public Builder resourceType(@Nullable Output<String> resourceType) {
            $.resourceType = resourceType;
            return this;
        }

        /**
         * @param resourceType The resource type of the origin resource (e.g., Instance).
         * 
         * @return builder
         * 
         */
        public Builder resourceType(String resourceType) {
            return resourceType(Output.of(resourceType));
        }

        public DistributionOriginArgs build() {
            $.name = Objects.requireNonNull($.name, "expected parameter 'name' to be non-null");
            $.regionName = Objects.requireNonNull($.regionName, "expected parameter 'regionName' to be non-null");
            return $;
        }
    }

}
