// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DatabaseState extends com.pulumi.resources.ResourceArgs {

    public static final DatabaseState Empty = new DatabaseState();

    /**
     * When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * The ARN of the Lightsail instance (matches `id`).
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return The ARN of the Lightsail instance (matches `id`).
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
     * 
     */
    @Import(name="backupRetentionEnabled")
    private @Nullable Output<Boolean> backupRetentionEnabled;

    /**
     * @return When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
     * 
     */
    public Optional<Output<Boolean>> backupRetentionEnabled() {
        return Optional.ofNullable(this.backupRetentionEnabled);
    }

    /**
     * The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
     * 
     */
    @Import(name="blueprintId")
    private @Nullable Output<String> blueprintId;

    /**
     * @return The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
     * 
     */
    public Optional<Output<String>> blueprintId() {
        return Optional.ofNullable(this.blueprintId);
    }

    /**
     * The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
     * 
     */
    @Import(name="bundleId")
    private @Nullable Output<String> bundleId;

    /**
     * @return The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
     * 
     */
    public Optional<Output<String>> bundleId() {
        return Optional.ofNullable(this.bundleId);
    }

    /**
     * The certificate associated with the database.
     * 
     */
    @Import(name="caCertificateIdentifier")
    private @Nullable Output<String> caCertificateIdentifier;

    /**
     * @return The certificate associated with the database.
     * 
     */
    public Optional<Output<String>> caCertificateIdentifier() {
        return Optional.ofNullable(this.caCertificateIdentifier);
    }

    /**
     * The number of vCPUs for the database.
     * 
     */
    @Import(name="cpuCount")
    private @Nullable Output<Integer> cpuCount;

    /**
     * @return The number of vCPUs for the database.
     * 
     */
    public Optional<Output<Integer>> cpuCount() {
        return Optional.ofNullable(this.cpuCount);
    }

    /**
     * The timestamp when the instance was created.
     * 
     */
    @Import(name="createdAt")
    private @Nullable Output<String> createdAt;

    /**
     * @return The timestamp when the instance was created.
     * 
     */
    public Optional<Output<String>> createdAt() {
        return Optional.ofNullable(this.createdAt);
    }

    /**
     * The size of the disk for the database.
     * 
     */
    @Import(name="diskSize")
    private @Nullable Output<Double> diskSize;

    /**
     * @return The size of the disk for the database.
     * 
     */
    public Optional<Output<Double>> diskSize() {
        return Optional.ofNullable(this.diskSize);
    }

    /**
     * The database software (for example, MySQL).
     * 
     */
    @Import(name="engine")
    private @Nullable Output<String> engine;

    /**
     * @return The database software (for example, MySQL).
     * 
     */
    public Optional<Output<String>> engine() {
        return Optional.ofNullable(this.engine);
    }

    /**
     * The database engine version (for example, 5.7.23).
     * 
     */
    @Import(name="engineVersion")
    private @Nullable Output<String> engineVersion;

    /**
     * @return The database engine version (for example, 5.7.23).
     * 
     */
    public Optional<Output<String>> engineVersion() {
        return Optional.ofNullable(this.engineVersion);
    }

    /**
     * The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
     * 
     */
    @Import(name="finalSnapshotName")
    private @Nullable Output<String> finalSnapshotName;

    /**
     * @return The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
     * 
     */
    public Optional<Output<String>> finalSnapshotName() {
        return Optional.ofNullable(this.finalSnapshotName);
    }

    /**
     * The name of the master database created when the Lightsail database resource is created.
     * 
     */
    @Import(name="masterDatabaseName")
    private @Nullable Output<String> masterDatabaseName;

    /**
     * @return The name of the master database created when the Lightsail database resource is created.
     * 
     */
    public Optional<Output<String>> masterDatabaseName() {
        return Optional.ofNullable(this.masterDatabaseName);
    }

    /**
     * The master endpoint fqdn for the database.
     * 
     */
    @Import(name="masterEndpointAddress")
    private @Nullable Output<String> masterEndpointAddress;

    /**
     * @return The master endpoint fqdn for the database.
     * 
     */
    public Optional<Output<String>> masterEndpointAddress() {
        return Optional.ofNullable(this.masterEndpointAddress);
    }

    /**
     * The master endpoint network port for the database.
     * 
     */
    @Import(name="masterEndpointPort")
    private @Nullable Output<Integer> masterEndpointPort;

    /**
     * @return The master endpoint network port for the database.
     * 
     */
    public Optional<Output<Integer>> masterEndpointPort() {
        return Optional.ofNullable(this.masterEndpointPort);
    }

    /**
     * The password for the master user of your new database. The password can include any printable ASCII character except &#34;/&#34;, &#34;&#34;&#34;, or &#34;@&#34;.
     * 
     */
    @Import(name="masterPassword")
    private @Nullable Output<String> masterPassword;

    /**
     * @return The password for the master user of your new database. The password can include any printable ASCII character except &#34;/&#34;, &#34;&#34;&#34;, or &#34;@&#34;.
     * 
     */
    public Optional<Output<String>> masterPassword() {
        return Optional.ofNullable(this.masterPassword);
    }

    /**
     * The master user name for your new database.
     * 
     */
    @Import(name="masterUsername")
    private @Nullable Output<String> masterUsername;

    /**
     * @return The master user name for your new database.
     * 
     */
    public Optional<Output<String>> masterUsername() {
        return Optional.ofNullable(this.masterUsername);
    }

    /**
     * The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
     * 
     */
    @Import(name="preferredBackupWindow")
    private @Nullable Output<String> preferredBackupWindow;

    /**
     * @return The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
     * 
     */
    public Optional<Output<String>> preferredBackupWindow() {
        return Optional.ofNullable(this.preferredBackupWindow);
    }

    /**
     * The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
     * 
     */
    @Import(name="preferredMaintenanceWindow")
    private @Nullable Output<String> preferredMaintenanceWindow;

    /**
     * @return The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
     * 
     */
    public Optional<Output<String>> preferredMaintenanceWindow() {
        return Optional.ofNullable(this.preferredMaintenanceWindow);
    }

    /**
     * Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
     * 
     */
    @Import(name="publiclyAccessible")
    private @Nullable Output<Boolean> publiclyAccessible;

    /**
     * @return Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
     * 
     */
    public Optional<Output<Boolean>> publiclyAccessible() {
        return Optional.ofNullable(this.publiclyAccessible);
    }

    /**
     * The amount of RAM in GB for the database.
     * 
     */
    @Import(name="ramSize")
    private @Nullable Output<Double> ramSize;

    /**
     * @return The amount of RAM in GB for the database.
     * 
     */
    public Optional<Output<Double>> ramSize() {
        return Optional.ofNullable(this.ramSize);
    }

    /**
     * The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
     * 
     */
    @Import(name="relationalDatabaseName")
    private @Nullable Output<String> relationalDatabaseName;

    /**
     * @return The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
     * 
     */
    public Optional<Output<String>> relationalDatabaseName() {
        return Optional.ofNullable(this.relationalDatabaseName);
    }

    /**
     * Describes the secondary Availability Zone of a high availability database. The secondary database is used for failover support of a high availability database.
     * 
     */
    @Import(name="secondaryAvailabilityZone")
    private @Nullable Output<String> secondaryAvailabilityZone;

    /**
     * @return Describes the secondary Availability Zone of a high availability database. The secondary database is used for failover support of a high availability database.
     * 
     */
    public Optional<Output<String>> secondaryAvailabilityZone() {
        return Optional.ofNullable(this.secondaryAvailabilityZone);
    }

    /**
     * Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
     * 
     */
    @Import(name="skipFinalSnapshot")
    private @Nullable Output<Boolean> skipFinalSnapshot;

    /**
     * @return Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
     * 
     */
    public Optional<Output<Boolean>> skipFinalSnapshot() {
        return Optional.ofNullable(this.skipFinalSnapshot);
    }

    /**
     * The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * 
     */
    @Import(name="supportCode")
    private @Nullable Output<String> supportCode;

    /**
     * @return The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * 
     */
    public Optional<Output<String>> supportCode() {
        return Optional.ofNullable(this.supportCode);
    }

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    private DatabaseState() {}

    private DatabaseState(DatabaseState $) {
        this.applyImmediately = $.applyImmediately;
        this.arn = $.arn;
        this.availabilityZone = $.availabilityZone;
        this.backupRetentionEnabled = $.backupRetentionEnabled;
        this.blueprintId = $.blueprintId;
        this.bundleId = $.bundleId;
        this.caCertificateIdentifier = $.caCertificateIdentifier;
        this.cpuCount = $.cpuCount;
        this.createdAt = $.createdAt;
        this.diskSize = $.diskSize;
        this.engine = $.engine;
        this.engineVersion = $.engineVersion;
        this.finalSnapshotName = $.finalSnapshotName;
        this.masterDatabaseName = $.masterDatabaseName;
        this.masterEndpointAddress = $.masterEndpointAddress;
        this.masterEndpointPort = $.masterEndpointPort;
        this.masterPassword = $.masterPassword;
        this.masterUsername = $.masterUsername;
        this.preferredBackupWindow = $.preferredBackupWindow;
        this.preferredMaintenanceWindow = $.preferredMaintenanceWindow;
        this.publiclyAccessible = $.publiclyAccessible;
        this.ramSize = $.ramSize;
        this.relationalDatabaseName = $.relationalDatabaseName;
        this.secondaryAvailabilityZone = $.secondaryAvailabilityZone;
        this.skipFinalSnapshot = $.skipFinalSnapshot;
        this.supportCode = $.supportCode;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DatabaseState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DatabaseState $;

        public Builder() {
            $ = new DatabaseState();
        }

        public Builder(DatabaseState defaults) {
            $ = new DatabaseState(Objects.requireNonNull(defaults));
        }

        /**
         * @param applyImmediately When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param arn The ARN of the Lightsail instance (matches `id`).
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn The ARN of the Lightsail instance (matches `id`).
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param availabilityZone The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param backupRetentionEnabled When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
         * 
         * @return builder
         * 
         */
        public Builder backupRetentionEnabled(@Nullable Output<Boolean> backupRetentionEnabled) {
            $.backupRetentionEnabled = backupRetentionEnabled;
            return this;
        }

        /**
         * @param backupRetentionEnabled When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
         * 
         * @return builder
         * 
         */
        public Builder backupRetentionEnabled(Boolean backupRetentionEnabled) {
            return backupRetentionEnabled(Output.of(backupRetentionEnabled));
        }

        /**
         * @param blueprintId The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
         * 
         * @return builder
         * 
         */
        public Builder blueprintId(@Nullable Output<String> blueprintId) {
            $.blueprintId = blueprintId;
            return this;
        }

        /**
         * @param blueprintId The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
         * 
         * @return builder
         * 
         */
        public Builder blueprintId(String blueprintId) {
            return blueprintId(Output.of(blueprintId));
        }

        /**
         * @param bundleId The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
         * 
         * @return builder
         * 
         */
        public Builder bundleId(@Nullable Output<String> bundleId) {
            $.bundleId = bundleId;
            return this;
        }

        /**
         * @param bundleId The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
         * 
         * @return builder
         * 
         */
        public Builder bundleId(String bundleId) {
            return bundleId(Output.of(bundleId));
        }

        /**
         * @param caCertificateIdentifier The certificate associated with the database.
         * 
         * @return builder
         * 
         */
        public Builder caCertificateIdentifier(@Nullable Output<String> caCertificateIdentifier) {
            $.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        /**
         * @param caCertificateIdentifier The certificate associated with the database.
         * 
         * @return builder
         * 
         */
        public Builder caCertificateIdentifier(String caCertificateIdentifier) {
            return caCertificateIdentifier(Output.of(caCertificateIdentifier));
        }

        /**
         * @param cpuCount The number of vCPUs for the database.
         * 
         * @return builder
         * 
         */
        public Builder cpuCount(@Nullable Output<Integer> cpuCount) {
            $.cpuCount = cpuCount;
            return this;
        }

        /**
         * @param cpuCount The number of vCPUs for the database.
         * 
         * @return builder
         * 
         */
        public Builder cpuCount(Integer cpuCount) {
            return cpuCount(Output.of(cpuCount));
        }

        /**
         * @param createdAt The timestamp when the instance was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(@Nullable Output<String> createdAt) {
            $.createdAt = createdAt;
            return this;
        }

        /**
         * @param createdAt The timestamp when the instance was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(String createdAt) {
            return createdAt(Output.of(createdAt));
        }

        /**
         * @param diskSize The size of the disk for the database.
         * 
         * @return builder
         * 
         */
        public Builder diskSize(@Nullable Output<Double> diskSize) {
            $.diskSize = diskSize;
            return this;
        }

        /**
         * @param diskSize The size of the disk for the database.
         * 
         * @return builder
         * 
         */
        public Builder diskSize(Double diskSize) {
            return diskSize(Output.of(diskSize));
        }

        /**
         * @param engine The database software (for example, MySQL).
         * 
         * @return builder
         * 
         */
        public Builder engine(@Nullable Output<String> engine) {
            $.engine = engine;
            return this;
        }

        /**
         * @param engine The database software (for example, MySQL).
         * 
         * @return builder
         * 
         */
        public Builder engine(String engine) {
            return engine(Output.of(engine));
        }

        /**
         * @param engineVersion The database engine version (for example, 5.7.23).
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(@Nullable Output<String> engineVersion) {
            $.engineVersion = engineVersion;
            return this;
        }

        /**
         * @param engineVersion The database engine version (for example, 5.7.23).
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(String engineVersion) {
            return engineVersion(Output.of(engineVersion));
        }

        /**
         * @param finalSnapshotName The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotName(@Nullable Output<String> finalSnapshotName) {
            $.finalSnapshotName = finalSnapshotName;
            return this;
        }

        /**
         * @param finalSnapshotName The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotName(String finalSnapshotName) {
            return finalSnapshotName(Output.of(finalSnapshotName));
        }

        /**
         * @param masterDatabaseName The name of the master database created when the Lightsail database resource is created.
         * 
         * @return builder
         * 
         */
        public Builder masterDatabaseName(@Nullable Output<String> masterDatabaseName) {
            $.masterDatabaseName = masterDatabaseName;
            return this;
        }

        /**
         * @param masterDatabaseName The name of the master database created when the Lightsail database resource is created.
         * 
         * @return builder
         * 
         */
        public Builder masterDatabaseName(String masterDatabaseName) {
            return masterDatabaseName(Output.of(masterDatabaseName));
        }

        /**
         * @param masterEndpointAddress The master endpoint fqdn for the database.
         * 
         * @return builder
         * 
         */
        public Builder masterEndpointAddress(@Nullable Output<String> masterEndpointAddress) {
            $.masterEndpointAddress = masterEndpointAddress;
            return this;
        }

        /**
         * @param masterEndpointAddress The master endpoint fqdn for the database.
         * 
         * @return builder
         * 
         */
        public Builder masterEndpointAddress(String masterEndpointAddress) {
            return masterEndpointAddress(Output.of(masterEndpointAddress));
        }

        /**
         * @param masterEndpointPort The master endpoint network port for the database.
         * 
         * @return builder
         * 
         */
        public Builder masterEndpointPort(@Nullable Output<Integer> masterEndpointPort) {
            $.masterEndpointPort = masterEndpointPort;
            return this;
        }

        /**
         * @param masterEndpointPort The master endpoint network port for the database.
         * 
         * @return builder
         * 
         */
        public Builder masterEndpointPort(Integer masterEndpointPort) {
            return masterEndpointPort(Output.of(masterEndpointPort));
        }

        /**
         * @param masterPassword The password for the master user of your new database. The password can include any printable ASCII character except &#34;/&#34;, &#34;&#34;&#34;, or &#34;@&#34;.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(@Nullable Output<String> masterPassword) {
            $.masterPassword = masterPassword;
            return this;
        }

        /**
         * @param masterPassword The password for the master user of your new database. The password can include any printable ASCII character except &#34;/&#34;, &#34;&#34;&#34;, or &#34;@&#34;.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(String masterPassword) {
            return masterPassword(Output.of(masterPassword));
        }

        /**
         * @param masterUsername The master user name for your new database.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(@Nullable Output<String> masterUsername) {
            $.masterUsername = masterUsername;
            return this;
        }

        /**
         * @param masterUsername The master user name for your new database.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(String masterUsername) {
            return masterUsername(Output.of(masterUsername));
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(@Nullable Output<String> preferredBackupWindow) {
            $.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(String preferredBackupWindow) {
            return preferredBackupWindow(Output.of(preferredBackupWindow));
        }

        /**
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(@Nullable Output<String> preferredMaintenanceWindow) {
            $.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            return preferredMaintenanceWindow(Output.of(preferredMaintenanceWindow));
        }

        /**
         * @param publiclyAccessible Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(@Nullable Output<Boolean> publiclyAccessible) {
            $.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * @param publiclyAccessible Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            return publiclyAccessible(Output.of(publiclyAccessible));
        }

        /**
         * @param ramSize The amount of RAM in GB for the database.
         * 
         * @return builder
         * 
         */
        public Builder ramSize(@Nullable Output<Double> ramSize) {
            $.ramSize = ramSize;
            return this;
        }

        /**
         * @param ramSize The amount of RAM in GB for the database.
         * 
         * @return builder
         * 
         */
        public Builder ramSize(Double ramSize) {
            return ramSize(Output.of(ramSize));
        }

        /**
         * @param relationalDatabaseName The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder relationalDatabaseName(@Nullable Output<String> relationalDatabaseName) {
            $.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        /**
         * @param relationalDatabaseName The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder relationalDatabaseName(String relationalDatabaseName) {
            return relationalDatabaseName(Output.of(relationalDatabaseName));
        }

        /**
         * @param secondaryAvailabilityZone Describes the secondary Availability Zone of a high availability database. The secondary database is used for failover support of a high availability database.
         * 
         * @return builder
         * 
         */
        public Builder secondaryAvailabilityZone(@Nullable Output<String> secondaryAvailabilityZone) {
            $.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        /**
         * @param secondaryAvailabilityZone Describes the secondary Availability Zone of a high availability database. The secondary database is used for failover support of a high availability database.
         * 
         * @return builder
         * 
         */
        public Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            return secondaryAvailabilityZone(Output.of(secondaryAvailabilityZone));
        }

        /**
         * @param skipFinalSnapshot Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(@Nullable Output<Boolean> skipFinalSnapshot) {
            $.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        /**
         * @param skipFinalSnapshot Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            return skipFinalSnapshot(Output.of(skipFinalSnapshot));
        }

        /**
         * @param supportCode The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         * 
         * @return builder
         * 
         */
        public Builder supportCode(@Nullable Output<String> supportCode) {
            $.supportCode = supportCode;
            return this;
        }

        /**
         * @param supportCode The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         * 
         * @return builder
         * 
         */
        public Builder supportCode(String supportCode) {
            return supportCode(Output.of(supportCode));
        }

        /**
         * @param tags A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        public DatabaseState build() {
            return $;
        }
    }

}
