// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail.inputs;

import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessArgs;
import com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ContainerServiceState extends com.pulumi.resources.ResourceArgs {

    public static final ContainerServiceState Empty = new ContainerServiceState();

    /**
     * The Amazon Resource Name (ARN) of the container service.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the container service.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The Availability Zone. Follows the format us-east-2a (case-sensitive).
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return The Availability Zone. Follows the format us-east-2a (case-sensitive).
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    @Import(name="createdAt")
    private @Nullable Output<String> createdAt;

    public Optional<Output<String>> createdAt() {
        return Optional.ofNullable(this.createdAt);
    }

    /**
     * A Boolean value indicating whether the container service is disabled. Defaults to `false`.
     * 
     */
    @Import(name="isDisabled")
    private @Nullable Output<Boolean> isDisabled;

    /**
     * @return A Boolean value indicating whether the container service is disabled. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> isDisabled() {
        return Optional.ofNullable(this.isDisabled);
    }

    /**
     * The name for the container service. Names must be of length 1 to 63, and be
     * unique within each AWS Region in your Lightsail account.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name for the container service. Names must be of length 1 to 63, and be
     * unique within each AWS Region in your Lightsail account.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The power specification for the container service. The power specifies the amount of memory,
     * the number of vCPUs, and the monthly price of each node of the container service.
     * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
     * 
     */
    @Import(name="power")
    private @Nullable Output<String> power;

    /**
     * @return The power specification for the container service. The power specifies the amount of memory,
     * the number of vCPUs, and the monthly price of each node of the container service.
     * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
     * 
     */
    public Optional<Output<String>> power() {
        return Optional.ofNullable(this.power);
    }

    /**
     * The ID of the power of the container service.
     * 
     */
    @Import(name="powerId")
    private @Nullable Output<String> powerId;

    /**
     * @return The ID of the power of the container service.
     * 
     */
    public Optional<Output<String>> powerId() {
        return Optional.ofNullable(this.powerId);
    }

    /**
     * The principal ARN of the container service. The principal ARN can be used to create a trust
     * relationship between your standard AWS account and your Lightsail container service. This allows you to give your
     * service permission to access resources in your standard AWS account.
     * 
     */
    @Import(name="principalArn")
    private @Nullable Output<String> principalArn;

    /**
     * @return The principal ARN of the container service. The principal ARN can be used to create a trust
     * relationship between your standard AWS account and your Lightsail container service. This allows you to give your
     * service permission to access resources in your standard AWS account.
     * 
     */
    public Optional<Output<String>> principalArn() {
        return Optional.ofNullable(this.principalArn);
    }

    /**
     * The private domain name of the container service. The private domain name is accessible only
     * by other resources within the default virtual private cloud (VPC) of your Lightsail account.
     * 
     */
    @Import(name="privateDomainName")
    private @Nullable Output<String> privateDomainName;

    /**
     * @return The private domain name of the container service. The private domain name is accessible only
     * by other resources within the default virtual private cloud (VPC) of your Lightsail account.
     * 
     */
    public Optional<Output<String>> privateDomainName() {
        return Optional.ofNullable(this.privateDomainName);
    }

    /**
     * An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     * 
     */
    @Import(name="privateRegistryAccess")
    private @Nullable Output<ContainerServicePrivateRegistryAccessArgs> privateRegistryAccess;

    /**
     * @return An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     * 
     */
    public Optional<Output<ContainerServicePrivateRegistryAccessArgs>> privateRegistryAccess() {
        return Optional.ofNullable(this.privateRegistryAccess);
    }

    /**
     * The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don&#39;t specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     * 
     */
    @Import(name="publicDomainNames")
    private @Nullable Output<ContainerServicePublicDomainNamesArgs> publicDomainNames;

    /**
     * @return The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don&#39;t specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     * 
     */
    public Optional<Output<ContainerServicePublicDomainNamesArgs>> publicDomainNames() {
        return Optional.ofNullable(this.publicDomainNames);
    }

    /**
     * The Lightsail resource type of the container service (i.e., ContainerService).
     * 
     */
    @Import(name="resourceType")
    private @Nullable Output<String> resourceType;

    /**
     * @return The Lightsail resource type of the container service (i.e., ContainerService).
     * 
     */
    public Optional<Output<String>> resourceType() {
        return Optional.ofNullable(this.resourceType);
    }

    /**
     * The scale specification for the container service. The scale specifies the allocated compute
     * nodes of the container service.
     * 
     */
    @Import(name="scale")
    private @Nullable Output<Integer> scale;

    /**
     * @return The scale specification for the container service. The scale specifies the allocated compute
     * nodes of the container service.
     * 
     */
    public Optional<Output<Integer>> scale() {
        return Optional.ofNullable(this.scale);
    }

    /**
     * The current state of the container service.
     * 
     */
    @Import(name="state")
    private @Nullable Output<String> state;

    /**
     * @return The current state of the container service.
     * 
     */
    public Optional<Output<String>> state() {
        return Optional.ofNullable(this.state);
    }

    /**
     * Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider
     * `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider
     * `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * The publicly accessible URL of the container service. If no public endpoint is specified in the
     * currentDeployment, this URL returns a 404 response.
     * 
     */
    @Import(name="url")
    private @Nullable Output<String> url;

    /**
     * @return The publicly accessible URL of the container service. If no public endpoint is specified in the
     * currentDeployment, this URL returns a 404 response.
     * 
     */
    public Optional<Output<String>> url() {
        return Optional.ofNullable(this.url);
    }

    private ContainerServiceState() {}

    private ContainerServiceState(ContainerServiceState $) {
        this.arn = $.arn;
        this.availabilityZone = $.availabilityZone;
        this.createdAt = $.createdAt;
        this.isDisabled = $.isDisabled;
        this.name = $.name;
        this.power = $.power;
        this.powerId = $.powerId;
        this.principalArn = $.principalArn;
        this.privateDomainName = $.privateDomainName;
        this.privateRegistryAccess = $.privateRegistryAccess;
        this.publicDomainNames = $.publicDomainNames;
        this.resourceType = $.resourceType;
        this.scale = $.scale;
        this.state = $.state;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.url = $.url;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ContainerServiceState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerServiceState $;

        public Builder() {
            $ = new ContainerServiceState();
        }

        public Builder(ContainerServiceState defaults) {
            $ = new ContainerServiceState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn The Amazon Resource Name (ARN) of the container service.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn The Amazon Resource Name (ARN) of the container service.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param availabilityZone The Availability Zone. Follows the format us-east-2a (case-sensitive).
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone The Availability Zone. Follows the format us-east-2a (case-sensitive).
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        public Builder createdAt(@Nullable Output<String> createdAt) {
            $.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            return createdAt(Output.of(createdAt));
        }

        /**
         * @param isDisabled A Boolean value indicating whether the container service is disabled. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder isDisabled(@Nullable Output<Boolean> isDisabled) {
            $.isDisabled = isDisabled;
            return this;
        }

        /**
         * @param isDisabled A Boolean value indicating whether the container service is disabled. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder isDisabled(Boolean isDisabled) {
            return isDisabled(Output.of(isDisabled));
        }

        /**
         * @param name The name for the container service. Names must be of length 1 to 63, and be
         * unique within each AWS Region in your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name for the container service. Names must be of length 1 to 63, and be
         * unique within each AWS Region in your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param power The power specification for the container service. The power specifies the amount of memory,
         * the number of vCPUs, and the monthly price of each node of the container service.
         * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
         * 
         * @return builder
         * 
         */
        public Builder power(@Nullable Output<String> power) {
            $.power = power;
            return this;
        }

        /**
         * @param power The power specification for the container service. The power specifies the amount of memory,
         * the number of vCPUs, and the monthly price of each node of the container service.
         * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
         * 
         * @return builder
         * 
         */
        public Builder power(String power) {
            return power(Output.of(power));
        }

        /**
         * @param powerId The ID of the power of the container service.
         * 
         * @return builder
         * 
         */
        public Builder powerId(@Nullable Output<String> powerId) {
            $.powerId = powerId;
            return this;
        }

        /**
         * @param powerId The ID of the power of the container service.
         * 
         * @return builder
         * 
         */
        public Builder powerId(String powerId) {
            return powerId(Output.of(powerId));
        }

        /**
         * @param principalArn The principal ARN of the container service. The principal ARN can be used to create a trust
         * relationship between your standard AWS account and your Lightsail container service. This allows you to give your
         * service permission to access resources in your standard AWS account.
         * 
         * @return builder
         * 
         */
        public Builder principalArn(@Nullable Output<String> principalArn) {
            $.principalArn = principalArn;
            return this;
        }

        /**
         * @param principalArn The principal ARN of the container service. The principal ARN can be used to create a trust
         * relationship between your standard AWS account and your Lightsail container service. This allows you to give your
         * service permission to access resources in your standard AWS account.
         * 
         * @return builder
         * 
         */
        public Builder principalArn(String principalArn) {
            return principalArn(Output.of(principalArn));
        }

        /**
         * @param privateDomainName The private domain name of the container service. The private domain name is accessible only
         * by other resources within the default virtual private cloud (VPC) of your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder privateDomainName(@Nullable Output<String> privateDomainName) {
            $.privateDomainName = privateDomainName;
            return this;
        }

        /**
         * @param privateDomainName The private domain name of the container service. The private domain name is accessible only
         * by other resources within the default virtual private cloud (VPC) of your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder privateDomainName(String privateDomainName) {
            return privateDomainName(Output.of(privateDomainName));
        }

        /**
         * @param privateRegistryAccess An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
         * 
         * @return builder
         * 
         */
        public Builder privateRegistryAccess(@Nullable Output<ContainerServicePrivateRegistryAccessArgs> privateRegistryAccess) {
            $.privateRegistryAccess = privateRegistryAccess;
            return this;
        }

        /**
         * @param privateRegistryAccess An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
         * 
         * @return builder
         * 
         */
        public Builder privateRegistryAccess(ContainerServicePrivateRegistryAccessArgs privateRegistryAccess) {
            return privateRegistryAccess(Output.of(privateRegistryAccess));
        }

        /**
         * @param publicDomainNames The public domain names to use with the container service, such as example.com
         * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
         * specify are used when you create a deployment with a container configured as the public endpoint of your container
         * service. If you don&#39;t specify public domain names, then you can use the default domain of the container service.
         * Defined below.
         * 
         * @return builder
         * 
         */
        public Builder publicDomainNames(@Nullable Output<ContainerServicePublicDomainNamesArgs> publicDomainNames) {
            $.publicDomainNames = publicDomainNames;
            return this;
        }

        /**
         * @param publicDomainNames The public domain names to use with the container service, such as example.com
         * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
         * specify are used when you create a deployment with a container configured as the public endpoint of your container
         * service. If you don&#39;t specify public domain names, then you can use the default domain of the container service.
         * Defined below.
         * 
         * @return builder
         * 
         */
        public Builder publicDomainNames(ContainerServicePublicDomainNamesArgs publicDomainNames) {
            return publicDomainNames(Output.of(publicDomainNames));
        }

        /**
         * @param resourceType The Lightsail resource type of the container service (i.e., ContainerService).
         * 
         * @return builder
         * 
         */
        public Builder resourceType(@Nullable Output<String> resourceType) {
            $.resourceType = resourceType;
            return this;
        }

        /**
         * @param resourceType The Lightsail resource type of the container service (i.e., ContainerService).
         * 
         * @return builder
         * 
         */
        public Builder resourceType(String resourceType) {
            return resourceType(Output.of(resourceType));
        }

        /**
         * @param scale The scale specification for the container service. The scale specifies the allocated compute
         * nodes of the container service.
         * 
         * @return builder
         * 
         */
        public Builder scale(@Nullable Output<Integer> scale) {
            $.scale = scale;
            return this;
        }

        /**
         * @param scale The scale specification for the container service. The scale specifies the allocated compute
         * nodes of the container service.
         * 
         * @return builder
         * 
         */
        public Builder scale(Integer scale) {
            return scale(Output.of(scale));
        }

        /**
         * @param state The current state of the container service.
         * 
         * @return builder
         * 
         */
        public Builder state(@Nullable Output<String> state) {
            $.state = state;
            return this;
        }

        /**
         * @param state The current state of the container service.
         * 
         * @return builder
         * 
         */
        public Builder state(String state) {
            return state(Output.of(state));
        }

        /**
         * @param tags Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
         * configured with a provider
         * `default_tags` configuration block
         * present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
         * configured with a provider
         * `default_tags` configuration block
         * present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider
         * `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider
         * `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param url The publicly accessible URL of the container service. If no public endpoint is specified in the
         * currentDeployment, this URL returns a 404 response.
         * 
         * @return builder
         * 
         */
        public Builder url(@Nullable Output<String> url) {
            $.url = url;
            return this;
        }

        /**
         * @param url The publicly accessible URL of the container service. If no public endpoint is specified in the
         * currentDeployment, this URL returns a 404 response.
         * 
         * @return builder
         * 
         */
        public Builder url(String url) {
            return url(Output.of(url));
        }

        public ContainerServiceState build() {
            return $;
        }
    }

}
