// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.lightsail.StaticIpArgs;
import com.pulumi.aws.lightsail.inputs.StaticIpState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Allocates a static IP address.
 * 
 * &gt; **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see [&#34;Regions and Availability Zones in Amazon Lightsail&#34;](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new StaticIp(&#34;test&#34;);
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:lightsail/staticIp:StaticIp")
public class StaticIp extends com.pulumi.resources.CustomResource {
    /**
     * The ARN of the Lightsail static IP
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the Lightsail static IP
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The allocated static IP address
     * 
     */
    @Export(name="ipAddress", refs={String.class}, tree="[0]")
    private Output<String> ipAddress;

    /**
     * @return The allocated static IP address
     * 
     */
    public Output<String> ipAddress() {
        return this.ipAddress;
    }
    /**
     * The name for the allocated static IP
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name for the allocated static IP
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The support code.
     * 
     */
    @Export(name="supportCode", refs={String.class}, tree="[0]")
    private Output<String> supportCode;

    /**
     * @return The support code.
     * 
     */
    public Output<String> supportCode() {
        return this.supportCode;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public StaticIp(String name) {
        this(name, StaticIpArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public StaticIp(String name, @Nullable StaticIpArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public StaticIp(String name, @Nullable StaticIpArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lightsail/staticIp:StaticIp", name, args == null ? StaticIpArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private StaticIp(String name, Output<String> id, @Nullable StaticIpState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lightsail/staticIp:StaticIp", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static StaticIp get(String name, Output<String> id, @Nullable StaticIpState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new StaticIp(name, id, state, options);
    }
}
