// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.lightsail.LbStickinessPolicyArgs;
import com.pulumi.aws.lightsail.inputs.LbStickinessPolicyState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Configures Session Stickiness for a Lightsail Load Balancer.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbStickinessPolicy;
 * import com.pulumi.aws.lightsail.LbStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var testLb = new Lb(&#34;testLb&#34;, LbArgs.builder()        
 *             .healthCheckPath(&#34;/&#34;)
 *             .instancePort(&#34;80&#34;)
 *             .tags(Map.of(&#34;foo&#34;, &#34;bar&#34;))
 *             .build());
 * 
 *         var testLbStickinessPolicy = new LbStickinessPolicy(&#34;testLbStickinessPolicy&#34;, LbStickinessPolicyArgs.builder()        
 *             .lbName(testLb.name())
 *             .cookieDuration(900)
 *             .enabled(true)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_lightsail_lb_stickiness_policy` using the `lb_name` attribute. For example:
 * 
 * ```sh
 *  $ pulumi import aws:lightsail/lbStickinessPolicy:LbStickinessPolicy test example-load-balancer
 * ```
 * 
 */
@ResourceType(type="aws:lightsail/lbStickinessPolicy:LbStickinessPolicy")
public class LbStickinessPolicy extends com.pulumi.resources.CustomResource {
    /**
     * The cookie duration in seconds. This determines the length of the session stickiness.
     * 
     */
    @Export(name="cookieDuration", refs={Integer.class}, tree="[0]")
    private Output<Integer> cookieDuration;

    /**
     * @return The cookie duration in seconds. This determines the length of the session stickiness.
     * 
     */
    public Output<Integer> cookieDuration() {
        return this.cookieDuration;
    }
    /**
     * The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
     * 
     */
    @Export(name="enabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> enabled;

    /**
     * @return The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
     * 
     */
    public Output<Boolean> enabled() {
        return this.enabled;
    }
    /**
     * The name of the load balancer to which you want to enable session stickiness.
     * 
     */
    @Export(name="lbName", refs={String.class}, tree="[0]")
    private Output<String> lbName;

    /**
     * @return The name of the load balancer to which you want to enable session stickiness.
     * 
     */
    public Output<String> lbName() {
        return this.lbName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LbStickinessPolicy(String name) {
        this(name, LbStickinessPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LbStickinessPolicy(String name, LbStickinessPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LbStickinessPolicy(String name, LbStickinessPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lightsail/lbStickinessPolicy:LbStickinessPolicy", name, args == null ? LbStickinessPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LbStickinessPolicy(String name, Output<String> id, @Nullable LbStickinessPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lightsail/lbStickinessPolicy:LbStickinessPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LbStickinessPolicy get(String name, Output<String> id, @Nullable LbStickinessPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LbStickinessPolicy(name, id, state, options);
    }
}
