// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.lightsail.LbAttachmentArgs;
import com.pulumi.aws.lightsail.inputs.LbAttachmentState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Attaches a Lightsail Instance to a Lightsail Load Balancer.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.LbAttachment;
 * import com.pulumi.aws.lightsail.LbAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state(&#34;available&#34;)
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name(&#34;opt-in-status&#34;)
 *                 .values(&#34;opt-in-not-required&#34;)
 *                 .build())
 *             .build());
 * 
 *         var testLb = new Lb(&#34;testLb&#34;, LbArgs.builder()        
 *             .healthCheckPath(&#34;/&#34;)
 *             .instancePort(&#34;80&#34;)
 *             .tags(Map.of(&#34;foo&#34;, &#34;bar&#34;))
 *             .build());
 * 
 *         var testInstance = new Instance(&#34;testInstance&#34;, InstanceArgs.builder()        
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]))
 *             .blueprintId(&#34;amazon_linux_2&#34;)
 *             .bundleId(&#34;nano_1_0&#34;)
 *             .build());
 * 
 *         var testLbAttachment = new LbAttachment(&#34;testLbAttachment&#34;, LbAttachmentArgs.builder()        
 *             .lbName(testLb.name())
 *             .instanceName(testInstance.name())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_lightsail_lb_attachment` using the name attribute. For example:
 * 
 * ```sh
 *  $ pulumi import aws:lightsail/lbAttachment:LbAttachment test example-load-balancer,example-instance
 * ```
 * 
 */
@ResourceType(type="aws:lightsail/lbAttachment:LbAttachment")
public class LbAttachment extends com.pulumi.resources.CustomResource {
    /**
     * The name of the instance to attach to the load balancer.
     * 
     */
    @Export(name="instanceName", refs={String.class}, tree="[0]")
    private Output<String> instanceName;

    /**
     * @return The name of the instance to attach to the load balancer.
     * 
     */
    public Output<String> instanceName() {
        return this.instanceName;
    }
    /**
     * The name of the Lightsail load balancer.
     * 
     */
    @Export(name="lbName", refs={String.class}, tree="[0]")
    private Output<String> lbName;

    /**
     * @return The name of the Lightsail load balancer.
     * 
     */
    public Output<String> lbName() {
        return this.lbName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LbAttachment(String name) {
        this(name, LbAttachmentArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LbAttachment(String name, LbAttachmentArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LbAttachment(String name, LbAttachmentArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lightsail/lbAttachment:LbAttachment", name, args == null ? LbAttachmentArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LbAttachment(String name, Output<String> id, @Nullable LbAttachmentState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lightsail/lbAttachment:LbAttachment", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LbAttachment get(String name, Output<String> id, @Nullable LbAttachmentState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LbAttachment(name, id, state, options);
    }
}
