// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.lightsail.Disk_attachmentArgs;
import com.pulumi.aws.lightsail.inputs.Disk_attachmentState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Attaches a Lightsail disk to a Lightsail Instance
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Disk;
 * import com.pulumi.aws.lightsail.DiskArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.Disk_attachment;
 * import com.pulumi.aws.lightsail.Disk_attachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state(&#34;available&#34;)
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name(&#34;opt-in-status&#34;)
 *                 .values(&#34;opt-in-not-required&#34;)
 *                 .build())
 *             .build());
 * 
 *         var testDisk = new Disk(&#34;testDisk&#34;, DiskArgs.builder()        
 *             .sizeInGb(8)
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]))
 *             .build());
 * 
 *         var testInstance = new Instance(&#34;testInstance&#34;, InstanceArgs.builder()        
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -&gt; getAvailabilityZonesResult.names()[0]))
 *             .blueprintId(&#34;amazon_linux_2&#34;)
 *             .bundleId(&#34;nano_1_0&#34;)
 *             .build());
 * 
 *         var testDisk_attachment = new Disk_attachment(&#34;testDisk_attachment&#34;, Disk_attachmentArgs.builder()        
 *             .diskName(testDisk.name())
 *             .instanceName(testInstance.name())
 *             .diskPath(&#34;/dev/xvdf&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_lightsail_disk` using the id attribute. For example:
 * 
 * ```sh
 *  $ pulumi import aws:lightsail/disk_attachment:Disk_attachment test test-disk,test-instance
 * ```
 * 
 */
@ResourceType(type="aws:lightsail/disk_attachment:Disk_attachment")
public class Disk_attachment extends com.pulumi.resources.CustomResource {
    /**
     * The name of the Lightsail Disk.
     * 
     */
    @Export(name="diskName", refs={String.class}, tree="[0]")
    private Output<String> diskName;

    /**
     * @return The name of the Lightsail Disk.
     * 
     */
    public Output<String> diskName() {
        return this.diskName;
    }
    /**
     * The disk path to expose to the instance.
     * 
     */
    @Export(name="diskPath", refs={String.class}, tree="[0]")
    private Output<String> diskPath;

    /**
     * @return The disk path to expose to the instance.
     * 
     */
    public Output<String> diskPath() {
        return this.diskPath;
    }
    /**
     * The name of the Lightsail Instance to attach to.
     * 
     */
    @Export(name="instanceName", refs={String.class}, tree="[0]")
    private Output<String> instanceName;

    /**
     * @return The name of the Lightsail Instance to attach to.
     * 
     */
    public Output<String> instanceName() {
        return this.instanceName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Disk_attachment(String name) {
        this(name, Disk_attachmentArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Disk_attachment(String name, Disk_attachmentArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Disk_attachment(String name, Disk_attachmentArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lightsail/disk_attachment:Disk_attachment", name, args == null ? Disk_attachmentArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Disk_attachment(String name, Output<String> id, @Nullable Disk_attachmentState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lightsail/disk_attachment:Disk_attachment", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Disk_attachment get(String name, Output<String> id, @Nullable Disk_attachmentState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Disk_attachment(name, id, state, options);
    }
}
