// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DatabaseArgs extends com.pulumi.resources.ResourceArgs {

    public static final DatabaseArgs Empty = new DatabaseArgs();

    /**
     * When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
     * 
     */
    @Import(name="backupRetentionEnabled")
    private @Nullable Output<Boolean> backupRetentionEnabled;

    /**
     * @return When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
     * 
     */
    public Optional<Output<Boolean>> backupRetentionEnabled() {
        return Optional.ofNullable(this.backupRetentionEnabled);
    }

    /**
     * The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
     * 
     */
    @Import(name="blueprintId", required=true)
    private Output<String> blueprintId;

    /**
     * @return The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
     * 
     */
    public Output<String> blueprintId() {
        return this.blueprintId;
    }

    /**
     * The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
     * 
     */
    @Import(name="bundleId", required=true)
    private Output<String> bundleId;

    /**
     * @return The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
     * 
     */
    public Output<String> bundleId() {
        return this.bundleId;
    }

    /**
     * The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
     * 
     */
    @Import(name="finalSnapshotName")
    private @Nullable Output<String> finalSnapshotName;

    /**
     * @return The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
     * 
     */
    public Optional<Output<String>> finalSnapshotName() {
        return Optional.ofNullable(this.finalSnapshotName);
    }

    /**
     * The name of the master database created when the Lightsail database resource is created.
     * 
     */
    @Import(name="masterDatabaseName", required=true)
    private Output<String> masterDatabaseName;

    /**
     * @return The name of the master database created when the Lightsail database resource is created.
     * 
     */
    public Output<String> masterDatabaseName() {
        return this.masterDatabaseName;
    }

    /**
     * The password for the master user of your new database. The password can include any printable ASCII character except &#34;/&#34;, &#34;&#34;&#34;, or &#34;@&#34;.
     * 
     */
    @Import(name="masterPassword", required=true)
    private Output<String> masterPassword;

    /**
     * @return The password for the master user of your new database. The password can include any printable ASCII character except &#34;/&#34;, &#34;&#34;&#34;, or &#34;@&#34;.
     * 
     */
    public Output<String> masterPassword() {
        return this.masterPassword;
    }

    /**
     * The master user name for your new database.
     * 
     */
    @Import(name="masterUsername", required=true)
    private Output<String> masterUsername;

    /**
     * @return The master user name for your new database.
     * 
     */
    public Output<String> masterUsername() {
        return this.masterUsername;
    }

    /**
     * The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
     * 
     */
    @Import(name="preferredBackupWindow")
    private @Nullable Output<String> preferredBackupWindow;

    /**
     * @return The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
     * 
     */
    public Optional<Output<String>> preferredBackupWindow() {
        return Optional.ofNullable(this.preferredBackupWindow);
    }

    /**
     * The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
     * 
     */
    @Import(name="preferredMaintenanceWindow")
    private @Nullable Output<String> preferredMaintenanceWindow;

    /**
     * @return The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
     * 
     */
    public Optional<Output<String>> preferredMaintenanceWindow() {
        return Optional.ofNullable(this.preferredMaintenanceWindow);
    }

    /**
     * Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
     * 
     */
    @Import(name="publiclyAccessible")
    private @Nullable Output<Boolean> publiclyAccessible;

    /**
     * @return Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
     * 
     */
    public Optional<Output<Boolean>> publiclyAccessible() {
        return Optional.ofNullable(this.publiclyAccessible);
    }

    /**
     * The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
     * 
     */
    @Import(name="relationalDatabaseName", required=true)
    private Output<String> relationalDatabaseName;

    /**
     * @return The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
     * 
     */
    public Output<String> relationalDatabaseName() {
        return this.relationalDatabaseName;
    }

    /**
     * Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
     * 
     */
    @Import(name="skipFinalSnapshot")
    private @Nullable Output<Boolean> skipFinalSnapshot;

    /**
     * @return Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
     * 
     */
    public Optional<Output<Boolean>> skipFinalSnapshot() {
        return Optional.ofNullable(this.skipFinalSnapshot);
    }

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private DatabaseArgs() {}

    private DatabaseArgs(DatabaseArgs $) {
        this.applyImmediately = $.applyImmediately;
        this.availabilityZone = $.availabilityZone;
        this.backupRetentionEnabled = $.backupRetentionEnabled;
        this.blueprintId = $.blueprintId;
        this.bundleId = $.bundleId;
        this.finalSnapshotName = $.finalSnapshotName;
        this.masterDatabaseName = $.masterDatabaseName;
        this.masterPassword = $.masterPassword;
        this.masterUsername = $.masterUsername;
        this.preferredBackupWindow = $.preferredBackupWindow;
        this.preferredMaintenanceWindow = $.preferredMaintenanceWindow;
        this.publiclyAccessible = $.publiclyAccessible;
        this.relationalDatabaseName = $.relationalDatabaseName;
        this.skipFinalSnapshot = $.skipFinalSnapshot;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DatabaseArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DatabaseArgs $;

        public Builder() {
            $ = new DatabaseArgs();
        }

        public Builder(DatabaseArgs defaults) {
            $ = new DatabaseArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param applyImmediately When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param availabilityZone The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param backupRetentionEnabled When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
         * 
         * @return builder
         * 
         */
        public Builder backupRetentionEnabled(@Nullable Output<Boolean> backupRetentionEnabled) {
            $.backupRetentionEnabled = backupRetentionEnabled;
            return this;
        }

        /**
         * @param backupRetentionEnabled When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
         * 
         * @return builder
         * 
         */
        public Builder backupRetentionEnabled(Boolean backupRetentionEnabled) {
            return backupRetentionEnabled(Output.of(backupRetentionEnabled));
        }

        /**
         * @param blueprintId The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
         * 
         * @return builder
         * 
         */
        public Builder blueprintId(Output<String> blueprintId) {
            $.blueprintId = blueprintId;
            return this;
        }

        /**
         * @param blueprintId The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
         * 
         * @return builder
         * 
         */
        public Builder blueprintId(String blueprintId) {
            return blueprintId(Output.of(blueprintId));
        }

        /**
         * @param bundleId The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
         * 
         * @return builder
         * 
         */
        public Builder bundleId(Output<String> bundleId) {
            $.bundleId = bundleId;
            return this;
        }

        /**
         * @param bundleId The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
         * 
         * @return builder
         * 
         */
        public Builder bundleId(String bundleId) {
            return bundleId(Output.of(bundleId));
        }

        /**
         * @param finalSnapshotName The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotName(@Nullable Output<String> finalSnapshotName) {
            $.finalSnapshotName = finalSnapshotName;
            return this;
        }

        /**
         * @param finalSnapshotName The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotName(String finalSnapshotName) {
            return finalSnapshotName(Output.of(finalSnapshotName));
        }

        /**
         * @param masterDatabaseName The name of the master database created when the Lightsail database resource is created.
         * 
         * @return builder
         * 
         */
        public Builder masterDatabaseName(Output<String> masterDatabaseName) {
            $.masterDatabaseName = masterDatabaseName;
            return this;
        }

        /**
         * @param masterDatabaseName The name of the master database created when the Lightsail database resource is created.
         * 
         * @return builder
         * 
         */
        public Builder masterDatabaseName(String masterDatabaseName) {
            return masterDatabaseName(Output.of(masterDatabaseName));
        }

        /**
         * @param masterPassword The password for the master user of your new database. The password can include any printable ASCII character except &#34;/&#34;, &#34;&#34;&#34;, or &#34;@&#34;.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(Output<String> masterPassword) {
            $.masterPassword = masterPassword;
            return this;
        }

        /**
         * @param masterPassword The password for the master user of your new database. The password can include any printable ASCII character except &#34;/&#34;, &#34;&#34;&#34;, or &#34;@&#34;.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(String masterPassword) {
            return masterPassword(Output.of(masterPassword));
        }

        /**
         * @param masterUsername The master user name for your new database.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(Output<String> masterUsername) {
            $.masterUsername = masterUsername;
            return this;
        }

        /**
         * @param masterUsername The master user name for your new database.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(String masterUsername) {
            return masterUsername(Output.of(masterUsername));
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(@Nullable Output<String> preferredBackupWindow) {
            $.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(String preferredBackupWindow) {
            return preferredBackupWindow(Output.of(preferredBackupWindow));
        }

        /**
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(@Nullable Output<String> preferredMaintenanceWindow) {
            $.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            return preferredMaintenanceWindow(Output.of(preferredMaintenanceWindow));
        }

        /**
         * @param publiclyAccessible Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(@Nullable Output<Boolean> publiclyAccessible) {
            $.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * @param publiclyAccessible Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            return publiclyAccessible(Output.of(publiclyAccessible));
        }

        /**
         * @param relationalDatabaseName The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder relationalDatabaseName(Output<String> relationalDatabaseName) {
            $.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        /**
         * @param relationalDatabaseName The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder relationalDatabaseName(String relationalDatabaseName) {
            return relationalDatabaseName(Output.of(relationalDatabaseName));
        }

        /**
         * @param skipFinalSnapshot Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(@Nullable Output<Boolean> skipFinalSnapshot) {
            $.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        /**
         * @param skipFinalSnapshot Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            return skipFinalSnapshot(Output.of(skipFinalSnapshot));
        }

        /**
         * @param tags A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public DatabaseArgs build() {
            $.blueprintId = Objects.requireNonNull($.blueprintId, "expected parameter 'blueprintId' to be non-null");
            $.bundleId = Objects.requireNonNull($.bundleId, "expected parameter 'bundleId' to be non-null");
            $.masterDatabaseName = Objects.requireNonNull($.masterDatabaseName, "expected parameter 'masterDatabaseName' to be non-null");
            $.masterPassword = Objects.requireNonNull($.masterPassword, "expected parameter 'masterPassword' to be non-null");
            $.masterUsername = Objects.requireNonNull($.masterUsername, "expected parameter 'masterUsername' to be non-null");
            $.relationalDatabaseName = Objects.requireNonNull($.relationalDatabaseName, "expected parameter 'relationalDatabaseName' to be non-null");
            return $;
        }
    }

}
