// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lightsail;

import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessArgs;
import com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ContainerServiceArgs extends com.pulumi.resources.ResourceArgs {

    public static final ContainerServiceArgs Empty = new ContainerServiceArgs();

    /**
     * A Boolean value indicating whether the container service is disabled. Defaults to `false`.
     * 
     */
    @Import(name="isDisabled")
    private @Nullable Output<Boolean> isDisabled;

    /**
     * @return A Boolean value indicating whether the container service is disabled. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> isDisabled() {
        return Optional.ofNullable(this.isDisabled);
    }

    /**
     * The name for the container service. Names must be of length 1 to 63, and be
     * unique within each AWS Region in your Lightsail account.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name for the container service. Names must be of length 1 to 63, and be
     * unique within each AWS Region in your Lightsail account.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The power specification for the container service. The power specifies the amount of memory,
     * the number of vCPUs, and the monthly price of each node of the container service.
     * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
     * 
     */
    @Import(name="power", required=true)
    private Output<String> power;

    /**
     * @return The power specification for the container service. The power specifies the amount of memory,
     * the number of vCPUs, and the monthly price of each node of the container service.
     * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
     * 
     */
    public Output<String> power() {
        return this.power;
    }

    /**
     * An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     * 
     */
    @Import(name="privateRegistryAccess")
    private @Nullable Output<ContainerServicePrivateRegistryAccessArgs> privateRegistryAccess;

    /**
     * @return An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     * 
     */
    public Optional<Output<ContainerServicePrivateRegistryAccessArgs>> privateRegistryAccess() {
        return Optional.ofNullable(this.privateRegistryAccess);
    }

    /**
     * The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don&#39;t specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     * 
     */
    @Import(name="publicDomainNames")
    private @Nullable Output<ContainerServicePublicDomainNamesArgs> publicDomainNames;

    /**
     * @return The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don&#39;t specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     * 
     */
    public Optional<Output<ContainerServicePublicDomainNamesArgs>> publicDomainNames() {
        return Optional.ofNullable(this.publicDomainNames);
    }

    /**
     * The scale specification for the container service. The scale specifies the allocated compute
     * nodes of the container service.
     * 
     */
    @Import(name="scale", required=true)
    private Output<Integer> scale;

    /**
     * @return The scale specification for the container service. The scale specifies the allocated compute
     * nodes of the container service.
     * 
     */
    public Output<Integer> scale() {
        return this.scale;
    }

    /**
     * Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private ContainerServiceArgs() {}

    private ContainerServiceArgs(ContainerServiceArgs $) {
        this.isDisabled = $.isDisabled;
        this.name = $.name;
        this.power = $.power;
        this.privateRegistryAccess = $.privateRegistryAccess;
        this.publicDomainNames = $.publicDomainNames;
        this.scale = $.scale;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ContainerServiceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerServiceArgs $;

        public Builder() {
            $ = new ContainerServiceArgs();
        }

        public Builder(ContainerServiceArgs defaults) {
            $ = new ContainerServiceArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param isDisabled A Boolean value indicating whether the container service is disabled. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder isDisabled(@Nullable Output<Boolean> isDisabled) {
            $.isDisabled = isDisabled;
            return this;
        }

        /**
         * @param isDisabled A Boolean value indicating whether the container service is disabled. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder isDisabled(Boolean isDisabled) {
            return isDisabled(Output.of(isDisabled));
        }

        /**
         * @param name The name for the container service. Names must be of length 1 to 63, and be
         * unique within each AWS Region in your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name for the container service. Names must be of length 1 to 63, and be
         * unique within each AWS Region in your Lightsail account.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param power The power specification for the container service. The power specifies the amount of memory,
         * the number of vCPUs, and the monthly price of each node of the container service.
         * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
         * 
         * @return builder
         * 
         */
        public Builder power(Output<String> power) {
            $.power = power;
            return this;
        }

        /**
         * @param power The power specification for the container service. The power specifies the amount of memory,
         * the number of vCPUs, and the monthly price of each node of the container service.
         * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
         * 
         * @return builder
         * 
         */
        public Builder power(String power) {
            return power(Output.of(power));
        }

        /**
         * @param privateRegistryAccess An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
         * 
         * @return builder
         * 
         */
        public Builder privateRegistryAccess(@Nullable Output<ContainerServicePrivateRegistryAccessArgs> privateRegistryAccess) {
            $.privateRegistryAccess = privateRegistryAccess;
            return this;
        }

        /**
         * @param privateRegistryAccess An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
         * 
         * @return builder
         * 
         */
        public Builder privateRegistryAccess(ContainerServicePrivateRegistryAccessArgs privateRegistryAccess) {
            return privateRegistryAccess(Output.of(privateRegistryAccess));
        }

        /**
         * @param publicDomainNames The public domain names to use with the container service, such as example.com
         * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
         * specify are used when you create a deployment with a container configured as the public endpoint of your container
         * service. If you don&#39;t specify public domain names, then you can use the default domain of the container service.
         * Defined below.
         * 
         * @return builder
         * 
         */
        public Builder publicDomainNames(@Nullable Output<ContainerServicePublicDomainNamesArgs> publicDomainNames) {
            $.publicDomainNames = publicDomainNames;
            return this;
        }

        /**
         * @param publicDomainNames The public domain names to use with the container service, such as example.com
         * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
         * specify are used when you create a deployment with a container configured as the public endpoint of your container
         * service. If you don&#39;t specify public domain names, then you can use the default domain of the container service.
         * Defined below.
         * 
         * @return builder
         * 
         */
        public Builder publicDomainNames(ContainerServicePublicDomainNamesArgs publicDomainNames) {
            return publicDomainNames(Output.of(publicDomainNames));
        }

        /**
         * @param scale The scale specification for the container service. The scale specifies the allocated compute
         * nodes of the container service.
         * 
         * @return builder
         * 
         */
        public Builder scale(Output<Integer> scale) {
            $.scale = scale;
            return this;
        }

        /**
         * @param scale The scale specification for the container service. The scale specifies the allocated compute
         * nodes of the container service.
         * 
         * @return builder
         * 
         */
        public Builder scale(Integer scale) {
            return scale(Output.of(scale));
        }

        /**
         * @param tags Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
         * configured with a provider
         * `default_tags` configuration block
         * present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
         * configured with a provider
         * `default_tags` configuration block
         * present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public ContainerServiceArgs build() {
            $.power = Objects.requireNonNull($.power, "expected parameter 'power' to be non-null");
            $.scale = Objects.requireNonNull($.scale, "expected parameter 'scale' to be non-null");
            return $;
        }
    }

}
