// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.licensemanager;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LicenseGrantArgs extends com.pulumi.resources.ResourceArgs {

    public static final LicenseGrantArgs Empty = new LicenseGrantArgs();

    /**
     * A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
     * 
     */
    @Import(name="allowedOperations", required=true)
    private Output<List<String>> allowedOperations;

    /**
     * @return A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
     * 
     */
    public Output<List<String>> allowedOperations() {
        return this.allowedOperations;
    }

    /**
     * The ARN of the license to grant.
     * 
     */
    @Import(name="licenseArn", required=true)
    private Output<String> licenseArn;

    /**
     * @return The ARN of the license to grant.
     * 
     */
    public Output<String> licenseArn() {
        return this.licenseArn;
    }

    /**
     * The Name of the grant.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The Name of the grant.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The target account for the grant in the form of the ARN for an account principal of the root user.
     * 
     */
    @Import(name="principal", required=true)
    private Output<String> principal;

    /**
     * @return The target account for the grant in the form of the ARN for an account principal of the root user.
     * 
     */
    public Output<String> principal() {
        return this.principal;
    }

    private LicenseGrantArgs() {}

    private LicenseGrantArgs(LicenseGrantArgs $) {
        this.allowedOperations = $.allowedOperations;
        this.licenseArn = $.licenseArn;
        this.name = $.name;
        this.principal = $.principal;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LicenseGrantArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LicenseGrantArgs $;

        public Builder() {
            $ = new LicenseGrantArgs();
        }

        public Builder(LicenseGrantArgs defaults) {
            $ = new LicenseGrantArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allowedOperations A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
         * 
         * @return builder
         * 
         */
        public Builder allowedOperations(Output<List<String>> allowedOperations) {
            $.allowedOperations = allowedOperations;
            return this;
        }

        /**
         * @param allowedOperations A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
         * 
         * @return builder
         * 
         */
        public Builder allowedOperations(List<String> allowedOperations) {
            return allowedOperations(Output.of(allowedOperations));
        }

        /**
         * @param allowedOperations A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
         * 
         * @return builder
         * 
         */
        public Builder allowedOperations(String... allowedOperations) {
            return allowedOperations(List.of(allowedOperations));
        }

        /**
         * @param licenseArn The ARN of the license to grant.
         * 
         * @return builder
         * 
         */
        public Builder licenseArn(Output<String> licenseArn) {
            $.licenseArn = licenseArn;
            return this;
        }

        /**
         * @param licenseArn The ARN of the license to grant.
         * 
         * @return builder
         * 
         */
        public Builder licenseArn(String licenseArn) {
            return licenseArn(Output.of(licenseArn));
        }

        /**
         * @param name The Name of the grant.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The Name of the grant.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param principal The target account for the grant in the form of the ARN for an account principal of the root user.
         * 
         * @return builder
         * 
         */
        public Builder principal(Output<String> principal) {
            $.principal = principal;
            return this;
        }

        /**
         * @param principal The target account for the grant in the form of the ARN for an account principal of the root user.
         * 
         * @return builder
         * 
         */
        public Builder principal(String principal) {
            return principal(Output.of(principal));
        }

        public LicenseGrantArgs build() {
            $.allowedOperations = Objects.requireNonNull($.allowedOperations, "expected parameter 'allowedOperations' to be non-null");
            $.licenseArn = Objects.requireNonNull($.licenseArn, "expected parameter 'licenseArn' to be non-null");
            $.principal = Objects.requireNonNull($.principal, "expected parameter 'principal' to be non-null");
            return $;
        }
    }

}
