// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.licensemanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.licensemanager.LicenseGrantAccepterArgs;
import com.pulumi.aws.licensemanager.inputs.LicenseGrantAccepterState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Accepts a License Manager grant. This allows for sharing licenses with other aws accounts.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.licensemanager.LicenseGrantAccepter;
 * import com.pulumi.aws.licensemanager.LicenseGrantAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new LicenseGrantAccepter(&#34;test&#34;, LicenseGrantAccepterArgs.builder()        
 *             .grantArn(&#34;arn:aws:license-manager::123456789012:grant:g-1cf9fba4ba2f42dcab11c686c4b4d329&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_licensemanager_grant_accepter` using the grant arn. For example:
 * 
 * ```sh
 *  $ pulumi import aws:licensemanager/licenseGrantAccepter:LicenseGrantAccepter test arn:aws:license-manager::123456789012:grant:g-1cf9fba4ba2f42dcab11c686c4b4d329
 * ```
 * 
 */
@ResourceType(type="aws:licensemanager/licenseGrantAccepter:LicenseGrantAccepter")
public class LicenseGrantAccepter extends com.pulumi.resources.CustomResource {
    /**
     * A list of the allowed operations for the grant.
     * 
     */
    @Export(name="allowedOperations", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> allowedOperations;

    /**
     * @return A list of the allowed operations for the grant.
     * 
     */
    public Output<List<String>> allowedOperations() {
        return this.allowedOperations;
    }
    /**
     * The ARN of the grant to accept.
     * 
     */
    @Export(name="grantArn", refs={String.class}, tree="[0]")
    private Output<String> grantArn;

    /**
     * @return The ARN of the grant to accept.
     * 
     */
    public Output<String> grantArn() {
        return this.grantArn;
    }
    /**
     * The home region for the license.
     * 
     */
    @Export(name="homeRegion", refs={String.class}, tree="[0]")
    private Output<String> homeRegion;

    /**
     * @return The home region for the license.
     * 
     */
    public Output<String> homeRegion() {
        return this.homeRegion;
    }
    /**
     * The ARN of the license for the grant.
     * 
     */
    @Export(name="licenseArn", refs={String.class}, tree="[0]")
    private Output<String> licenseArn;

    /**
     * @return The ARN of the license for the grant.
     * 
     */
    public Output<String> licenseArn() {
        return this.licenseArn;
    }
    /**
     * The Name of the grant.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The Name of the grant.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The parent ARN.
     * 
     */
    @Export(name="parentArn", refs={String.class}, tree="[0]")
    private Output<String> parentArn;

    /**
     * @return The parent ARN.
     * 
     */
    public Output<String> parentArn() {
        return this.parentArn;
    }
    /**
     * The target account for the grant.
     * 
     */
    @Export(name="principal", refs={String.class}, tree="[0]")
    private Output<String> principal;

    /**
     * @return The target account for the grant.
     * 
     */
    public Output<String> principal() {
        return this.principal;
    }
    /**
     * The grant status.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return The grant status.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * The grant version.
     * 
     */
    @Export(name="version", refs={String.class}, tree="[0]")
    private Output<String> version;

    /**
     * @return The grant version.
     * 
     */
    public Output<String> version() {
        return this.version;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LicenseGrantAccepter(String name) {
        this(name, LicenseGrantAccepterArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LicenseGrantAccepter(String name, LicenseGrantAccepterArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LicenseGrantAccepter(String name, LicenseGrantAccepterArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:licensemanager/licenseGrantAccepter:LicenseGrantAccepter", name, args == null ? LicenseGrantAccepterArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LicenseGrantAccepter(String name, Output<String> id, @Nullable LicenseGrantAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:licensemanager/licenseGrantAccepter:LicenseGrantAccepter", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LicenseGrantAccepter get(String name, Output<String> id, @Nullable LicenseGrantAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LicenseGrantAccepter(name, id, state, options);
    }
}
