// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.licensemanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.licensemanager.LicenseGrantArgs;
import com.pulumi.aws.licensemanager.inputs.LicenseGrantState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Provides a License Manager grant. This allows for sharing licenses with other AWS accounts.
 * 
 * ## Example Usage
 * 
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.licensemanager.LicenseGrant;
 * import com.pulumi.aws.licensemanager.LicenseGrantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new LicenseGrant(&#34;test&#34;, LicenseGrantArgs.builder()        
 *             .allowedOperations(            
 *                 &#34;ListPurchasedLicenses&#34;,
 *                 &#34;CheckoutLicense&#34;,
 *                 &#34;CheckInLicense&#34;,
 *                 &#34;ExtendConsumptionLicense&#34;,
 *                 &#34;CreateToken&#34;)
 *             .homeRegion(&#34;us-east-1&#34;)
 *             .licenseArn(&#34;arn:aws:license-manager::111111111111:license:l-exampleARN&#34;)
 *             .principal(&#34;arn:aws:iam::111111111112:root&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_licensemanager_grant` using the grant arn. For example:
 * 
 * ```sh
 *  $ pulumi import aws:licensemanager/licenseGrant:LicenseGrant test arn:aws:license-manager::123456789011:grant:g-01d313393d9e443d8664cc054db1e089
 * ```
 * 
 */
@ResourceType(type="aws:licensemanager/licenseGrant:LicenseGrant")
public class LicenseGrant extends com.pulumi.resources.CustomResource {
    /**
     * A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
     * 
     */
    @Export(name="allowedOperations", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> allowedOperations;

    /**
     * @return A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
     * 
     */
    public Output<List<String>> allowedOperations() {
        return this.allowedOperations;
    }
    /**
     * The grant ARN.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The grant ARN.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The home region for the license.
     * 
     */
    @Export(name="homeRegion", refs={String.class}, tree="[0]")
    private Output<String> homeRegion;

    /**
     * @return The home region for the license.
     * 
     */
    public Output<String> homeRegion() {
        return this.homeRegion;
    }
    /**
     * The ARN of the license to grant.
     * 
     */
    @Export(name="licenseArn", refs={String.class}, tree="[0]")
    private Output<String> licenseArn;

    /**
     * @return The ARN of the license to grant.
     * 
     */
    public Output<String> licenseArn() {
        return this.licenseArn;
    }
    /**
     * The Name of the grant.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The Name of the grant.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The parent ARN.
     * 
     */
    @Export(name="parentArn", refs={String.class}, tree="[0]")
    private Output<String> parentArn;

    /**
     * @return The parent ARN.
     * 
     */
    public Output<String> parentArn() {
        return this.parentArn;
    }
    /**
     * The target account for the grant in the form of the ARN for an account principal of the root user.
     * 
     */
    @Export(name="principal", refs={String.class}, tree="[0]")
    private Output<String> principal;

    /**
     * @return The target account for the grant in the form of the ARN for an account principal of the root user.
     * 
     */
    public Output<String> principal() {
        return this.principal;
    }
    /**
     * The grant status.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return The grant status.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * The grant version.
     * 
     */
    @Export(name="version", refs={String.class}, tree="[0]")
    private Output<String> version;

    /**
     * @return The grant version.
     * 
     */
    public Output<String> version() {
        return this.version;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LicenseGrant(String name) {
        this(name, LicenseGrantArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LicenseGrant(String name, LicenseGrantArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LicenseGrant(String name, LicenseGrantArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:licensemanager/licenseGrant:LicenseGrant", name, args == null ? LicenseGrantArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LicenseGrant(String name, Output<String> id, @Nullable LicenseGrantState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:licensemanager/licenseGrant:LicenseGrant", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LicenseGrant get(String name, Output<String> id, @Nullable LicenseGrantState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LicenseGrant(name, id, state, options);
    }
}
