// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lex;

import com.pulumi.aws.lex.inputs.SlotTypeEnumerationValueArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SlotTypeArgs extends com.pulumi.resources.ResourceArgs {

    public static final SlotTypeArgs Empty = new SlotTypeArgs();

    /**
     * Determines if a new slot type version is created when the initial resource is created and on each
     * update. Defaults to `false`.
     * 
     */
    @Import(name="createVersion")
    private @Nullable Output<Boolean> createVersion;

    /**
     * @return Determines if a new slot type version is created when the initial resource is created and on each
     * update. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> createVersion() {
        return Optional.ofNullable(this.createVersion);
    }

    /**
     * A description of the slot type. Must be less than or equal to 200 characters in length.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A description of the slot type. Must be less than or equal to 200 characters in length.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     * 
     */
    @Import(name="enumerationValues", required=true)
    private Output<List<SlotTypeEnumerationValueArgs>> enumerationValues;

    /**
     * @return A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     * 
     */
    public Output<List<SlotTypeEnumerationValueArgs>> enumerationValues() {
        return this.enumerationValues;
    }

    /**
     * The name of the slot type. The name is not case sensitive. Must be less than or equal to 100 characters in length.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the slot type. The name is not case sensitive. Must be less than or equal to 100 characters in length.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Determines the slot resolution strategy that Amazon Lex
     * uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
     * value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
     * if there is a resolution list for the slot, otherwise null is returned. Defaults to `ORIGINAL_VALUE`.
     * 
     */
    @Import(name="valueSelectionStrategy")
    private @Nullable Output<String> valueSelectionStrategy;

    /**
     * @return Determines the slot resolution strategy that Amazon Lex
     * uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
     * value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
     * if there is a resolution list for the slot, otherwise null is returned. Defaults to `ORIGINAL_VALUE`.
     * 
     */
    public Optional<Output<String>> valueSelectionStrategy() {
        return Optional.ofNullable(this.valueSelectionStrategy);
    }

    private SlotTypeArgs() {}

    private SlotTypeArgs(SlotTypeArgs $) {
        this.createVersion = $.createVersion;
        this.description = $.description;
        this.enumerationValues = $.enumerationValues;
        this.name = $.name;
        this.valueSelectionStrategy = $.valueSelectionStrategy;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SlotTypeArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SlotTypeArgs $;

        public Builder() {
            $ = new SlotTypeArgs();
        }

        public Builder(SlotTypeArgs defaults) {
            $ = new SlotTypeArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param createVersion Determines if a new slot type version is created when the initial resource is created and on each
         * update. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder createVersion(@Nullable Output<Boolean> createVersion) {
            $.createVersion = createVersion;
            return this;
        }

        /**
         * @param createVersion Determines if a new slot type version is created when the initial resource is created and on each
         * update. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder createVersion(Boolean createVersion) {
            return createVersion(Output.of(createVersion));
        }

        /**
         * @param description A description of the slot type. Must be less than or equal to 200 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description of the slot type. Must be less than or equal to 200 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param enumerationValues A list of EnumerationValue objects that defines the values that
         * the slot type can take. Each value can have a list of synonyms, which are additional values that help
         * train the machine learning model about the values that it resolves for a slot. Attributes are
         * documented under enumeration_value.
         * 
         * @return builder
         * 
         */
        public Builder enumerationValues(Output<List<SlotTypeEnumerationValueArgs>> enumerationValues) {
            $.enumerationValues = enumerationValues;
            return this;
        }

        /**
         * @param enumerationValues A list of EnumerationValue objects that defines the values that
         * the slot type can take. Each value can have a list of synonyms, which are additional values that help
         * train the machine learning model about the values that it resolves for a slot. Attributes are
         * documented under enumeration_value.
         * 
         * @return builder
         * 
         */
        public Builder enumerationValues(List<SlotTypeEnumerationValueArgs> enumerationValues) {
            return enumerationValues(Output.of(enumerationValues));
        }

        /**
         * @param enumerationValues A list of EnumerationValue objects that defines the values that
         * the slot type can take. Each value can have a list of synonyms, which are additional values that help
         * train the machine learning model about the values that it resolves for a slot. Attributes are
         * documented under enumeration_value.
         * 
         * @return builder
         * 
         */
        public Builder enumerationValues(SlotTypeEnumerationValueArgs... enumerationValues) {
            return enumerationValues(List.of(enumerationValues));
        }

        /**
         * @param name The name of the slot type. The name is not case sensitive. Must be less than or equal to 100 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the slot type. The name is not case sensitive. Must be less than or equal to 100 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param valueSelectionStrategy Determines the slot resolution strategy that Amazon Lex
         * uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
         * value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
         * if there is a resolution list for the slot, otherwise null is returned. Defaults to `ORIGINAL_VALUE`.
         * 
         * @return builder
         * 
         */
        public Builder valueSelectionStrategy(@Nullable Output<String> valueSelectionStrategy) {
            $.valueSelectionStrategy = valueSelectionStrategy;
            return this;
        }

        /**
         * @param valueSelectionStrategy Determines the slot resolution strategy that Amazon Lex
         * uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
         * value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
         * if there is a resolution list for the slot, otherwise null is returned. Defaults to `ORIGINAL_VALUE`.
         * 
         * @return builder
         * 
         */
        public Builder valueSelectionStrategy(String valueSelectionStrategy) {
            return valueSelectionStrategy(Output.of(valueSelectionStrategy));
        }

        public SlotTypeArgs build() {
            $.enumerationValues = Objects.requireNonNull($.enumerationValues, "expected parameter 'enumerationValues' to be non-null");
            return $;
        }
    }

}
