// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lb;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.lb.inputs.GetHostedZoneIdArgs;
import com.pulumi.aws.lb.inputs.GetHostedZoneIdPlainArgs;
import com.pulumi.aws.lb.inputs.GetLbsArgs;
import com.pulumi.aws.lb.inputs.GetLbsPlainArgs;
import com.pulumi.aws.lb.inputs.GetListenerArgs;
import com.pulumi.aws.lb.inputs.GetListenerPlainArgs;
import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
import com.pulumi.aws.lb.inputs.GetLoadBalancerPlainArgs;
import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
import com.pulumi.aws.lb.inputs.GetTargetGroupPlainArgs;
import com.pulumi.aws.lb.outputs.GetHostedZoneIdResult;
import com.pulumi.aws.lb.outputs.GetLbsResult;
import com.pulumi.aws.lb.outputs.GetListenerResult;
import com.pulumi.aws.lb.outputs.GetLoadBalancerResult;
import com.pulumi.aws.lb.outputs.GetTargetGroupResult;
import com.pulumi.core.Output;
import com.pulumi.core.TypeShape;
import com.pulumi.deployment.Deployment;
import com.pulumi.deployment.InvokeOptions;
import java.util.concurrent.CompletableFuture;

public final class LbFunctions {
    /**
     * Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetHostedZoneIdArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = LbFunctions.getHostedZoneId();
     * 
     *         var www = new Record(&#34;www&#34;, RecordArgs.builder()        
     *             .zoneId(aws_route53_zone.primary().zone_id())
     *             .name(&#34;example.com&#34;)
     *             .type(&#34;A&#34;)
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(aws_lb.main().dns_name())
     *                 .zoneId(main.applyValue(getHostedZoneIdResult -&gt; getHostedZoneIdResult.id()))
     *                 .evaluateTargetHealth(true)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetHostedZoneIdResult> getHostedZoneId() {
        return getHostedZoneId(GetHostedZoneIdArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetHostedZoneIdArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = LbFunctions.getHostedZoneId();
     * 
     *         var www = new Record(&#34;www&#34;, RecordArgs.builder()        
     *             .zoneId(aws_route53_zone.primary().zone_id())
     *             .name(&#34;example.com&#34;)
     *             .type(&#34;A&#34;)
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(aws_lb.main().dns_name())
     *                 .zoneId(main.applyValue(getHostedZoneIdResult -&gt; getHostedZoneIdResult.id()))
     *                 .evaluateTargetHealth(true)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetHostedZoneIdResult> getHostedZoneIdPlain() {
        return getHostedZoneIdPlain(GetHostedZoneIdPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetHostedZoneIdArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = LbFunctions.getHostedZoneId();
     * 
     *         var www = new Record(&#34;www&#34;, RecordArgs.builder()        
     *             .zoneId(aws_route53_zone.primary().zone_id())
     *             .name(&#34;example.com&#34;)
     *             .type(&#34;A&#34;)
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(aws_lb.main().dns_name())
     *                 .zoneId(main.applyValue(getHostedZoneIdResult -&gt; getHostedZoneIdResult.id()))
     *                 .evaluateTargetHealth(true)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetHostedZoneIdResult> getHostedZoneId(GetHostedZoneIdArgs args) {
        return getHostedZoneId(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetHostedZoneIdArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = LbFunctions.getHostedZoneId();
     * 
     *         var www = new Record(&#34;www&#34;, RecordArgs.builder()        
     *             .zoneId(aws_route53_zone.primary().zone_id())
     *             .name(&#34;example.com&#34;)
     *             .type(&#34;A&#34;)
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(aws_lb.main().dns_name())
     *                 .zoneId(main.applyValue(getHostedZoneIdResult -&gt; getHostedZoneIdResult.id()))
     *                 .evaluateTargetHealth(true)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetHostedZoneIdResult> getHostedZoneIdPlain(GetHostedZoneIdPlainArgs args) {
        return getHostedZoneIdPlain(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetHostedZoneIdArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = LbFunctions.getHostedZoneId();
     * 
     *         var www = new Record(&#34;www&#34;, RecordArgs.builder()        
     *             .zoneId(aws_route53_zone.primary().zone_id())
     *             .name(&#34;example.com&#34;)
     *             .type(&#34;A&#34;)
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(aws_lb.main().dns_name())
     *                 .zoneId(main.applyValue(getHostedZoneIdResult -&gt; getHostedZoneIdResult.id()))
     *                 .evaluateTargetHealth(true)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetHostedZoneIdResult> getHostedZoneId(GetHostedZoneIdArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:lb/getHostedZoneId:getHostedZoneId", TypeShape.of(GetHostedZoneIdResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the HostedZoneId of the AWS Elastic Load Balancing (ELB) in a given region for the purpose of using in an AWS Route53 Alias. Specify the ELB type (`network` or `application`) to return the relevant the associated HostedZoneId. Ref: [ELB service endpoints](https://docs.aws.amazon.com/general/latest/gr/elb.html#elb_region)
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetHostedZoneIdArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var main = LbFunctions.getHostedZoneId();
     * 
     *         var www = new Record(&#34;www&#34;, RecordArgs.builder()        
     *             .zoneId(aws_route53_zone.primary().zone_id())
     *             .name(&#34;example.com&#34;)
     *             .type(&#34;A&#34;)
     *             .aliases(RecordAliasArgs.builder()
     *                 .name(aws_lb.main().dns_name())
     *                 .zoneId(main.applyValue(getHostedZoneIdResult -&gt; getHostedZoneIdResult.id()))
     *                 .evaluateTargetHealth(true)
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetHostedZoneIdResult> getHostedZoneIdPlain(GetHostedZoneIdPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:lb/getHostedZoneId:getHostedZoneId", TypeShape.of(GetHostedZoneIdResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
     * resources.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLbsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = LbFunctions.getLbs(GetLbsArgs.builder()
     *             .tags(Map.of(&#34;elbv2.k8s.aws/cluster&#34;, &#34;my-cluster&#34;))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetLbsResult> getLbs() {
        return getLbs(GetLbsArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
     * resources.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLbsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = LbFunctions.getLbs(GetLbsArgs.builder()
     *             .tags(Map.of(&#34;elbv2.k8s.aws/cluster&#34;, &#34;my-cluster&#34;))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetLbsResult> getLbsPlain() {
        return getLbsPlain(GetLbsPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
     * resources.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLbsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = LbFunctions.getLbs(GetLbsArgs.builder()
     *             .tags(Map.of(&#34;elbv2.k8s.aws/cluster&#34;, &#34;my-cluster&#34;))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetLbsResult> getLbs(GetLbsArgs args) {
        return getLbs(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
     * resources.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLbsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = LbFunctions.getLbs(GetLbsArgs.builder()
     *             .tags(Map.of(&#34;elbv2.k8s.aws/cluster&#34;, &#34;my-cluster&#34;))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetLbsResult> getLbsPlain(GetLbsPlainArgs args) {
        return getLbsPlain(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
     * resources.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLbsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = LbFunctions.getLbs(GetLbsArgs.builder()
     *             .tags(Map.of(&#34;elbv2.k8s.aws/cluster&#34;, &#34;my-cluster&#34;))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetLbsResult> getLbs(GetLbsArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:lb/getLbs:getLbs", TypeShape.of(GetLbsResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
     * resources.
     * 
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLbsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = LbFunctions.getLbs(GetLbsArgs.builder()
     *             .tags(Map.of(&#34;elbv2.k8s.aws/cluster&#34;, &#34;my-cluster&#34;))
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetLbsResult> getLbsPlain(GetLbsPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:lb/getLbs:getLbs", TypeShape.of(GetLbsResult.class), args, Utilities.withVersion(options));
    }
    /**
     * &gt; **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Listener.
     * 
     * This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetListenerArgs;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var listenerArn = config.get(&#34;listenerArn&#34;);
     *         final var listener = LbFunctions.getListener(GetListenerArgs.builder()
     *             .arn(listenerArn)
     *             .build());
     * 
     *         final var selected = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name(&#34;default-public&#34;)
     *             .build());
     * 
     *         final var selected443 = LbFunctions.getListener(GetListenerArgs.builder()
     *             .loadBalancerArn(selected.applyValue(getLoadBalancerResult -&gt; getLoadBalancerResult.arn()))
     *             .port(443)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetListenerResult> getListener() {
        return getListener(GetListenerArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Listener.
     * 
     * This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetListenerArgs;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var listenerArn = config.get(&#34;listenerArn&#34;);
     *         final var listener = LbFunctions.getListener(GetListenerArgs.builder()
     *             .arn(listenerArn)
     *             .build());
     * 
     *         final var selected = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name(&#34;default-public&#34;)
     *             .build());
     * 
     *         final var selected443 = LbFunctions.getListener(GetListenerArgs.builder()
     *             .loadBalancerArn(selected.applyValue(getLoadBalancerResult -&gt; getLoadBalancerResult.arn()))
     *             .port(443)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetListenerResult> getListenerPlain() {
        return getListenerPlain(GetListenerPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Listener.
     * 
     * This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetListenerArgs;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var listenerArn = config.get(&#34;listenerArn&#34;);
     *         final var listener = LbFunctions.getListener(GetListenerArgs.builder()
     *             .arn(listenerArn)
     *             .build());
     * 
     *         final var selected = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name(&#34;default-public&#34;)
     *             .build());
     * 
     *         final var selected443 = LbFunctions.getListener(GetListenerArgs.builder()
     *             .loadBalancerArn(selected.applyValue(getLoadBalancerResult -&gt; getLoadBalancerResult.arn()))
     *             .port(443)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetListenerResult> getListener(GetListenerArgs args) {
        return getListener(args, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Listener.
     * 
     * This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetListenerArgs;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var listenerArn = config.get(&#34;listenerArn&#34;);
     *         final var listener = LbFunctions.getListener(GetListenerArgs.builder()
     *             .arn(listenerArn)
     *             .build());
     * 
     *         final var selected = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name(&#34;default-public&#34;)
     *             .build());
     * 
     *         final var selected443 = LbFunctions.getListener(GetListenerArgs.builder()
     *             .loadBalancerArn(selected.applyValue(getLoadBalancerResult -&gt; getLoadBalancerResult.arn()))
     *             .port(443)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetListenerResult> getListenerPlain(GetListenerPlainArgs args) {
        return getListenerPlain(args, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Listener.
     * 
     * This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetListenerArgs;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var listenerArn = config.get(&#34;listenerArn&#34;);
     *         final var listener = LbFunctions.getListener(GetListenerArgs.builder()
     *             .arn(listenerArn)
     *             .build());
     * 
     *         final var selected = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name(&#34;default-public&#34;)
     *             .build());
     * 
     *         final var selected443 = LbFunctions.getListener(GetListenerArgs.builder()
     *             .loadBalancerArn(selected.applyValue(getLoadBalancerResult -&gt; getLoadBalancerResult.arn()))
     *             .port(443)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetListenerResult> getListener(GetListenerArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:lb/getListener:getListener", TypeShape.of(GetListenerResult.class), args, Utilities.withVersion(options));
    }
    /**
     * &gt; **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Listener.
     * 
     * This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetListenerArgs;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var listenerArn = config.get(&#34;listenerArn&#34;);
     *         final var listener = LbFunctions.getListener(GetListenerArgs.builder()
     *             .arn(listenerArn)
     *             .build());
     * 
     *         final var selected = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name(&#34;default-public&#34;)
     *             .build());
     * 
     *         final var selected443 = LbFunctions.getListener(GetListenerArgs.builder()
     *             .loadBalancerArn(selected.applyValue(getLoadBalancerResult -&gt; getLoadBalancerResult.arn()))
     *             .port(443)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetListenerResult> getListenerPlain(GetListenerPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:lb/getListener:getListener", TypeShape.of(GetListenerResult.class), args, Utilities.withVersion(options));
    }
    /**
     * &gt; **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
     * 
     * Provides information about a Load Balancer.
     * 
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbArn = config.get(&#34;lbArn&#34;).orElse(&#34;&#34;);
     *         final var lbName = config.get(&#34;lbName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .arn(lbArn)
     *             .name(lbName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetLoadBalancerResult> getLoadBalancer() {
        return getLoadBalancer(GetLoadBalancerArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
     * 
     * Provides information about a Load Balancer.
     * 
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbArn = config.get(&#34;lbArn&#34;).orElse(&#34;&#34;);
     *         final var lbName = config.get(&#34;lbName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .arn(lbArn)
     *             .name(lbName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetLoadBalancerResult> getLoadBalancerPlain() {
        return getLoadBalancerPlain(GetLoadBalancerPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
     * 
     * Provides information about a Load Balancer.
     * 
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbArn = config.get(&#34;lbArn&#34;).orElse(&#34;&#34;);
     *         final var lbName = config.get(&#34;lbName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .arn(lbArn)
     *             .name(lbName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetLoadBalancerResult> getLoadBalancer(GetLoadBalancerArgs args) {
        return getLoadBalancer(args, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
     * 
     * Provides information about a Load Balancer.
     * 
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbArn = config.get(&#34;lbArn&#34;).orElse(&#34;&#34;);
     *         final var lbName = config.get(&#34;lbName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .arn(lbArn)
     *             .name(lbName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetLoadBalancerResult> getLoadBalancerPlain(GetLoadBalancerPlainArgs args) {
        return getLoadBalancerPlain(args, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
     * 
     * Provides information about a Load Balancer.
     * 
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbArn = config.get(&#34;lbArn&#34;).orElse(&#34;&#34;);
     *         final var lbName = config.get(&#34;lbName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .arn(lbArn)
     *             .name(lbName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetLoadBalancerResult> getLoadBalancer(GetLoadBalancerArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:lb/getLoadBalancer:getLoadBalancer", TypeShape.of(GetLoadBalancerResult.class), args, Utilities.withVersion(options));
    }
    /**
     * &gt; **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
     * 
     * Provides information about a Load Balancer.
     * 
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbArn = config.get(&#34;lbArn&#34;).orElse(&#34;&#34;);
     *         final var lbName = config.get(&#34;lbName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .arn(lbArn)
     *             .name(lbName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetLoadBalancerResult> getLoadBalancerPlain(GetLoadBalancerPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:lb/getLoadBalancer:getLoadBalancer", TypeShape.of(GetLoadBalancerResult.class), args, Utilities.withVersion(options));
    }
    /**
     * &gt; **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Target Group.
     * 
     * This data source can prove useful when a module accepts an LB Target Group as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Target Group for use in other resources, given LB Target Group name.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTgArn = config.get(&#34;lbTgArn&#34;).orElse(&#34;&#34;);
     *         final var lbTgName = config.get(&#34;lbTgName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getTargetGroup(GetTargetGroupArgs.builder()
     *             .arn(lbTgArn)
     *             .name(lbTgName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetTargetGroupResult> getTargetGroup() {
        return getTargetGroup(GetTargetGroupArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Target Group.
     * 
     * This data source can prove useful when a module accepts an LB Target Group as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Target Group for use in other resources, given LB Target Group name.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTgArn = config.get(&#34;lbTgArn&#34;).orElse(&#34;&#34;);
     *         final var lbTgName = config.get(&#34;lbTgName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getTargetGroup(GetTargetGroupArgs.builder()
     *             .arn(lbTgArn)
     *             .name(lbTgName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetTargetGroupResult> getTargetGroupPlain() {
        return getTargetGroupPlain(GetTargetGroupPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Target Group.
     * 
     * This data source can prove useful when a module accepts an LB Target Group as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Target Group for use in other resources, given LB Target Group name.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTgArn = config.get(&#34;lbTgArn&#34;).orElse(&#34;&#34;);
     *         final var lbTgName = config.get(&#34;lbTgName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getTargetGroup(GetTargetGroupArgs.builder()
     *             .arn(lbTgArn)
     *             .name(lbTgName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetTargetGroupResult> getTargetGroup(GetTargetGroupArgs args) {
        return getTargetGroup(args, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Target Group.
     * 
     * This data source can prove useful when a module accepts an LB Target Group as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Target Group for use in other resources, given LB Target Group name.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTgArn = config.get(&#34;lbTgArn&#34;).orElse(&#34;&#34;);
     *         final var lbTgName = config.get(&#34;lbTgName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getTargetGroup(GetTargetGroupArgs.builder()
     *             .arn(lbTgArn)
     *             .name(lbTgName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetTargetGroupResult> getTargetGroupPlain(GetTargetGroupPlainArgs args) {
        return getTargetGroupPlain(args, InvokeOptions.Empty);
    }
    /**
     * &gt; **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Target Group.
     * 
     * This data source can prove useful when a module accepts an LB Target Group as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Target Group for use in other resources, given LB Target Group name.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTgArn = config.get(&#34;lbTgArn&#34;).orElse(&#34;&#34;);
     *         final var lbTgName = config.get(&#34;lbTgName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getTargetGroup(GetTargetGroupArgs.builder()
     *             .arn(lbTgArn)
     *             .name(lbTgName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetTargetGroupResult> getTargetGroup(GetTargetGroupArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:lb/getTargetGroup:getTargetGroup", TypeShape.of(GetTargetGroupResult.class), args, Utilities.withVersion(options));
    }
    /**
     * &gt; **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
     * 
     * Provides information about a Load Balancer Target Group.
     * 
     * This data source can prove useful when a module accepts an LB Target Group as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Target Group for use in other resources, given LB Target Group name.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTgArn = config.get(&#34;lbTgArn&#34;).orElse(&#34;&#34;);
     *         final var lbTgName = config.get(&#34;lbTgName&#34;).orElse(&#34;&#34;);
     *         final var test = LbFunctions.getTargetGroup(GetTargetGroupArgs.builder()
     *             .arn(lbTgArn)
     *             .name(lbTgName)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetTargetGroupResult> getTargetGroupPlain(GetTargetGroupPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:lb/getTargetGroup:getTargetGroup", TypeShape.of(GetTargetGroupResult.class), args, Utilities.withVersion(options));
    }
}
