// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lambda;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LayerVersionPermissionArgs extends com.pulumi.resources.ResourceArgs {

    public static final LayerVersionPermissionArgs Empty = new LayerVersionPermissionArgs();

    /**
     * Action, which will be allowed. `lambda:GetLayerVersion` value is suggested by AWS documantation.
     * 
     */
    @Import(name="action", required=true)
    private Output<String> action;

    /**
     * @return Action, which will be allowed. `lambda:GetLayerVersion` value is suggested by AWS documantation.
     * 
     */
    public Output<String> action() {
        return this.action;
    }

    /**
     * The name or ARN of the Lambda Layer, which you want to grant access to.
     * 
     */
    @Import(name="layerName", required=true)
    private Output<String> layerName;

    /**
     * @return The name or ARN of the Lambda Layer, which you want to grant access to.
     * 
     */
    public Output<String> layerName() {
        return this.layerName;
    }

    /**
     * An identifier of AWS Organization, which should be able to use your Lambda Layer. `principal` should be equal to `*` if `organization_id` provided.
     * 
     */
    @Import(name="organizationId")
    private @Nullable Output<String> organizationId;

    /**
     * @return An identifier of AWS Organization, which should be able to use your Lambda Layer. `principal` should be equal to `*` if `organization_id` provided.
     * 
     */
    public Optional<Output<String>> organizationId() {
        return Optional.ofNullable(this.organizationId);
    }

    /**
     * AWS account ID which should be able to use your Lambda Layer. `*` can be used here, if you want to share your Lambda Layer widely.
     * 
     */
    @Import(name="principal", required=true)
    private Output<String> principal;

    /**
     * @return AWS account ID which should be able to use your Lambda Layer. `*` can be used here, if you want to share your Lambda Layer widely.
     * 
     */
    public Output<String> principal() {
        return this.principal;
    }

    /**
     * Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
     * 
     */
    @Import(name="skipDestroy")
    private @Nullable Output<Boolean> skipDestroy;

    /**
     * @return Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
     * 
     */
    public Optional<Output<Boolean>> skipDestroy() {
        return Optional.ofNullable(this.skipDestroy);
    }

    /**
     * The name of Lambda Layer Permission, for example `dev-account` - human readable note about what is this permission for.
     * 
     */
    @Import(name="statementId", required=true)
    private Output<String> statementId;

    /**
     * @return The name of Lambda Layer Permission, for example `dev-account` - human readable note about what is this permission for.
     * 
     */
    public Output<String> statementId() {
        return this.statementId;
    }

    /**
     * Version of Lambda Layer, which you want to grant access to. Note: permissions only apply to a single version of a layer.
     * 
     */
    @Import(name="versionNumber", required=true)
    private Output<Integer> versionNumber;

    /**
     * @return Version of Lambda Layer, which you want to grant access to. Note: permissions only apply to a single version of a layer.
     * 
     */
    public Output<Integer> versionNumber() {
        return this.versionNumber;
    }

    private LayerVersionPermissionArgs() {}

    private LayerVersionPermissionArgs(LayerVersionPermissionArgs $) {
        this.action = $.action;
        this.layerName = $.layerName;
        this.organizationId = $.organizationId;
        this.principal = $.principal;
        this.skipDestroy = $.skipDestroy;
        this.statementId = $.statementId;
        this.versionNumber = $.versionNumber;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LayerVersionPermissionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LayerVersionPermissionArgs $;

        public Builder() {
            $ = new LayerVersionPermissionArgs();
        }

        public Builder(LayerVersionPermissionArgs defaults) {
            $ = new LayerVersionPermissionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param action Action, which will be allowed. `lambda:GetLayerVersion` value is suggested by AWS documantation.
         * 
         * @return builder
         * 
         */
        public Builder action(Output<String> action) {
            $.action = action;
            return this;
        }

        /**
         * @param action Action, which will be allowed. `lambda:GetLayerVersion` value is suggested by AWS documantation.
         * 
         * @return builder
         * 
         */
        public Builder action(String action) {
            return action(Output.of(action));
        }

        /**
         * @param layerName The name or ARN of the Lambda Layer, which you want to grant access to.
         * 
         * @return builder
         * 
         */
        public Builder layerName(Output<String> layerName) {
            $.layerName = layerName;
            return this;
        }

        /**
         * @param layerName The name or ARN of the Lambda Layer, which you want to grant access to.
         * 
         * @return builder
         * 
         */
        public Builder layerName(String layerName) {
            return layerName(Output.of(layerName));
        }

        /**
         * @param organizationId An identifier of AWS Organization, which should be able to use your Lambda Layer. `principal` should be equal to `*` if `organization_id` provided.
         * 
         * @return builder
         * 
         */
        public Builder organizationId(@Nullable Output<String> organizationId) {
            $.organizationId = organizationId;
            return this;
        }

        /**
         * @param organizationId An identifier of AWS Organization, which should be able to use your Lambda Layer. `principal` should be equal to `*` if `organization_id` provided.
         * 
         * @return builder
         * 
         */
        public Builder organizationId(String organizationId) {
            return organizationId(Output.of(organizationId));
        }

        /**
         * @param principal AWS account ID which should be able to use your Lambda Layer. `*` can be used here, if you want to share your Lambda Layer widely.
         * 
         * @return builder
         * 
         */
        public Builder principal(Output<String> principal) {
            $.principal = principal;
            return this;
        }

        /**
         * @param principal AWS account ID which should be able to use your Lambda Layer. `*` can be used here, if you want to share your Lambda Layer widely.
         * 
         * @return builder
         * 
         */
        public Builder principal(String principal) {
            return principal(Output.of(principal));
        }

        /**
         * @param skipDestroy Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
         * 
         * @return builder
         * 
         */
        public Builder skipDestroy(@Nullable Output<Boolean> skipDestroy) {
            $.skipDestroy = skipDestroy;
            return this;
        }

        /**
         * @param skipDestroy Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
         * 
         * @return builder
         * 
         */
        public Builder skipDestroy(Boolean skipDestroy) {
            return skipDestroy(Output.of(skipDestroy));
        }

        /**
         * @param statementId The name of Lambda Layer Permission, for example `dev-account` - human readable note about what is this permission for.
         * 
         * @return builder
         * 
         */
        public Builder statementId(Output<String> statementId) {
            $.statementId = statementId;
            return this;
        }

        /**
         * @param statementId The name of Lambda Layer Permission, for example `dev-account` - human readable note about what is this permission for.
         * 
         * @return builder
         * 
         */
        public Builder statementId(String statementId) {
            return statementId(Output.of(statementId));
        }

        /**
         * @param versionNumber Version of Lambda Layer, which you want to grant access to. Note: permissions only apply to a single version of a layer.
         * 
         * @return builder
         * 
         */
        public Builder versionNumber(Output<Integer> versionNumber) {
            $.versionNumber = versionNumber;
            return this;
        }

        /**
         * @param versionNumber Version of Lambda Layer, which you want to grant access to. Note: permissions only apply to a single version of a layer.
         * 
         * @return builder
         * 
         */
        public Builder versionNumber(Integer versionNumber) {
            return versionNumber(Output.of(versionNumber));
        }

        public LayerVersionPermissionArgs build() {
            $.action = Objects.requireNonNull($.action, "expected parameter 'action' to be non-null");
            $.layerName = Objects.requireNonNull($.layerName, "expected parameter 'layerName' to be non-null");
            $.principal = Objects.requireNonNull($.principal, "expected parameter 'principal' to be non-null");
            $.statementId = Objects.requireNonNull($.statementId, "expected parameter 'statementId' to be non-null");
            $.versionNumber = Objects.requireNonNull($.versionNumber, "expected parameter 'versionNumber' to be non-null");
            return $;
        }
    }

}
