// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lakeformation;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.lakeformation.LfTagArgs;
import com.pulumi.aws.lakeformation.inputs.LfTagState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Creates an LF-Tag with the specified name and values. Each key must have at least one value. The maximum number of values permitted is 15.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.LfTag;
 * import com.pulumi.aws.lakeformation.LfTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new LfTag(&#34;example&#34;, LfTagArgs.builder()        
 *             .key(&#34;module&#34;)
 *             .values(            
 *                 &#34;Orders&#34;,
 *                 &#34;Sales&#34;,
 *                 &#34;Customers&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Lake Formation LF-Tags using the `catalog_id:key`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * 
 * ```sh
 *  $ pulumi import aws:lakeformation/lfTag:LfTag example 123456789012:some_key
 * ```
 * 
 */
@ResourceType(type="aws:lakeformation/lfTag:LfTag")
public class LfTag extends com.pulumi.resources.CustomResource {
    /**
     * ID of the Data Catalog to create the tag in. If omitted, this defaults to the AWS Account ID.
     * 
     */
    @Export(name="catalogId", refs={String.class}, tree="[0]")
    private Output<String> catalogId;

    /**
     * @return ID of the Data Catalog to create the tag in. If omitted, this defaults to the AWS Account ID.
     * 
     */
    public Output<String> catalogId() {
        return this.catalogId;
    }
    /**
     * Key-name for the tag.
     * 
     */
    @Export(name="key", refs={String.class}, tree="[0]")
    private Output<String> key;

    /**
     * @return Key-name for the tag.
     * 
     */
    public Output<String> key() {
        return this.key;
    }
    /**
     * List of possible values an attribute can take.
     * 
     */
    @Export(name="values", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> values;

    /**
     * @return List of possible values an attribute can take.
     * 
     */
    public Output<List<String>> values() {
        return this.values;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LfTag(String name) {
        this(name, LfTagArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LfTag(String name, LfTagArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LfTag(String name, LfTagArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lakeformation/lfTag:LfTag", name, args == null ? LfTagArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LfTag(String name, Output<String> id, @Nullable LfTagState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lakeformation/lfTag:LfTag", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LfTag get(String name, Output<String> id, @Nullable LfTagState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LfTag(name, id, state, options);
    }
}
