// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.lakeformation;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsState;
import com.pulumi.aws.lakeformation.outputs.DataLakeSettingsCreateDatabaseDefaultPermission;
import com.pulumi.aws.lakeformation.outputs.DataLakeSettingsCreateTableDefaultPermission;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.
 * 
 * &gt; **NOTE:** Lake Formation introduces fine-grained access control for data in your data lake. Part of the changes include the `IAMAllowedPrincipals` principal in order to make Lake Formation backwards compatible with existing IAM and Glue permissions. For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html) and [Upgrading AWS Glue Data Permissions to the AWS Lake Formation Model](https://docs.aws.amazon.com/lake-formation/latest/dg/upgrade-glue-lake-formation.html).
 * 
 * ## Example Usage
 * ### Data Lake Admins
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings(&#34;example&#34;, DataLakeSettingsArgs.builder()        
 *             .admins(            
 *                 aws_iam_user.test().arn(),
 *                 aws_iam_role.test().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Create Default Permissions
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings(&#34;example&#34;, DataLakeSettingsArgs.builder()        
 *             .admins(            
 *                 aws_iam_user.test().arn(),
 *                 aws_iam_role.test().arn())
 *             .createDatabaseDefaultPermissions(DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder()
 *                 .permissions(                
 *                     &#34;SELECT&#34;,
 *                     &#34;ALTER&#34;,
 *                     &#34;DROP&#34;)
 *                 .principal(aws_iam_user.test().arn())
 *                 .build())
 *             .createTableDefaultPermissions(DataLakeSettingsCreateTableDefaultPermissionArgs.builder()
 *                 .permissions(&#34;ALL&#34;)
 *                 .principal(aws_iam_role.test().arn())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Enable EMR access to LakeFormation resources
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings(&#34;example&#34;, DataLakeSettingsArgs.builder()        
 *             .admins(            
 *                 aws_iam_user.test().arn(),
 *                 aws_iam_role.test().arn())
 *             .createDatabaseDefaultPermissions(DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder()
 *                 .permissions(                
 *                     &#34;SELECT&#34;,
 *                     &#34;ALTER&#34;,
 *                     &#34;DROP&#34;)
 *                 .principal(aws_iam_user.test().arn())
 *                 .build())
 *             .createTableDefaultPermissions(DataLakeSettingsCreateTableDefaultPermissionArgs.builder()
 *                 .permissions(&#34;ALL&#34;)
 *                 .principal(aws_iam_role.test().arn())
 *                 .build())
 *             .allowExternalDataFiltering(true)
 *             .externalDataFilteringAllowLists(            
 *                 data.aws_caller_identity().current().account_id(),
 *                 data.aws_caller_identity().third_party().account_id())
 *             .authorizedSessionTagValueLists(&#34;Amazon EMR&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:lakeformation/dataLakeSettings:DataLakeSettings")
public class DataLakeSettings extends com.pulumi.resources.CustomResource {
    /**
     * Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     * 
     */
    @Export(name="admins", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> admins;

    /**
     * @return Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     * 
     */
    public Output<List<String>> admins() {
        return this.admins;
    }
    /**
     * Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
     * 
     */
    @Export(name="allowExternalDataFiltering", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> allowExternalDataFiltering;

    /**
     * @return Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
     * 
     */
    public Output<Optional<Boolean>> allowExternalDataFiltering() {
        return Codegen.optional(this.allowExternalDataFiltering);
    }
    /**
     * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user&#39;s role while assuming it.
     * 
     * &gt; **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
     * 
     */
    @Export(name="authorizedSessionTagValueLists", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> authorizedSessionTagValueLists;

    /**
     * @return Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user&#39;s role while assuming it.
     * 
     * &gt; **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
     * 
     */
    public Output<List<String>> authorizedSessionTagValueLists() {
        return this.authorizedSessionTagValueLists;
    }
    /**
     * Identifier for the Data Catalog. By default, the account ID.
     * 
     */
    @Export(name="catalogId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> catalogId;

    /**
     * @return Identifier for the Data Catalog. By default, the account ID.
     * 
     */
    public Output<Optional<String>> catalogId() {
        return Codegen.optional(this.catalogId);
    }
    /**
     * Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     * 
     */
    @Export(name="createDatabaseDefaultPermissions", refs={List.class,DataLakeSettingsCreateDatabaseDefaultPermission.class}, tree="[0,1]")
    private Output<List<DataLakeSettingsCreateDatabaseDefaultPermission>> createDatabaseDefaultPermissions;

    /**
     * @return Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     * 
     */
    public Output<List<DataLakeSettingsCreateDatabaseDefaultPermission>> createDatabaseDefaultPermissions() {
        return this.createDatabaseDefaultPermissions;
    }
    /**
     * Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     * 
     */
    @Export(name="createTableDefaultPermissions", refs={List.class,DataLakeSettingsCreateTableDefaultPermission.class}, tree="[0,1]")
    private Output<List<DataLakeSettingsCreateTableDefaultPermission>> createTableDefaultPermissions;

    /**
     * @return Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     * 
     */
    public Output<List<DataLakeSettingsCreateTableDefaultPermission>> createTableDefaultPermissions() {
        return this.createTableDefaultPermissions;
    }
    /**
     * A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     * 
     */
    @Export(name="externalDataFilteringAllowLists", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> externalDataFilteringAllowLists;

    /**
     * @return A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     * 
     */
    public Output<List<String>> externalDataFilteringAllowLists() {
        return this.externalDataFilteringAllowLists;
    }
    /**
     * Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     * 
     */
    @Export(name="readOnlyAdmins", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> readOnlyAdmins;

    /**
     * @return Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     * 
     */
    public Output<List<String>> readOnlyAdmins() {
        return this.readOnlyAdmins;
    }
    /**
     * List of the resource-owning account IDs that the caller&#39;s account can use to share their user access details (user ARNs).
     * 
     */
    @Export(name="trustedResourceOwners", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> trustedResourceOwners;

    /**
     * @return List of the resource-owning account IDs that the caller&#39;s account can use to share their user access details (user ARNs).
     * 
     */
    public Output<List<String>> trustedResourceOwners() {
        return this.trustedResourceOwners;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DataLakeSettings(String name) {
        this(name, DataLakeSettingsArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DataLakeSettings(String name, @Nullable DataLakeSettingsArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DataLakeSettings(String name, @Nullable DataLakeSettingsArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lakeformation/dataLakeSettings:DataLakeSettings", name, args == null ? DataLakeSettingsArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DataLakeSettings(String name, Output<String> id, @Nullable DataLakeSettingsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:lakeformation/dataLakeSettings:DataLakeSettings", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DataLakeSettings get(String name, Output<String> id, @Nullable DataLakeSettingsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DataLakeSettings(name, id, state, options);
    }
}
