// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.kms.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetSecretsSecret {
    /**
     * @return An optional mapping that makes up the Encryption Context for the secret.
     * 
     */
    private @Nullable Map<String,String> context;
    /**
     * @return The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
     * 
     */
    private @Nullable String encryptionAlgorithm;
    /**
     * @return An optional list of Grant Tokens for the secret.
     * 
     */
    private @Nullable List<String> grantTokens;
    /**
     * @return Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
     * 
     * For more information on `context` and `grant_tokens` see the [KMS
     * Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
     * 
     */
    private @Nullable String keyId;
    /**
     * @return Name to export this secret under in the attributes.
     * 
     */
    private String name;
    /**
     * @return Base64 encoded payload, as returned from a KMS encrypt operation.
     * 
     */
    private String payload;

    private GetSecretsSecret() {}
    /**
     * @return An optional mapping that makes up the Encryption Context for the secret.
     * 
     */
    public Map<String,String> context() {
        return this.context == null ? Map.of() : this.context;
    }
    /**
     * @return The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
     * 
     */
    public Optional<String> encryptionAlgorithm() {
        return Optional.ofNullable(this.encryptionAlgorithm);
    }
    /**
     * @return An optional list of Grant Tokens for the secret.
     * 
     */
    public List<String> grantTokens() {
        return this.grantTokens == null ? List.of() : this.grantTokens;
    }
    /**
     * @return Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
     * 
     * For more information on `context` and `grant_tokens` see the [KMS
     * Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
     * 
     */
    public Optional<String> keyId() {
        return Optional.ofNullable(this.keyId);
    }
    /**
     * @return Name to export this secret under in the attributes.
     * 
     */
    public String name() {
        return this.name;
    }
    /**
     * @return Base64 encoded payload, as returned from a KMS encrypt operation.
     * 
     */
    public String payload() {
        return this.payload;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetSecretsSecret defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Map<String,String> context;
        private @Nullable String encryptionAlgorithm;
        private @Nullable List<String> grantTokens;
        private @Nullable String keyId;
        private String name;
        private String payload;
        public Builder() {}
        public Builder(GetSecretsSecret defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.context = defaults.context;
    	      this.encryptionAlgorithm = defaults.encryptionAlgorithm;
    	      this.grantTokens = defaults.grantTokens;
    	      this.keyId = defaults.keyId;
    	      this.name = defaults.name;
    	      this.payload = defaults.payload;
        }

        @CustomType.Setter
        public Builder context(@Nullable Map<String,String> context) {
            this.context = context;
            return this;
        }
        @CustomType.Setter
        public Builder encryptionAlgorithm(@Nullable String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }
        @CustomType.Setter
        public Builder grantTokens(@Nullable List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }
        public Builder grantTokens(String... grantTokens) {
            return grantTokens(List.of(grantTokens));
        }
        @CustomType.Setter
        public Builder keyId(@Nullable String keyId) {
            this.keyId = keyId;
            return this;
        }
        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }
        @CustomType.Setter
        public Builder payload(String payload) {
            this.payload = Objects.requireNonNull(payload);
            return this;
        }
        public GetSecretsSecret build() {
            final var o = new GetSecretsSecret();
            o.context = context;
            o.encryptionAlgorithm = encryptionAlgorithm;
            o.grantTokens = grantTokens;
            o.keyId = keyId;
            o.name = name;
            o.payload = payload;
            return o;
        }
    }
}
