// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.kms.inputs;

import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GetSecretsSecret extends com.pulumi.resources.InvokeArgs {

    public static final GetSecretsSecret Empty = new GetSecretsSecret();

    /**
     * An optional mapping that makes up the Encryption Context for the secret.
     * 
     */
    @Import(name="context")
    private @Nullable Map<String,String> context;

    /**
     * @return An optional mapping that makes up the Encryption Context for the secret.
     * 
     */
    public Optional<Map<String,String>> context() {
        return Optional.ofNullable(this.context);
    }

    /**
     * The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
     * 
     */
    @Import(name="encryptionAlgorithm")
    private @Nullable String encryptionAlgorithm;

    /**
     * @return The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
     * 
     */
    public Optional<String> encryptionAlgorithm() {
        return Optional.ofNullable(this.encryptionAlgorithm);
    }

    /**
     * An optional list of Grant Tokens for the secret.
     * 
     */
    @Import(name="grantTokens")
    private @Nullable List<String> grantTokens;

    /**
     * @return An optional list of Grant Tokens for the secret.
     * 
     */
    public Optional<List<String>> grantTokens() {
        return Optional.ofNullable(this.grantTokens);
    }

    /**
     * Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
     * 
     * For more information on `context` and `grant_tokens` see the [KMS
     * Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
     * 
     */
    @Import(name="keyId")
    private @Nullable String keyId;

    /**
     * @return Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
     * 
     * For more information on `context` and `grant_tokens` see the [KMS
     * Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
     * 
     */
    public Optional<String> keyId() {
        return Optional.ofNullable(this.keyId);
    }

    /**
     * Name to export this secret under in the attributes.
     * 
     */
    @Import(name="name", required=true)
    private String name;

    /**
     * @return Name to export this secret under in the attributes.
     * 
     */
    public String name() {
        return this.name;
    }

    /**
     * Base64 encoded payload, as returned from a KMS encrypt operation.
     * 
     */
    @Import(name="payload", required=true)
    private String payload;

    /**
     * @return Base64 encoded payload, as returned from a KMS encrypt operation.
     * 
     */
    public String payload() {
        return this.payload;
    }

    private GetSecretsSecret() {}

    private GetSecretsSecret(GetSecretsSecret $) {
        this.context = $.context;
        this.encryptionAlgorithm = $.encryptionAlgorithm;
        this.grantTokens = $.grantTokens;
        this.keyId = $.keyId;
        this.name = $.name;
        this.payload = $.payload;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GetSecretsSecret defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GetSecretsSecret $;

        public Builder() {
            $ = new GetSecretsSecret();
        }

        public Builder(GetSecretsSecret defaults) {
            $ = new GetSecretsSecret(Objects.requireNonNull(defaults));
        }

        /**
         * @param context An optional mapping that makes up the Encryption Context for the secret.
         * 
         * @return builder
         * 
         */
        public Builder context(@Nullable Map<String,String> context) {
            $.context = context;
            return this;
        }

        /**
         * @param encryptionAlgorithm The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
         * 
         * @return builder
         * 
         */
        public Builder encryptionAlgorithm(@Nullable String encryptionAlgorithm) {
            $.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        /**
         * @param grantTokens An optional list of Grant Tokens for the secret.
         * 
         * @return builder
         * 
         */
        public Builder grantTokens(@Nullable List<String> grantTokens) {
            $.grantTokens = grantTokens;
            return this;
        }

        /**
         * @param grantTokens An optional list of Grant Tokens for the secret.
         * 
         * @return builder
         * 
         */
        public Builder grantTokens(String... grantTokens) {
            return grantTokens(List.of(grantTokens));
        }

        /**
         * @param keyId Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
         * 
         * For more information on `context` and `grant_tokens` see the [KMS
         * Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
         * 
         * @return builder
         * 
         */
        public Builder keyId(@Nullable String keyId) {
            $.keyId = keyId;
            return this;
        }

        /**
         * @param name Name to export this secret under in the attributes.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            $.name = name;
            return this;
        }

        /**
         * @param payload Base64 encoded payload, as returned from a KMS encrypt operation.
         * 
         * @return builder
         * 
         */
        public Builder payload(String payload) {
            $.payload = payload;
            return this;
        }

        public GetSecretsSecret build() {
            $.name = Objects.requireNonNull($.name, "expected parameter 'name' to be non-null");
            $.payload = Objects.requireNonNull($.payload, "expected parameter 'payload' to be non-null");
            return $;
        }
    }

}
