// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.kinesis.inputs;

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgs;
import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs;
import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs;
import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class FirehoseDeliveryStreamHttpEndpointConfigurationArgs extends com.pulumi.resources.ResourceArgs {

    public static final FirehoseDeliveryStreamHttpEndpointConfigurationArgs Empty = new FirehoseDeliveryStreamHttpEndpointConfigurationArgs();

    /**
     * The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
     * 
     */
    @Import(name="accessKey")
    private @Nullable Output<String> accessKey;

    /**
     * @return The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
     * 
     */
    public Optional<Output<String>> accessKey() {
        return Optional.ofNullable(this.accessKey);
    }

    /**
     * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
     * 
     */
    @Import(name="bufferingInterval")
    private @Nullable Output<Integer> bufferingInterval;

    /**
     * @return Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
     * 
     */
    public Optional<Output<Integer>> bufferingInterval() {
        return Optional.ofNullable(this.bufferingInterval);
    }

    /**
     * Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
     * 
     */
    @Import(name="bufferingSize")
    private @Nullable Output<Integer> bufferingSize;

    /**
     * @return Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
     * 
     */
    public Optional<Output<Integer>> bufferingSize() {
        return Optional.ofNullable(this.bufferingSize);
    }

    /**
     * The CloudWatch Logging Options for the delivery stream. More details are given below.
     * 
     */
    @Import(name="cloudwatchLoggingOptions")
    private @Nullable Output<FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgs> cloudwatchLoggingOptions;

    /**
     * @return The CloudWatch Logging Options for the delivery stream. More details are given below.
     * 
     */
    public Optional<Output<FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgs>> cloudwatchLoggingOptions() {
        return Optional.ofNullable(this.cloudwatchLoggingOptions);
    }

    /**
     * The HTTP endpoint name.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The HTTP endpoint name.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The data processing configuration.  More details are given below.
     * 
     */
    @Import(name="processingConfiguration")
    private @Nullable Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs> processingConfiguration;

    /**
     * @return The data processing configuration.  More details are given below.
     * 
     */
    public Optional<Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs>> processingConfiguration() {
        return Optional.ofNullable(this.processingConfiguration);
    }

    /**
     * The request configuration.  More details are given below.
     * 
     */
    @Import(name="requestConfiguration")
    private @Nullable Output<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs> requestConfiguration;

    /**
     * @return The request configuration.  More details are given below.
     * 
     */
    public Optional<Output<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs>> requestConfiguration() {
        return Optional.ofNullable(this.requestConfiguration);
    }

    /**
     * Total amount of seconds Firehose spends on retries. This duration starts after the initial attempt fails, It does not include the time periods during which Firehose waits for acknowledgment from the specified destination after each attempt. Valid values between `0` and `7200`. Default is `300`.
     * 
     */
    @Import(name="retryDuration")
    private @Nullable Output<Integer> retryDuration;

    /**
     * @return Total amount of seconds Firehose spends on retries. This duration starts after the initial attempt fails, It does not include the time periods during which Firehose waits for acknowledgment from the specified destination after each attempt. Valid values between `0` and `7200`. Default is `300`.
     * 
     */
    public Optional<Output<Integer>> retryDuration() {
        return Optional.ofNullable(this.retryDuration);
    }

    /**
     * Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs. The pattern needs to be `arn:.*`.
     * 
     */
    @Import(name="roleArn")
    private @Nullable Output<String> roleArn;

    /**
     * @return Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs. The pattern needs to be `arn:.*`.
     * 
     */
    public Optional<Output<String>> roleArn() {
        return Optional.ofNullable(this.roleArn);
    }

    /**
     * Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDataOnly` and `AllData`.  Default value is `FailedDataOnly`.
     * 
     */
    @Import(name="s3BackupMode")
    private @Nullable Output<String> s3BackupMode;

    /**
     * @return Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDataOnly` and `AllData`.  Default value is `FailedDataOnly`.
     * 
     */
    public Optional<Output<String>> s3BackupMode() {
        return Optional.ofNullable(this.s3BackupMode);
    }

    /**
     * The S3 Configuration. See s3_configuration for more details.
     * 
     */
    @Import(name="s3Configuration", required=true)
    private Output<FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs> s3Configuration;

    /**
     * @return The S3 Configuration. See s3_configuration for more details.
     * 
     */
    public Output<FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs> s3Configuration() {
        return this.s3Configuration;
    }

    /**
     * The HTTP endpoint URL to which Kinesis Firehose sends your data.
     * 
     */
    @Import(name="url", required=true)
    private Output<String> url;

    /**
     * @return The HTTP endpoint URL to which Kinesis Firehose sends your data.
     * 
     */
    public Output<String> url() {
        return this.url;
    }

    private FirehoseDeliveryStreamHttpEndpointConfigurationArgs() {}

    private FirehoseDeliveryStreamHttpEndpointConfigurationArgs(FirehoseDeliveryStreamHttpEndpointConfigurationArgs $) {
        this.accessKey = $.accessKey;
        this.bufferingInterval = $.bufferingInterval;
        this.bufferingSize = $.bufferingSize;
        this.cloudwatchLoggingOptions = $.cloudwatchLoggingOptions;
        this.name = $.name;
        this.processingConfiguration = $.processingConfiguration;
        this.requestConfiguration = $.requestConfiguration;
        this.retryDuration = $.retryDuration;
        this.roleArn = $.roleArn;
        this.s3BackupMode = $.s3BackupMode;
        this.s3Configuration = $.s3Configuration;
        this.url = $.url;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(FirehoseDeliveryStreamHttpEndpointConfigurationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FirehoseDeliveryStreamHttpEndpointConfigurationArgs $;

        public Builder() {
            $ = new FirehoseDeliveryStreamHttpEndpointConfigurationArgs();
        }

        public Builder(FirehoseDeliveryStreamHttpEndpointConfigurationArgs defaults) {
            $ = new FirehoseDeliveryStreamHttpEndpointConfigurationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessKey The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
         * 
         * @return builder
         * 
         */
        public Builder accessKey(@Nullable Output<String> accessKey) {
            $.accessKey = accessKey;
            return this;
        }

        /**
         * @param accessKey The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
         * 
         * @return builder
         * 
         */
        public Builder accessKey(String accessKey) {
            return accessKey(Output.of(accessKey));
        }

        /**
         * @param bufferingInterval Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
         * 
         * @return builder
         * 
         */
        public Builder bufferingInterval(@Nullable Output<Integer> bufferingInterval) {
            $.bufferingInterval = bufferingInterval;
            return this;
        }

        /**
         * @param bufferingInterval Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
         * 
         * @return builder
         * 
         */
        public Builder bufferingInterval(Integer bufferingInterval) {
            return bufferingInterval(Output.of(bufferingInterval));
        }

        /**
         * @param bufferingSize Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
         * 
         * @return builder
         * 
         */
        public Builder bufferingSize(@Nullable Output<Integer> bufferingSize) {
            $.bufferingSize = bufferingSize;
            return this;
        }

        /**
         * @param bufferingSize Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
         * 
         * @return builder
         * 
         */
        public Builder bufferingSize(Integer bufferingSize) {
            return bufferingSize(Output.of(bufferingSize));
        }

        /**
         * @param cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. More details are given below.
         * 
         * @return builder
         * 
         */
        public Builder cloudwatchLoggingOptions(@Nullable Output<FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgs> cloudwatchLoggingOptions) {
            $.cloudwatchLoggingOptions = cloudwatchLoggingOptions;
            return this;
        }

        /**
         * @param cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. More details are given below.
         * 
         * @return builder
         * 
         */
        public Builder cloudwatchLoggingOptions(FirehoseDeliveryStreamHttpEndpointConfigurationCloudwatchLoggingOptionsArgs cloudwatchLoggingOptions) {
            return cloudwatchLoggingOptions(Output.of(cloudwatchLoggingOptions));
        }

        /**
         * @param name The HTTP endpoint name.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The HTTP endpoint name.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param processingConfiguration The data processing configuration.  More details are given below.
         * 
         * @return builder
         * 
         */
        public Builder processingConfiguration(@Nullable Output<FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs> processingConfiguration) {
            $.processingConfiguration = processingConfiguration;
            return this;
        }

        /**
         * @param processingConfiguration The data processing configuration.  More details are given below.
         * 
         * @return builder
         * 
         */
        public Builder processingConfiguration(FirehoseDeliveryStreamHttpEndpointConfigurationProcessingConfigurationArgs processingConfiguration) {
            return processingConfiguration(Output.of(processingConfiguration));
        }

        /**
         * @param requestConfiguration The request configuration.  More details are given below.
         * 
         * @return builder
         * 
         */
        public Builder requestConfiguration(@Nullable Output<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs> requestConfiguration) {
            $.requestConfiguration = requestConfiguration;
            return this;
        }

        /**
         * @param requestConfiguration The request configuration.  More details are given below.
         * 
         * @return builder
         * 
         */
        public Builder requestConfiguration(FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs requestConfiguration) {
            return requestConfiguration(Output.of(requestConfiguration));
        }

        /**
         * @param retryDuration Total amount of seconds Firehose spends on retries. This duration starts after the initial attempt fails, It does not include the time periods during which Firehose waits for acknowledgment from the specified destination after each attempt. Valid values between `0` and `7200`. Default is `300`.
         * 
         * @return builder
         * 
         */
        public Builder retryDuration(@Nullable Output<Integer> retryDuration) {
            $.retryDuration = retryDuration;
            return this;
        }

        /**
         * @param retryDuration Total amount of seconds Firehose spends on retries. This duration starts after the initial attempt fails, It does not include the time periods during which Firehose waits for acknowledgment from the specified destination after each attempt. Valid values between `0` and `7200`. Default is `300`.
         * 
         * @return builder
         * 
         */
        public Builder retryDuration(Integer retryDuration) {
            return retryDuration(Output.of(retryDuration));
        }

        /**
         * @param roleArn Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs. The pattern needs to be `arn:.*`.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(@Nullable Output<String> roleArn) {
            $.roleArn = roleArn;
            return this;
        }

        /**
         * @param roleArn Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs. The pattern needs to be `arn:.*`.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(String roleArn) {
            return roleArn(Output.of(roleArn));
        }

        /**
         * @param s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDataOnly` and `AllData`.  Default value is `FailedDataOnly`.
         * 
         * @return builder
         * 
         */
        public Builder s3BackupMode(@Nullable Output<String> s3BackupMode) {
            $.s3BackupMode = s3BackupMode;
            return this;
        }

        /**
         * @param s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDataOnly` and `AllData`.  Default value is `FailedDataOnly`.
         * 
         * @return builder
         * 
         */
        public Builder s3BackupMode(String s3BackupMode) {
            return s3BackupMode(Output.of(s3BackupMode));
        }

        /**
         * @param s3Configuration The S3 Configuration. See s3_configuration for more details.
         * 
         * @return builder
         * 
         */
        public Builder s3Configuration(Output<FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs> s3Configuration) {
            $.s3Configuration = s3Configuration;
            return this;
        }

        /**
         * @param s3Configuration The S3 Configuration. See s3_configuration for more details.
         * 
         * @return builder
         * 
         */
        public Builder s3Configuration(FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs s3Configuration) {
            return s3Configuration(Output.of(s3Configuration));
        }

        /**
         * @param url The HTTP endpoint URL to which Kinesis Firehose sends your data.
         * 
         * @return builder
         * 
         */
        public Builder url(Output<String> url) {
            $.url = url;
            return this;
        }

        /**
         * @param url The HTTP endpoint URL to which Kinesis Firehose sends your data.
         * 
         * @return builder
         * 
         */
        public Builder url(String url) {
            return url(Output.of(url));
        }

        public FirehoseDeliveryStreamHttpEndpointConfigurationArgs build() {
            $.s3Configuration = Objects.requireNonNull($.s3Configuration, "expected parameter 's3Configuration' to be non-null");
            $.url = Objects.requireNonNull($.url, "expected parameter 'url' to be non-null");
            return $;
        }
    }

}
