// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.kendra;

import com.pulumi.aws.kendra.inputs.IndexCapacityUnitsArgs;
import com.pulumi.aws.kendra.inputs.IndexDocumentMetadataConfigurationUpdateArgs;
import com.pulumi.aws.kendra.inputs.IndexServerSideEncryptionConfigurationArgs;
import com.pulumi.aws.kendra.inputs.IndexUserGroupResolutionConfigurationArgs;
import com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class IndexArgs extends com.pulumi.resources.ResourceArgs {

    public static final IndexArgs Empty = new IndexArgs();

    /**
     * A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
     * 
     */
    @Import(name="capacityUnits")
    private @Nullable Output<IndexCapacityUnitsArgs> capacityUnits;

    /**
     * @return A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
     * 
     */
    public Optional<Output<IndexCapacityUnitsArgs>> capacityUnits() {
        return Optional.ofNullable(this.capacityUnits);
    }

    /**
     * The description of the Index.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return The description of the Index.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     * 
     */
    @Import(name="documentMetadataConfigurationUpdates")
    private @Nullable Output<List<IndexDocumentMetadataConfigurationUpdateArgs>> documentMetadataConfigurationUpdates;

    /**
     * @return One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
     * 
     */
    public Optional<Output<List<IndexDocumentMetadataConfigurationUpdateArgs>>> documentMetadataConfigurationUpdates() {
        return Optional.ofNullable(this.documentMetadataConfigurationUpdates);
    }

    /**
     * The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can&#39;t be changed. Defaults to `ENTERPRISE_EDITION`
     * 
     */
    @Import(name="edition")
    private @Nullable Output<String> edition;

    /**
     * @return The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can&#39;t be changed. Defaults to `ENTERPRISE_EDITION`
     * 
     */
    public Optional<Output<String>> edition() {
        return Optional.ofNullable(this.edition);
    }

    /**
     * Specifies the name of the Index.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Specifies the name of the Index.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
     * 
     */
    @Import(name="roleArn", required=true)
    private Output<String> roleArn;

    /**
     * @return An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }

    /**
     * A block that specifies the identifier of the AWS KMS customer managed key (CMK) that&#39;s used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn&#39;t support asymmetric CMKs. Detailed below.
     * 
     */
    @Import(name="serverSideEncryptionConfiguration")
    private @Nullable Output<IndexServerSideEncryptionConfigurationArgs> serverSideEncryptionConfiguration;

    /**
     * @return A block that specifies the identifier of the AWS KMS customer managed key (CMK) that&#39;s used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn&#39;t support asymmetric CMKs. Detailed below.
     * 
     */
    public Optional<Output<IndexServerSideEncryptionConfigurationArgs>> serverSideEncryptionConfiguration() {
        return Optional.ofNullable(this.serverSideEncryptionConfiguration);
    }

    /**
     * Tags to apply to the Index. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Tags to apply to the Index. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
     * 
     */
    @Import(name="userContextPolicy")
    private @Nullable Output<String> userContextPolicy;

    /**
     * @return The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
     * 
     */
    public Optional<Output<String>> userContextPolicy() {
        return Optional.ofNullable(this.userContextPolicy);
    }

    /**
     * A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
     * 
     */
    @Import(name="userGroupResolutionConfiguration")
    private @Nullable Output<IndexUserGroupResolutionConfigurationArgs> userGroupResolutionConfiguration;

    /**
     * @return A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
     * 
     */
    public Optional<Output<IndexUserGroupResolutionConfigurationArgs>> userGroupResolutionConfiguration() {
        return Optional.ofNullable(this.userGroupResolutionConfiguration);
    }

    /**
     * A block that specifies the user token configuration. Detailed below.
     * 
     */
    @Import(name="userTokenConfigurations")
    private @Nullable Output<IndexUserTokenConfigurationsArgs> userTokenConfigurations;

    /**
     * @return A block that specifies the user token configuration. Detailed below.
     * 
     */
    public Optional<Output<IndexUserTokenConfigurationsArgs>> userTokenConfigurations() {
        return Optional.ofNullable(this.userTokenConfigurations);
    }

    private IndexArgs() {}

    private IndexArgs(IndexArgs $) {
        this.capacityUnits = $.capacityUnits;
        this.description = $.description;
        this.documentMetadataConfigurationUpdates = $.documentMetadataConfigurationUpdates;
        this.edition = $.edition;
        this.name = $.name;
        this.roleArn = $.roleArn;
        this.serverSideEncryptionConfiguration = $.serverSideEncryptionConfiguration;
        this.tags = $.tags;
        this.userContextPolicy = $.userContextPolicy;
        this.userGroupResolutionConfiguration = $.userGroupResolutionConfiguration;
        this.userTokenConfigurations = $.userTokenConfigurations;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(IndexArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private IndexArgs $;

        public Builder() {
            $ = new IndexArgs();
        }

        public Builder(IndexArgs defaults) {
            $ = new IndexArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param capacityUnits A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder capacityUnits(@Nullable Output<IndexCapacityUnitsArgs> capacityUnits) {
            $.capacityUnits = capacityUnits;
            return this;
        }

        /**
         * @param capacityUnits A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder capacityUnits(IndexCapacityUnitsArgs capacityUnits) {
            return capacityUnits(Output.of(capacityUnits));
        }

        /**
         * @param description The description of the Index.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description The description of the Index.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param documentMetadataConfigurationUpdates One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
         * 
         * @return builder
         * 
         */
        public Builder documentMetadataConfigurationUpdates(@Nullable Output<List<IndexDocumentMetadataConfigurationUpdateArgs>> documentMetadataConfigurationUpdates) {
            $.documentMetadataConfigurationUpdates = documentMetadataConfigurationUpdates;
            return this;
        }

        /**
         * @param documentMetadataConfigurationUpdates One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
         * 
         * @return builder
         * 
         */
        public Builder documentMetadataConfigurationUpdates(List<IndexDocumentMetadataConfigurationUpdateArgs> documentMetadataConfigurationUpdates) {
            return documentMetadataConfigurationUpdates(Output.of(documentMetadataConfigurationUpdates));
        }

        /**
         * @param documentMetadataConfigurationUpdates One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
         * 
         * @return builder
         * 
         */
        public Builder documentMetadataConfigurationUpdates(IndexDocumentMetadataConfigurationUpdateArgs... documentMetadataConfigurationUpdates) {
            return documentMetadataConfigurationUpdates(List.of(documentMetadataConfigurationUpdates));
        }

        /**
         * @param edition The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can&#39;t be changed. Defaults to `ENTERPRISE_EDITION`
         * 
         * @return builder
         * 
         */
        public Builder edition(@Nullable Output<String> edition) {
            $.edition = edition;
            return this;
        }

        /**
         * @param edition The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can&#39;t be changed. Defaults to `ENTERPRISE_EDITION`
         * 
         * @return builder
         * 
         */
        public Builder edition(String edition) {
            return edition(Output.of(edition));
        }

        /**
         * @param name Specifies the name of the Index.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Specifies the name of the Index.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param roleArn An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(Output<String> roleArn) {
            $.roleArn = roleArn;
            return this;
        }

        /**
         * @param roleArn An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(String roleArn) {
            return roleArn(Output.of(roleArn));
        }

        /**
         * @param serverSideEncryptionConfiguration A block that specifies the identifier of the AWS KMS customer managed key (CMK) that&#39;s used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn&#39;t support asymmetric CMKs. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder serverSideEncryptionConfiguration(@Nullable Output<IndexServerSideEncryptionConfigurationArgs> serverSideEncryptionConfiguration) {
            $.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        /**
         * @param serverSideEncryptionConfiguration A block that specifies the identifier of the AWS KMS customer managed key (CMK) that&#39;s used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn&#39;t support asymmetric CMKs. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder serverSideEncryptionConfiguration(IndexServerSideEncryptionConfigurationArgs serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(Output.of(serverSideEncryptionConfiguration));
        }

        /**
         * @param tags Tags to apply to the Index. If configured with a provider
         * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Tags to apply to the Index. If configured with a provider
         * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param userContextPolicy The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
         * 
         * @return builder
         * 
         */
        public Builder userContextPolicy(@Nullable Output<String> userContextPolicy) {
            $.userContextPolicy = userContextPolicy;
            return this;
        }

        /**
         * @param userContextPolicy The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
         * 
         * @return builder
         * 
         */
        public Builder userContextPolicy(String userContextPolicy) {
            return userContextPolicy(Output.of(userContextPolicy));
        }

        /**
         * @param userGroupResolutionConfiguration A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder userGroupResolutionConfiguration(@Nullable Output<IndexUserGroupResolutionConfigurationArgs> userGroupResolutionConfiguration) {
            $.userGroupResolutionConfiguration = userGroupResolutionConfiguration;
            return this;
        }

        /**
         * @param userGroupResolutionConfiguration A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder userGroupResolutionConfiguration(IndexUserGroupResolutionConfigurationArgs userGroupResolutionConfiguration) {
            return userGroupResolutionConfiguration(Output.of(userGroupResolutionConfiguration));
        }

        /**
         * @param userTokenConfigurations A block that specifies the user token configuration. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder userTokenConfigurations(@Nullable Output<IndexUserTokenConfigurationsArgs> userTokenConfigurations) {
            $.userTokenConfigurations = userTokenConfigurations;
            return this;
        }

        /**
         * @param userTokenConfigurations A block that specifies the user token configuration. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder userTokenConfigurations(IndexUserTokenConfigurationsArgs userTokenConfigurations) {
            return userTokenConfigurations(Output.of(userTokenConfigurations));
        }

        public IndexArgs build() {
            $.roleArn = Objects.requireNonNull($.roleArn, "expected parameter 'roleArn' to be non-null");
            return $;
        }
    }

}
