// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ivschat;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ivschat.RoomArgs;
import com.pulumi.aws.ivschat.inputs.RoomState;
import com.pulumi.aws.ivschat.outputs.RoomMessageReviewHandler;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS IVS (Interactive Video) Chat Room.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivschat.Room;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Room(&#34;example&#34;);
 * 
 *     }
 * }
 * ```
 * ## Usage with Logging Configuration to S3 Bucket
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.ivschat.LoggingConfiguration;
 * import com.pulumi.aws.ivschat.LoggingConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationS3Args;
 * import com.pulumi.aws.ivschat.Room;
 * import com.pulumi.aws.ivschat.RoomArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2(&#34;exampleBucketV2&#34;, BucketV2Args.builder()        
 *             .bucketPrefix(&#34;tf-ivschat-logging-bucket-&#34;)
 *             .forceDestroy(true)
 *             .build());
 * 
 *         var exampleLoggingConfiguration = new LoggingConfiguration(&#34;exampleLoggingConfiguration&#34;, LoggingConfigurationArgs.builder()        
 *             .destinationConfiguration(LoggingConfigurationDestinationConfigurationArgs.builder()
 *                 .s3(LoggingConfigurationDestinationConfigurationS3Args.builder()
 *                     .bucketName(exampleBucketV2.id())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *         var exampleRoom = new Room(&#34;exampleRoom&#34;, RoomArgs.builder()        
 *             .loggingConfigurationIdentifiers(exampleLoggingConfiguration.arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import IVS (Interactive Video) Chat Room using the ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ivschat/room:Room example arn:aws:ivschat:us-west-2:326937407773:room/GoXEXyB4VwHb
 * ```
 * 
 */
@ResourceType(type="aws:ivschat/room:Room")
public class Room extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Room.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Room.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * List of Logging Configuration
     * ARNs to attach to the room.
     * 
     */
    @Export(name="loggingConfigurationIdentifiers", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> loggingConfigurationIdentifiers;

    /**
     * @return List of Logging Configuration
     * ARNs to attach to the room.
     * 
     */
    public Output<Optional<List<String>>> loggingConfigurationIdentifiers() {
        return Codegen.optional(this.loggingConfigurationIdentifiers);
    }
    /**
     * Maximum number of characters in a single
     * message. Messages are expected to be UTF-8 encoded and this limit applies
     * specifically to rune/code-point count, not number of bytes.
     * 
     */
    @Export(name="maximumMessageLength", refs={Integer.class}, tree="[0]")
    private Output<Integer> maximumMessageLength;

    /**
     * @return Maximum number of characters in a single
     * message. Messages are expected to be UTF-8 encoded and this limit applies
     * specifically to rune/code-point count, not number of bytes.
     * 
     */
    public Output<Integer> maximumMessageLength() {
        return this.maximumMessageLength;
    }
    /**
     * Maximum number of messages per
     * second that can be sent to the room (by all clients).
     * 
     */
    @Export(name="maximumMessageRatePerSecond", refs={Integer.class}, tree="[0]")
    private Output<Integer> maximumMessageRatePerSecond;

    /**
     * @return Maximum number of messages per
     * second that can be sent to the room (by all clients).
     * 
     */
    public Output<Integer> maximumMessageRatePerSecond() {
        return this.maximumMessageRatePerSecond;
    }
    /**
     * Configuration information for optional
     * review of messages.
     * 
     */
    @Export(name="messageReviewHandler", refs={RoomMessageReviewHandler.class}, tree="[0]")
    private Output</* @Nullable */ RoomMessageReviewHandler> messageReviewHandler;

    /**
     * @return Configuration information for optional
     * review of messages.
     * 
     */
    public Output<Optional<RoomMessageReviewHandler>> messageReviewHandler() {
        return Codegen.optional(this.messageReviewHandler);
    }
    /**
     * Room name.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Room name.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Room(String name) {
        this(name, RoomArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Room(String name, @Nullable RoomArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Room(String name, @Nullable RoomArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ivschat/room:Room", name, args == null ? RoomArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Room(String name, Output<String> id, @Nullable RoomState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ivschat/room:Room", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Room get(String name, Output<String> id, @Nullable RoomState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Room(name, id, state, options);
    }
}
