// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ivs;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ivs.PlaybackKeyPairArgs;
import com.pulumi.aws.ivs.inputs.PlaybackKeyPairState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS IVS (Interactive Video) Playback Key Pair.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivs.PlaybackKeyPair;
 * import com.pulumi.aws.ivs.PlaybackKeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new PlaybackKeyPair(&#34;example&#34;, PlaybackKeyPairArgs.builder()        
 *             .publicKey(Files.readString(Paths.get(&#34;./public-key.pem&#34;)))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import IVS (Interactive Video) Playback Key Pair using the ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ivs/playbackKeyPair:PlaybackKeyPair example arn:aws:ivs:us-west-2:326937407773:playback-key/KDJRJNQhiQzA
 * ```
 * 
 */
@ResourceType(type="aws:ivs/playbackKeyPair:PlaybackKeyPair")
public class PlaybackKeyPair extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Playback Key Pair.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Playback Key Pair.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Key-pair identifier.
     * 
     */
    @Export(name="fingerprint", refs={String.class}, tree="[0]")
    private Output<String> fingerprint;

    /**
     * @return Key-pair identifier.
     * 
     */
    public Output<String> fingerprint() {
        return this.fingerprint;
    }
    /**
     * Playback Key Pair name.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Playback Key Pair name.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Public portion of a customer-generated key pair. Must be an ECDSA public key in PEM format.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="publicKey", refs={String.class}, tree="[0]")
    private Output<String> publicKey;

    /**
     * @return Public portion of a customer-generated key pair. Must be an ECDSA public key in PEM format.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> publicKey() {
        return this.publicKey;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public PlaybackKeyPair(String name) {
        this(name, PlaybackKeyPairArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public PlaybackKeyPair(String name, PlaybackKeyPairArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public PlaybackKeyPair(String name, PlaybackKeyPairArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ivs/playbackKeyPair:PlaybackKeyPair", name, args == null ? PlaybackKeyPairArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private PlaybackKeyPair(String name, Output<String> id, @Nullable PlaybackKeyPairState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ivs/playbackKeyPair:PlaybackKeyPair", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static PlaybackKeyPair get(String name, Output<String> id, @Nullable PlaybackKeyPairState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new PlaybackKeyPair(name, id, state, options);
    }
}
