// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.iot;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.iot.ThingGroupMembershipArgs;
import com.pulumi.aws.iot.inputs.ThingGroupMembershipState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Adds an IoT Thing to an IoT Thing Group.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.ThingGroupMembership;
 * import com.pulumi.aws.iot.ThingGroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ThingGroupMembership(&#34;example&#34;, ThingGroupMembershipArgs.builder()        
 *             .overrideDynamicGroup(true)
 *             .thingGroupName(&#34;example-group&#34;)
 *             .thingName(&#34;example-thing&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import IoT Thing Group Membership using the thing group name and thing name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:iot/thingGroupMembership:ThingGroupMembership example thing_group_name/thing_name
 * ```
 * 
 */
@ResourceType(type="aws:iot/thingGroupMembership:ThingGroupMembership")
public class ThingGroupMembership extends com.pulumi.resources.CustomResource {
    /**
     * Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.
     * 
     */
    @Export(name="overrideDynamicGroup", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> overrideDynamicGroup;

    /**
     * @return Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.
     * 
     */
    public Output<Optional<Boolean>> overrideDynamicGroup() {
        return Codegen.optional(this.overrideDynamicGroup);
    }
    /**
     * The name of the group to which you are adding a thing.
     * 
     */
    @Export(name="thingGroupName", refs={String.class}, tree="[0]")
    private Output<String> thingGroupName;

    /**
     * @return The name of the group to which you are adding a thing.
     * 
     */
    public Output<String> thingGroupName() {
        return this.thingGroupName;
    }
    /**
     * The name of the thing to add to a group.
     * 
     */
    @Export(name="thingName", refs={String.class}, tree="[0]")
    private Output<String> thingName;

    /**
     * @return The name of the thing to add to a group.
     * 
     */
    public Output<String> thingName() {
        return this.thingName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ThingGroupMembership(String name) {
        this(name, ThingGroupMembershipArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ThingGroupMembership(String name, ThingGroupMembershipArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ThingGroupMembership(String name, ThingGroupMembershipArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iot/thingGroupMembership:ThingGroupMembership", name, args == null ? ThingGroupMembershipArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ThingGroupMembership(String name, Output<String> id, @Nullable ThingGroupMembershipState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iot/thingGroupMembership:ThingGroupMembership", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ThingGroupMembership get(String name, Output<String> id, @Nullable ThingGroupMembershipState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ThingGroupMembership(name, id, state, options);
    }
}
