// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.iot;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.iot.RoleAliasArgs;
import com.pulumi.aws.iot.inputs.RoleAliasState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an IoT role alias.
 * 
 * ## Example Usage
 * 
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iot.RoleAlias;
 * import com.pulumi.aws.iot.RoleAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .effect(&#34;Allow&#34;)
 *             .principals(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .actions(&#34;sts:AssumeRole&#34;)
 *             .build());
 * 
 *         var role = new Role(&#34;role&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var alias = new RoleAlias(&#34;alias&#34;, RoleAliasArgs.builder()        
 *             .alias(&#34;Thermostat-dynamodb-access-role-alias&#34;)
 *             .roleArn(role.arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import IOT Role Alias using the alias. For example:
 * 
 * ```sh
 *  $ pulumi import aws:iot/roleAlias:RoleAlias example myalias
 * ```
 * 
 */
@ResourceType(type="aws:iot/roleAlias:RoleAlias")
public class RoleAlias extends com.pulumi.resources.CustomResource {
    /**
     * The name of the role alias.
     * 
     */
    @Export(name="alias", refs={String.class}, tree="[0]")
    private Output<String> alias;

    /**
     * @return The name of the role alias.
     * 
     */
    public Output<String> alias() {
        return this.alias;
    }
    /**
     * The ARN assigned by AWS to this role alias.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN assigned by AWS to this role alias.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The duration of the credential, in seconds. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 900 seconds (15 minutes) to 43200 seconds (12 hours).
     * 
     */
    @Export(name="credentialDuration", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> credentialDuration;

    /**
     * @return The duration of the credential, in seconds. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 900 seconds (15 minutes) to 43200 seconds (12 hours).
     * 
     */
    public Output<Optional<Integer>> credentialDuration() {
        return Codegen.optional(this.credentialDuration);
    }
    /**
     * The identity of the role to which the alias refers.
     * 
     */
    @Export(name="roleArn", refs={String.class}, tree="[0]")
    private Output<String> roleArn;

    /**
     * @return The identity of the role to which the alias refers.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public RoleAlias(String name) {
        this(name, RoleAliasArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public RoleAlias(String name, RoleAliasArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public RoleAlias(String name, RoleAliasArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iot/roleAlias:RoleAlias", name, args == null ? RoleAliasArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private RoleAlias(String name, Output<String> id, @Nullable RoleAliasState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iot/roleAlias:RoleAlias", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static RoleAlias get(String name, Output<String> id, @Nullable RoleAliasState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new RoleAlias(name, id, state, options);
    }
}
