// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.iot;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.iot.IndexingConfigurationArgs;
import com.pulumi.aws.iot.inputs.IndexingConfigurationState;
import com.pulumi.aws.iot.outputs.IndexingConfigurationThingGroupIndexingConfiguration;
import com.pulumi.aws.iot.outputs.IndexingConfigurationThingIndexingConfiguration;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import javax.annotation.Nullable;

/**
 * Managing [IoT Thing indexing](https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html).
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.IndexingConfiguration;
 * import com.pulumi.aws.iot.IndexingConfigurationArgs;
 * import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new IndexingConfiguration(&#34;example&#34;, IndexingConfigurationArgs.builder()        
 *             .thingIndexingConfiguration(IndexingConfigurationThingIndexingConfigurationArgs.builder()
 *                 .customFields(                
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name(&#34;shadow.desired.power&#34;)
 *                         .type(&#34;Boolean&#34;)
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name(&#34;attributes.version&#34;)
 *                         .type(&#34;Number&#34;)
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name(&#34;shadow.name.thing1shadow.desired.DefaultDesired&#34;)
 *                         .type(&#34;String&#34;)
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name(&#34;deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number&#34;)
 *                         .type(&#34;Number&#34;)
 *                         .build())
 *                 .deviceDefenderIndexingMode(&#34;VIOLATIONS&#34;)
 *                 .namedShadowIndexingMode(&#34;ON&#34;)
 *                 .thingConnectivityIndexingMode(&#34;STATUS&#34;)
 *                 .thingIndexingMode(&#34;REGISTRY_AND_SHADOW&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:iot/indexingConfiguration:IndexingConfiguration")
public class IndexingConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * Thing group indexing configuration. See below.
     * 
     */
    @Export(name="thingGroupIndexingConfiguration", refs={IndexingConfigurationThingGroupIndexingConfiguration.class}, tree="[0]")
    private Output<IndexingConfigurationThingGroupIndexingConfiguration> thingGroupIndexingConfiguration;

    /**
     * @return Thing group indexing configuration. See below.
     * 
     */
    public Output<IndexingConfigurationThingGroupIndexingConfiguration> thingGroupIndexingConfiguration() {
        return this.thingGroupIndexingConfiguration;
    }
    /**
     * Thing indexing configuration. See below.
     * 
     */
    @Export(name="thingIndexingConfiguration", refs={IndexingConfigurationThingIndexingConfiguration.class}, tree="[0]")
    private Output<IndexingConfigurationThingIndexingConfiguration> thingIndexingConfiguration;

    /**
     * @return Thing indexing configuration. See below.
     * 
     */
    public Output<IndexingConfigurationThingIndexingConfiguration> thingIndexingConfiguration() {
        return this.thingIndexingConfiguration;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public IndexingConfiguration(String name) {
        this(name, IndexingConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public IndexingConfiguration(String name, @Nullable IndexingConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public IndexingConfiguration(String name, @Nullable IndexingConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iot/indexingConfiguration:IndexingConfiguration", name, args == null ? IndexingConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private IndexingConfiguration(String name, Output<String> id, @Nullable IndexingConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iot/indexingConfiguration:IndexingConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static IndexingConfiguration get(String name, Output<String> id, @Nullable IndexingConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new IndexingConfiguration(name, id, state, options);
    }
}
