// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.inspector;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.inspector.AssessmentTargetArgs;
import com.pulumi.aws.inspector.inputs.AssessmentTargetState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an Inspector Classic Assessment Target
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector.ResourceGroup;
 * import com.pulumi.aws.inspector.ResourceGroupArgs;
 * import com.pulumi.aws.inspector.AssessmentTarget;
 * import com.pulumi.aws.inspector.AssessmentTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var bar = new ResourceGroup(&#34;bar&#34;, ResourceGroupArgs.builder()        
 *             .tags(Map.ofEntries(
 *                 Map.entry(&#34;Name&#34;, &#34;foo&#34;),
 *                 Map.entry(&#34;Env&#34;, &#34;bar&#34;)
 *             ))
 *             .build());
 * 
 *         var foo = new AssessmentTarget(&#34;foo&#34;, AssessmentTargetArgs.builder()        
 *             .resourceGroupArn(bar.arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Inspector Classic Assessment Targets using their Amazon Resource Name (ARN). For example:
 * 
 * ```sh
 *  $ pulumi import aws:inspector/assessmentTarget:AssessmentTarget example arn:aws:inspector:us-east-1:123456789012:target/0-xxxxxxx
 * ```
 * 
 */
@ResourceType(type="aws:inspector/assessmentTarget:AssessmentTarget")
public class AssessmentTarget extends com.pulumi.resources.CustomResource {
    /**
     * The target assessment ARN.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The target assessment ARN.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The name of the assessment target.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the assessment target.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Inspector Resource Group Amazon Resource Name (ARN) stating tags for instance matching. If not specified, all EC2 instances in the current AWS account and region are included in the assessment target.
     * 
     */
    @Export(name="resourceGroupArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> resourceGroupArn;

    /**
     * @return Inspector Resource Group Amazon Resource Name (ARN) stating tags for instance matching. If not specified, all EC2 instances in the current AWS account and region are included in the assessment target.
     * 
     */
    public Output<Optional<String>> resourceGroupArn() {
        return Codegen.optional(this.resourceGroupArn);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AssessmentTarget(String name) {
        this(name, AssessmentTargetArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AssessmentTarget(String name, @Nullable AssessmentTargetArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AssessmentTarget(String name, @Nullable AssessmentTargetArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:inspector/assessmentTarget:AssessmentTarget", name, args == null ? AssessmentTargetArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AssessmentTarget(String name, Output<String> id, @Nullable AssessmentTargetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:inspector/assessmentTarget:AssessmentTarget", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AssessmentTarget get(String name, Output<String> id, @Nullable AssessmentTargetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AssessmentTarget(name, id, state, options);
    }
}
