// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.imagebuilder;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.imagebuilder.ContainerRecipeArgs;
import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeState;
import com.pulumi.aws.imagebuilder.outputs.ContainerRecipeComponent;
import com.pulumi.aws.imagebuilder.outputs.ContainerRecipeInstanceConfiguration;
import com.pulumi.aws.imagebuilder.outputs.ContainerRecipeTargetRepository;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an Image Builder Container Recipe.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.ContainerRecipe;
 * import com.pulumi.aws.imagebuilder.ContainerRecipeArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeTargetRepositoryArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ContainerRecipe(&#34;example&#34;, ContainerRecipeArgs.builder()        
 *             .version(&#34;1.0.0&#34;)
 *             .containerType(&#34;DOCKER&#34;)
 *             .parentImage(&#34;arn:aws:imagebuilder:eu-central-1:aws:image/amazon-linux-x86-latest/x.x.x&#34;)
 *             .targetRepository(ContainerRecipeTargetRepositoryArgs.builder()
 *                 .repositoryName(aws_ecr_repository.example().name())
 *                 .service(&#34;ECR&#34;)
 *                 .build())
 *             .components(ContainerRecipeComponentArgs.builder()
 *                 .componentArn(aws_imagebuilder_component.example().arn())
 *                 .parameters(                
 *                     ContainerRecipeComponentParameterArgs.builder()
 *                         .name(&#34;Parameter1&#34;)
 *                         .value(&#34;Value1&#34;)
 *                         .build(),
 *                     ContainerRecipeComponentParameterArgs.builder()
 *                         .name(&#34;Parameter2&#34;)
 *                         .value(&#34;Value2&#34;)
 *                         .build())
 *                 .build())
 *             .dockerfileTemplateData(&#34;&#34;&#34;
 * FROM {{{ imagebuilder:parentImage }}}
 * {{{ imagebuilder:environments }}}
 * {{{ imagebuilder:components }}}
 *             &#34;&#34;&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_imagebuilder_container_recipe` resources using the Amazon Resource Name (ARN). For example:
 * 
 * ```sh
 *  $ pulumi import aws:imagebuilder/containerRecipe:ContainerRecipe example arn:aws:imagebuilder:us-east-1:123456789012:container-recipe/example/1.0.0
 * ```
 * 
 */
@ResourceType(type="aws:imagebuilder/containerRecipe:ContainerRecipe")
public class ContainerRecipe extends com.pulumi.resources.CustomResource {
    /**
     * (Required) Amazon Resource Name (ARN) of the container recipe.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return (Required) Amazon Resource Name (ARN) of the container recipe.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Ordered configuration block(s) with components for the container recipe. Detailed below.
     * 
     */
    @Export(name="components", refs={List.class,ContainerRecipeComponent.class}, tree="[0,1]")
    private Output<List<ContainerRecipeComponent>> components;

    /**
     * @return Ordered configuration block(s) with components for the container recipe. Detailed below.
     * 
     */
    public Output<List<ContainerRecipeComponent>> components() {
        return this.components;
    }
    /**
     * The type of the container to create. Valid values: `DOCKER`.
     * 
     */
    @Export(name="containerType", refs={String.class}, tree="[0]")
    private Output<String> containerType;

    /**
     * @return The type of the container to create. Valid values: `DOCKER`.
     * 
     */
    public Output<String> containerType() {
        return this.containerType;
    }
    /**
     * Date the container recipe was created.
     * 
     */
    @Export(name="dateCreated", refs={String.class}, tree="[0]")
    private Output<String> dateCreated;

    /**
     * @return Date the container recipe was created.
     * 
     */
    public Output<String> dateCreated() {
        return this.dateCreated;
    }
    /**
     * The description of the container recipe.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return The description of the container recipe.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The Dockerfile template used to build the image as an inline data blob.
     * 
     */
    @Export(name="dockerfileTemplateData", refs={String.class}, tree="[0]")
    private Output<String> dockerfileTemplateData;

    /**
     * @return The Dockerfile template used to build the image as an inline data blob.
     * 
     */
    public Output<String> dockerfileTemplateData() {
        return this.dockerfileTemplateData;
    }
    /**
     * The Amazon S3 URI for the Dockerfile that will be used to build the container image.
     * 
     */
    @Export(name="dockerfileTemplateUri", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> dockerfileTemplateUri;

    /**
     * @return The Amazon S3 URI for the Dockerfile that will be used to build the container image.
     * 
     */
    public Output<Optional<String>> dockerfileTemplateUri() {
        return Codegen.optional(this.dockerfileTemplateUri);
    }
    /**
     * Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
     * 
     */
    @Export(name="encrypted", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> encrypted;

    /**
     * @return Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
     * 
     */
    public Output<Boolean> encrypted() {
        return this.encrypted;
    }
    /**
     * Configuration block used to configure an instance for building and testing container images. Detailed below.
     * 
     */
    @Export(name="instanceConfiguration", refs={ContainerRecipeInstanceConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ ContainerRecipeInstanceConfiguration> instanceConfiguration;

    /**
     * @return Configuration block used to configure an instance for building and testing container images. Detailed below.
     * 
     */
    public Output<Optional<ContainerRecipeInstanceConfiguration>> instanceConfiguration() {
        return Codegen.optional(this.instanceConfiguration);
    }
    /**
     * The KMS key used to encrypt the container image.
     * 
     */
    @Export(name="kmsKeyId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> kmsKeyId;

    /**
     * @return The KMS key used to encrypt the container image.
     * 
     */
    public Output<Optional<String>> kmsKeyId() {
        return Codegen.optional(this.kmsKeyId);
    }
    /**
     * The name of the container recipe.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the container recipe.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Owner of the container recipe.
     * 
     */
    @Export(name="owner", refs={String.class}, tree="[0]")
    private Output<String> owner;

    /**
     * @return Owner of the container recipe.
     * 
     */
    public Output<String> owner() {
        return this.owner;
    }
    /**
     * The base image for the container recipe.
     * 
     */
    @Export(name="parentImage", refs={String.class}, tree="[0]")
    private Output<String> parentImage;

    /**
     * @return The base image for the container recipe.
     * 
     */
    public Output<String> parentImage() {
        return this.parentImage;
    }
    /**
     * Platform of the container recipe.
     * 
     */
    @Export(name="platform", refs={String.class}, tree="[0]")
    private Output<String> platform;

    /**
     * @return Platform of the container recipe.
     * 
     */
    public Output<String> platform() {
        return this.platform;
    }
    /**
     * Specifies the operating system platform when you use a custom base image.
     * 
     */
    @Export(name="platformOverride", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> platformOverride;

    /**
     * @return Specifies the operating system platform when you use a custom base image.
     * 
     */
    public Output<Optional<String>> platformOverride() {
        return Codegen.optional(this.platformOverride);
    }
    /**
     * Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The destination repository for the container image. Detailed below.
     * 
     */
    @Export(name="targetRepository", refs={ContainerRecipeTargetRepository.class}, tree="[0]")
    private Output<ContainerRecipeTargetRepository> targetRepository;

    /**
     * @return The destination repository for the container image. Detailed below.
     * 
     */
    public Output<ContainerRecipeTargetRepository> targetRepository() {
        return this.targetRepository;
    }
    /**
     * Version of the container recipe.
     * 
     * The following attributes are optional:
     * 
     */
    @Export(name="version", refs={String.class}, tree="[0]")
    private Output<String> version;

    /**
     * @return Version of the container recipe.
     * 
     * The following attributes are optional:
     * 
     */
    public Output<String> version() {
        return this.version;
    }
    /**
     * The working directory to be used during build and test workflows.
     * 
     */
    @Export(name="workingDirectory", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> workingDirectory;

    /**
     * @return The working directory to be used during build and test workflows.
     * 
     */
    public Output<Optional<String>> workingDirectory() {
        return Codegen.optional(this.workingDirectory);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ContainerRecipe(String name) {
        this(name, ContainerRecipeArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ContainerRecipe(String name, ContainerRecipeArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ContainerRecipe(String name, ContainerRecipeArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:imagebuilder/containerRecipe:ContainerRecipe", name, args == null ? ContainerRecipeArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ContainerRecipe(String name, Output<String> id, @Nullable ContainerRecipeState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:imagebuilder/containerRecipe:ContainerRecipe", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ContainerRecipe get(String name, Output<String> id, @Nullable ContainerRecipeState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ContainerRecipe(name, id, state, options);
    }
}
