// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.identitystore;

import com.pulumi.aws.identitystore.inputs.UserAddressesArgs;
import com.pulumi.aws.identitystore.inputs.UserEmailsArgs;
import com.pulumi.aws.identitystore.inputs.UserNameArgs;
import com.pulumi.aws.identitystore.inputs.UserPhoneNumbersArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class UserArgs extends com.pulumi.resources.ResourceArgs {

    public static final UserArgs Empty = new UserArgs();

    /**
     * Details about the user&#39;s address. At most 1 address is allowed. Detailed below.
     * 
     */
    @Import(name="addresses")
    private @Nullable Output<UserAddressesArgs> addresses;

    /**
     * @return Details about the user&#39;s address. At most 1 address is allowed. Detailed below.
     * 
     */
    public Optional<Output<UserAddressesArgs>> addresses() {
        return Optional.ofNullable(this.addresses);
    }

    /**
     * The name that is typically displayed when the user is referenced.
     * 
     */
    @Import(name="displayName", required=true)
    private Output<String> displayName;

    /**
     * @return The name that is typically displayed when the user is referenced.
     * 
     */
    public Output<String> displayName() {
        return this.displayName;
    }

    /**
     * Details about the user&#39;s email. At most 1 email is allowed. Detailed below.
     * 
     */
    @Import(name="emails")
    private @Nullable Output<UserEmailsArgs> emails;

    /**
     * @return Details about the user&#39;s email. At most 1 email is allowed. Detailed below.
     * 
     */
    public Optional<Output<UserEmailsArgs>> emails() {
        return Optional.ofNullable(this.emails);
    }

    /**
     * The globally unique identifier for the identity store that this user is in.
     * 
     */
    @Import(name="identityStoreId", required=true)
    private Output<String> identityStoreId;

    /**
     * @return The globally unique identifier for the identity store that this user is in.
     * 
     */
    public Output<String> identityStoreId() {
        return this.identityStoreId;
    }

    /**
     * The user&#39;s geographical region or location.
     * 
     */
    @Import(name="locale")
    private @Nullable Output<String> locale;

    /**
     * @return The user&#39;s geographical region or location.
     * 
     */
    public Optional<Output<String>> locale() {
        return Optional.ofNullable(this.locale);
    }

    /**
     * Details about the user&#39;s full name. Detailed below.
     * 
     */
    @Import(name="name")
    private @Nullable Output<UserNameArgs> name;

    /**
     * @return Details about the user&#39;s full name. Detailed below.
     * 
     */
    public Optional<Output<UserNameArgs>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * An alternate name for the user.
     * 
     */
    @Import(name="nickname")
    private @Nullable Output<String> nickname;

    /**
     * @return An alternate name for the user.
     * 
     */
    public Optional<Output<String>> nickname() {
        return Optional.ofNullable(this.nickname);
    }

    /**
     * Details about the user&#39;s phone number. At most 1 phone number is allowed. Detailed below.
     * 
     */
    @Import(name="phoneNumbers")
    private @Nullable Output<UserPhoneNumbersArgs> phoneNumbers;

    /**
     * @return Details about the user&#39;s phone number. At most 1 phone number is allowed. Detailed below.
     * 
     */
    public Optional<Output<UserPhoneNumbersArgs>> phoneNumbers() {
        return Optional.ofNullable(this.phoneNumbers);
    }

    /**
     * The preferred language of the user.
     * 
     */
    @Import(name="preferredLanguage")
    private @Nullable Output<String> preferredLanguage;

    /**
     * @return The preferred language of the user.
     * 
     */
    public Optional<Output<String>> preferredLanguage() {
        return Optional.ofNullable(this.preferredLanguage);
    }

    /**
     * An URL that may be associated with the user.
     * 
     */
    @Import(name="profileUrl")
    private @Nullable Output<String> profileUrl;

    /**
     * @return An URL that may be associated with the user.
     * 
     */
    public Optional<Output<String>> profileUrl() {
        return Optional.ofNullable(this.profileUrl);
    }

    /**
     * The user&#39;s time zone.
     * 
     */
    @Import(name="timezone")
    private @Nullable Output<String> timezone;

    /**
     * @return The user&#39;s time zone.
     * 
     */
    public Optional<Output<String>> timezone() {
        return Optional.ofNullable(this.timezone);
    }

    /**
     * The user&#39;s title.
     * 
     */
    @Import(name="title")
    private @Nullable Output<String> title;

    /**
     * @return The user&#39;s title.
     * 
     */
    public Optional<Output<String>> title() {
        return Optional.ofNullable(this.title);
    }

    /**
     * A unique string used to identify the user. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store. The limit is 128 characters.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="userName", required=true)
    private Output<String> userName;

    /**
     * @return A unique string used to identify the user. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store. The limit is 128 characters.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> userName() {
        return this.userName;
    }

    /**
     * The user type.
     * 
     */
    @Import(name="userType")
    private @Nullable Output<String> userType;

    /**
     * @return The user type.
     * 
     */
    public Optional<Output<String>> userType() {
        return Optional.ofNullable(this.userType);
    }

    private UserArgs() {}

    private UserArgs(UserArgs $) {
        this.addresses = $.addresses;
        this.displayName = $.displayName;
        this.emails = $.emails;
        this.identityStoreId = $.identityStoreId;
        this.locale = $.locale;
        this.name = $.name;
        this.nickname = $.nickname;
        this.phoneNumbers = $.phoneNumbers;
        this.preferredLanguage = $.preferredLanguage;
        this.profileUrl = $.profileUrl;
        this.timezone = $.timezone;
        this.title = $.title;
        this.userName = $.userName;
        this.userType = $.userType;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(UserArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private UserArgs $;

        public Builder() {
            $ = new UserArgs();
        }

        public Builder(UserArgs defaults) {
            $ = new UserArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param addresses Details about the user&#39;s address. At most 1 address is allowed. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder addresses(@Nullable Output<UserAddressesArgs> addresses) {
            $.addresses = addresses;
            return this;
        }

        /**
         * @param addresses Details about the user&#39;s address. At most 1 address is allowed. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder addresses(UserAddressesArgs addresses) {
            return addresses(Output.of(addresses));
        }

        /**
         * @param displayName The name that is typically displayed when the user is referenced.
         * 
         * @return builder
         * 
         */
        public Builder displayName(Output<String> displayName) {
            $.displayName = displayName;
            return this;
        }

        /**
         * @param displayName The name that is typically displayed when the user is referenced.
         * 
         * @return builder
         * 
         */
        public Builder displayName(String displayName) {
            return displayName(Output.of(displayName));
        }

        /**
         * @param emails Details about the user&#39;s email. At most 1 email is allowed. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder emails(@Nullable Output<UserEmailsArgs> emails) {
            $.emails = emails;
            return this;
        }

        /**
         * @param emails Details about the user&#39;s email. At most 1 email is allowed. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder emails(UserEmailsArgs emails) {
            return emails(Output.of(emails));
        }

        /**
         * @param identityStoreId The globally unique identifier for the identity store that this user is in.
         * 
         * @return builder
         * 
         */
        public Builder identityStoreId(Output<String> identityStoreId) {
            $.identityStoreId = identityStoreId;
            return this;
        }

        /**
         * @param identityStoreId The globally unique identifier for the identity store that this user is in.
         * 
         * @return builder
         * 
         */
        public Builder identityStoreId(String identityStoreId) {
            return identityStoreId(Output.of(identityStoreId));
        }

        /**
         * @param locale The user&#39;s geographical region or location.
         * 
         * @return builder
         * 
         */
        public Builder locale(@Nullable Output<String> locale) {
            $.locale = locale;
            return this;
        }

        /**
         * @param locale The user&#39;s geographical region or location.
         * 
         * @return builder
         * 
         */
        public Builder locale(String locale) {
            return locale(Output.of(locale));
        }

        /**
         * @param name Details about the user&#39;s full name. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<UserNameArgs> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Details about the user&#39;s full name. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder name(UserNameArgs name) {
            return name(Output.of(name));
        }

        /**
         * @param nickname An alternate name for the user.
         * 
         * @return builder
         * 
         */
        public Builder nickname(@Nullable Output<String> nickname) {
            $.nickname = nickname;
            return this;
        }

        /**
         * @param nickname An alternate name for the user.
         * 
         * @return builder
         * 
         */
        public Builder nickname(String nickname) {
            return nickname(Output.of(nickname));
        }

        /**
         * @param phoneNumbers Details about the user&#39;s phone number. At most 1 phone number is allowed. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder phoneNumbers(@Nullable Output<UserPhoneNumbersArgs> phoneNumbers) {
            $.phoneNumbers = phoneNumbers;
            return this;
        }

        /**
         * @param phoneNumbers Details about the user&#39;s phone number. At most 1 phone number is allowed. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder phoneNumbers(UserPhoneNumbersArgs phoneNumbers) {
            return phoneNumbers(Output.of(phoneNumbers));
        }

        /**
         * @param preferredLanguage The preferred language of the user.
         * 
         * @return builder
         * 
         */
        public Builder preferredLanguage(@Nullable Output<String> preferredLanguage) {
            $.preferredLanguage = preferredLanguage;
            return this;
        }

        /**
         * @param preferredLanguage The preferred language of the user.
         * 
         * @return builder
         * 
         */
        public Builder preferredLanguage(String preferredLanguage) {
            return preferredLanguage(Output.of(preferredLanguage));
        }

        /**
         * @param profileUrl An URL that may be associated with the user.
         * 
         * @return builder
         * 
         */
        public Builder profileUrl(@Nullable Output<String> profileUrl) {
            $.profileUrl = profileUrl;
            return this;
        }

        /**
         * @param profileUrl An URL that may be associated with the user.
         * 
         * @return builder
         * 
         */
        public Builder profileUrl(String profileUrl) {
            return profileUrl(Output.of(profileUrl));
        }

        /**
         * @param timezone The user&#39;s time zone.
         * 
         * @return builder
         * 
         */
        public Builder timezone(@Nullable Output<String> timezone) {
            $.timezone = timezone;
            return this;
        }

        /**
         * @param timezone The user&#39;s time zone.
         * 
         * @return builder
         * 
         */
        public Builder timezone(String timezone) {
            return timezone(Output.of(timezone));
        }

        /**
         * @param title The user&#39;s title.
         * 
         * @return builder
         * 
         */
        public Builder title(@Nullable Output<String> title) {
            $.title = title;
            return this;
        }

        /**
         * @param title The user&#39;s title.
         * 
         * @return builder
         * 
         */
        public Builder title(String title) {
            return title(Output.of(title));
        }

        /**
         * @param userName A unique string used to identify the user. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store. The limit is 128 characters.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder userName(Output<String> userName) {
            $.userName = userName;
            return this;
        }

        /**
         * @param userName A unique string used to identify the user. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store. The limit is 128 characters.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder userName(String userName) {
            return userName(Output.of(userName));
        }

        /**
         * @param userType The user type.
         * 
         * @return builder
         * 
         */
        public Builder userType(@Nullable Output<String> userType) {
            $.userType = userType;
            return this;
        }

        /**
         * @param userType The user type.
         * 
         * @return builder
         * 
         */
        public Builder userType(String userType) {
            return userType(Output.of(userType));
        }

        public UserArgs build() {
            $.displayName = Objects.requireNonNull($.displayName, "expected parameter 'displayName' to be non-null");
            $.identityStoreId = Objects.requireNonNull($.identityStoreId, "expected parameter 'identityStoreId' to be non-null");
            $.userName = Objects.requireNonNull($.userName, "expected parameter 'userName' to be non-null");
            return $;
        }
    }

}
