// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.identitystore;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.identitystore.GroupArgs;
import com.pulumi.aws.identitystore.inputs.GroupState;
import com.pulumi.aws.identitystore.outputs.GroupExternalId;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS IdentityStore Group.
 * 
 * ## Example Usage
 * 
 * ## Import
 * 
 * Using `pulumi import`, import an Identity Store Group using the combination `identity_store_id/group_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:identitystore/group:Group example d-9c6705e95c/b8a1c340-8031-7071-a2fb-7dc540320c30
 * ```
 * 
 */
@ResourceType(type="aws:identitystore/group:Group")
public class Group extends com.pulumi.resources.CustomResource {
    /**
     * A string containing the description of the group.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A string containing the description of the group.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * A string containing the name of the group. This value is commonly displayed when the group is referenced.
     * 
     */
    @Export(name="displayName", refs={String.class}, tree="[0]")
    private Output<String> displayName;

    /**
     * @return A string containing the name of the group. This value is commonly displayed when the group is referenced.
     * 
     */
    public Output<String> displayName() {
        return this.displayName;
    }
    /**
     * A list of external IDs that contains the identifiers issued to this resource by an external identity provider. See External IDs below.
     * 
     */
    @Export(name="externalIds", refs={List.class,GroupExternalId.class}, tree="[0,1]")
    private Output<List<GroupExternalId>> externalIds;

    /**
     * @return A list of external IDs that contains the identifiers issued to this resource by an external identity provider. See External IDs below.
     * 
     */
    public Output<List<GroupExternalId>> externalIds() {
        return this.externalIds;
    }
    /**
     * The identifier of the newly created group in the identity store.
     * 
     */
    @Export(name="groupId", refs={String.class}, tree="[0]")
    private Output<String> groupId;

    /**
     * @return The identifier of the newly created group in the identity store.
     * 
     */
    public Output<String> groupId() {
        return this.groupId;
    }
    /**
     * The globally unique identifier for the identity store.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="identityStoreId", refs={String.class}, tree="[0]")
    private Output<String> identityStoreId;

    /**
     * @return The globally unique identifier for the identity store.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> identityStoreId() {
        return this.identityStoreId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Group(String name) {
        this(name, GroupArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Group(String name, GroupArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Group(String name, GroupArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:identitystore/group:Group", name, args == null ? GroupArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Group(String name, Output<String> id, @Nullable GroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:identitystore/group:Group", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Group get(String name, Output<String> id, @Nullable GroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Group(name, id, state, options);
    }
}
