// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.iam.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ServiceSpecificCredentialState extends com.pulumi.resources.ResourceArgs {

    public static final ServiceSpecificCredentialState Empty = new ServiceSpecificCredentialState();

    /**
     * The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
     * 
     */
    @Import(name="serviceName")
    private @Nullable Output<String> serviceName;

    /**
     * @return The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
     * 
     */
    public Optional<Output<String>> serviceName() {
        return Optional.ofNullable(this.serviceName);
    }

    /**
     * The generated password for the service-specific credential.
     * 
     */
    @Import(name="servicePassword")
    private @Nullable Output<String> servicePassword;

    /**
     * @return The generated password for the service-specific credential.
     * 
     */
    public Optional<Output<String>> servicePassword() {
        return Optional.ofNullable(this.servicePassword);
    }

    /**
     * The unique identifier for the service-specific credential.
     * 
     */
    @Import(name="serviceSpecificCredentialId")
    private @Nullable Output<String> serviceSpecificCredentialId;

    /**
     * @return The unique identifier for the service-specific credential.
     * 
     */
    public Optional<Output<String>> serviceSpecificCredentialId() {
        return Optional.ofNullable(this.serviceSpecificCredentialId);
    }

    /**
     * The generated user name for the service-specific credential. This value is generated by combining the IAM user&#39;s name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
     * 
     */
    @Import(name="serviceUserName")
    private @Nullable Output<String> serviceUserName;

    /**
     * @return The generated user name for the service-specific credential. This value is generated by combining the IAM user&#39;s name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
     * 
     */
    public Optional<Output<String>> serviceUserName() {
        return Optional.ofNullable(this.serviceUserName);
    }

    /**
     * The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
     * 
     */
    @Import(name="status")
    private @Nullable Output<String> status;

    /**
     * @return The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
     * 
     */
    public Optional<Output<String>> status() {
        return Optional.ofNullable(this.status);
    }

    /**
     * The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
     * 
     */
    @Import(name="userName")
    private @Nullable Output<String> userName;

    /**
     * @return The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
     * 
     */
    public Optional<Output<String>> userName() {
        return Optional.ofNullable(this.userName);
    }

    private ServiceSpecificCredentialState() {}

    private ServiceSpecificCredentialState(ServiceSpecificCredentialState $) {
        this.serviceName = $.serviceName;
        this.servicePassword = $.servicePassword;
        this.serviceSpecificCredentialId = $.serviceSpecificCredentialId;
        this.serviceUserName = $.serviceUserName;
        this.status = $.status;
        this.userName = $.userName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ServiceSpecificCredentialState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ServiceSpecificCredentialState $;

        public Builder() {
            $ = new ServiceSpecificCredentialState();
        }

        public Builder(ServiceSpecificCredentialState defaults) {
            $ = new ServiceSpecificCredentialState(Objects.requireNonNull(defaults));
        }

        /**
         * @param serviceName The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
         * 
         * @return builder
         * 
         */
        public Builder serviceName(@Nullable Output<String> serviceName) {
            $.serviceName = serviceName;
            return this;
        }

        /**
         * @param serviceName The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
         * 
         * @return builder
         * 
         */
        public Builder serviceName(String serviceName) {
            return serviceName(Output.of(serviceName));
        }

        /**
         * @param servicePassword The generated password for the service-specific credential.
         * 
         * @return builder
         * 
         */
        public Builder servicePassword(@Nullable Output<String> servicePassword) {
            $.servicePassword = servicePassword;
            return this;
        }

        /**
         * @param servicePassword The generated password for the service-specific credential.
         * 
         * @return builder
         * 
         */
        public Builder servicePassword(String servicePassword) {
            return servicePassword(Output.of(servicePassword));
        }

        /**
         * @param serviceSpecificCredentialId The unique identifier for the service-specific credential.
         * 
         * @return builder
         * 
         */
        public Builder serviceSpecificCredentialId(@Nullable Output<String> serviceSpecificCredentialId) {
            $.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        /**
         * @param serviceSpecificCredentialId The unique identifier for the service-specific credential.
         * 
         * @return builder
         * 
         */
        public Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            return serviceSpecificCredentialId(Output.of(serviceSpecificCredentialId));
        }

        /**
         * @param serviceUserName The generated user name for the service-specific credential. This value is generated by combining the IAM user&#39;s name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
         * 
         * @return builder
         * 
         */
        public Builder serviceUserName(@Nullable Output<String> serviceUserName) {
            $.serviceUserName = serviceUserName;
            return this;
        }

        /**
         * @param serviceUserName The generated user name for the service-specific credential. This value is generated by combining the IAM user&#39;s name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
         * 
         * @return builder
         * 
         */
        public Builder serviceUserName(String serviceUserName) {
            return serviceUserName(Output.of(serviceUserName));
        }

        /**
         * @param status The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
         * 
         * @return builder
         * 
         */
        public Builder status(@Nullable Output<String> status) {
            $.status = status;
            return this;
        }

        /**
         * @param status The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
         * 
         * @return builder
         * 
         */
        public Builder status(String status) {
            return status(Output.of(status));
        }

        /**
         * @param userName The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
         * 
         * @return builder
         * 
         */
        public Builder userName(@Nullable Output<String> userName) {
            $.userName = userName;
            return this;
        }

        /**
         * @param userName The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
         * 
         * @return builder
         * 
         */
        public Builder userName(String userName) {
            return userName(Output.of(userName));
        }

        public ServiceSpecificCredentialState build() {
            return $;
        }
    }

}
