// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.iam.inputs;

import com.pulumi.aws.iam.inputs.GetPrincipalPolicySimulationContextArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GetPrincipalPolicySimulationArgs extends com.pulumi.resources.InvokeArgs {

    public static final GetPrincipalPolicySimulationArgs Empty = new GetPrincipalPolicySimulationArgs();

    /**
     * A set of IAM action names to run simulations for. Each entry in this set adds an additional hypothetical request to the simulation.
     * 
     * Action names consist of a service prefix and an action verb separated by a colon, such as `s3:GetObject`. Refer to [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to see the full set of possible IAM action names across all AWS services.
     * 
     */
    @Import(name="actionNames", required=true)
    private Output<List<String>> actionNames;

    /**
     * @return A set of IAM action names to run simulations for. Each entry in this set adds an additional hypothetical request to the simulation.
     * 
     * Action names consist of a service prefix and an action verb separated by a colon, such as `s3:GetObject`. Refer to [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to see the full set of possible IAM action names across all AWS services.
     * 
     */
    public Output<List<String>> actionNames() {
        return this.actionNames;
    }

    /**
     * A set of additional principal policy documents to include in the simulation. The simulator will behave as if each of these policies were associated with the object specified in `policy_source_arn`, allowing you to test the effect of hypothetical policies not yet created.
     * 
     */
    @Import(name="additionalPoliciesJsons")
    private @Nullable Output<List<String>> additionalPoliciesJsons;

    /**
     * @return A set of additional principal policy documents to include in the simulation. The simulator will behave as if each of these policies were associated with the object specified in `policy_source_arn`, allowing you to test the effect of hypothetical policies not yet created.
     * 
     */
    public Optional<Output<List<String>>> additionalPoliciesJsons() {
        return Optional.ofNullable(this.additionalPoliciesJsons);
    }

    /**
     * The ARN of an user that will appear as the &#34;caller&#34; of the simulated requests. If you do not specify `caller_arn` then the simulation will use the `policy_source_arn` instead, if it contains a user ARN.
     * 
     */
    @Import(name="callerArn")
    private @Nullable Output<String> callerArn;

    /**
     * @return The ARN of an user that will appear as the &#34;caller&#34; of the simulated requests. If you do not specify `caller_arn` then the simulation will use the `policy_source_arn` instead, if it contains a user ARN.
     * 
     */
    public Optional<Output<String>> callerArn() {
        return Optional.ofNullable(this.callerArn);
    }

    /**
     * Each `context` block defines an entry in the table of additional context keys in the simulated request.
     * 
     * IAM uses context keys for both custom conditions and for interpolating dynamic request-specific values into policy values. If you use policies that include those features then you will need to provide suitable example values for those keys to achieve a realistic simulation.
     * 
     */
    @Import(name="contexts")
    private @Nullable Output<List<GetPrincipalPolicySimulationContextArgs>> contexts;

    /**
     * @return Each `context` block defines an entry in the table of additional context keys in the simulated request.
     * 
     * IAM uses context keys for both custom conditions and for interpolating dynamic request-specific values into policy values. If you use policies that include those features then you will need to provide suitable example values for those keys to achieve a realistic simulation.
     * 
     */
    public Optional<Output<List<GetPrincipalPolicySimulationContextArgs>>> contexts() {
        return Optional.ofNullable(this.contexts);
    }

    /**
     * A set of [permissions boundary policy documents](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) to include in the simulation.
     * 
     */
    @Import(name="permissionsBoundaryPoliciesJsons")
    private @Nullable Output<List<String>> permissionsBoundaryPoliciesJsons;

    /**
     * @return A set of [permissions boundary policy documents](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) to include in the simulation.
     * 
     */
    public Optional<Output<List<String>>> permissionsBoundaryPoliciesJsons() {
        return Optional.ofNullable(this.permissionsBoundaryPoliciesJsons);
    }

    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IAM user, group, or role whose policies will be included in the simulation.
     * 
     * You must closely match the form of the real service request you are simulating in order to achieve a realistic result. You can use the following additional arguments to specify other characteristics of the simulated requests:
     * 
     */
    @Import(name="policySourceArn", required=true)
    private Output<String> policySourceArn;

    /**
     * @return The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IAM user, group, or role whose policies will be included in the simulation.
     * 
     * You must closely match the form of the real service request you are simulating in order to achieve a realistic result. You can use the following additional arguments to specify other characteristics of the simulated requests:
     * 
     */
    public Output<String> policySourceArn() {
        return this.policySourceArn;
    }

    /**
     * A set of ARNs of resources to include in the simulation.
     * 
     * This argument is important for actions that have either required or optional resource types listed in [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html), and you must provide ARNs that identify AWS objects of the appropriate types for the chosen actions.
     * 
     * The policy simulator only automatically loads policies associated with the `policy_source_arn`, so if your given resources have their own resource-level policy then you&#39;ll also need to provide that explicitly using the `resource_policy_json` argument to achieve a realistic simulation.
     * 
     */
    @Import(name="resourceArns")
    private @Nullable Output<List<String>> resourceArns;

    /**
     * @return A set of ARNs of resources to include in the simulation.
     * 
     * This argument is important for actions that have either required or optional resource types listed in [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html), and you must provide ARNs that identify AWS objects of the appropriate types for the chosen actions.
     * 
     * The policy simulator only automatically loads policies associated with the `policy_source_arn`, so if your given resources have their own resource-level policy then you&#39;ll also need to provide that explicitly using the `resource_policy_json` argument to achieve a realistic simulation.
     * 
     */
    public Optional<Output<List<String>>> resourceArns() {
        return Optional.ofNullable(this.resourceArns);
    }

    /**
     * Specifies a special simulation type to run. Some EC2 actions require special simulation behaviors and a particular set of resource ARNs to achieve a realistic result.
     * 
     * For more details, see the `ResourceHandlingOption` request parameter for [the underlying `iam:SimulatePrincipalPolicy` action](https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html).
     * 
     */
    @Import(name="resourceHandlingOption")
    private @Nullable Output<String> resourceHandlingOption;

    /**
     * @return Specifies a special simulation type to run. Some EC2 actions require special simulation behaviors and a particular set of resource ARNs to achieve a realistic result.
     * 
     * For more details, see the `ResourceHandlingOption` request parameter for [the underlying `iam:SimulatePrincipalPolicy` action](https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html).
     * 
     */
    public Optional<Output<String>> resourceHandlingOption() {
        return Optional.ofNullable(this.resourceHandlingOption);
    }

    /**
     * An AWS account ID to use for any resource ARN in `resource_arns` that doesn&#39;t include its own AWS account ID. If unspecified, the simulator will use the account ID from the `caller_arn` argument as a placeholder.
     * 
     */
    @Import(name="resourceOwnerAccountId")
    private @Nullable Output<String> resourceOwnerAccountId;

    /**
     * @return An AWS account ID to use for any resource ARN in `resource_arns` that doesn&#39;t include its own AWS account ID. If unspecified, the simulator will use the account ID from the `caller_arn` argument as a placeholder.
     * 
     */
    public Optional<Output<String>> resourceOwnerAccountId() {
        return Optional.ofNullable(this.resourceOwnerAccountId);
    }

    /**
     * An IAM policy document representing the resource-level policy of all of the resources specified in `resource_arns`.
     * 
     * The policy simulator cannot automatically load policies that are associated with individual resources, as described in the documentation for `resource_arns` above.
     * 
     */
    @Import(name="resourcePolicyJson")
    private @Nullable Output<String> resourcePolicyJson;

    /**
     * @return An IAM policy document representing the resource-level policy of all of the resources specified in `resource_arns`.
     * 
     * The policy simulator cannot automatically load policies that are associated with individual resources, as described in the documentation for `resource_arns` above.
     * 
     */
    public Optional<Output<String>> resourcePolicyJson() {
        return Optional.ofNullable(this.resourcePolicyJson);
    }

    private GetPrincipalPolicySimulationArgs() {}

    private GetPrincipalPolicySimulationArgs(GetPrincipalPolicySimulationArgs $) {
        this.actionNames = $.actionNames;
        this.additionalPoliciesJsons = $.additionalPoliciesJsons;
        this.callerArn = $.callerArn;
        this.contexts = $.contexts;
        this.permissionsBoundaryPoliciesJsons = $.permissionsBoundaryPoliciesJsons;
        this.policySourceArn = $.policySourceArn;
        this.resourceArns = $.resourceArns;
        this.resourceHandlingOption = $.resourceHandlingOption;
        this.resourceOwnerAccountId = $.resourceOwnerAccountId;
        this.resourcePolicyJson = $.resourcePolicyJson;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GetPrincipalPolicySimulationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GetPrincipalPolicySimulationArgs $;

        public Builder() {
            $ = new GetPrincipalPolicySimulationArgs();
        }

        public Builder(GetPrincipalPolicySimulationArgs defaults) {
            $ = new GetPrincipalPolicySimulationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param actionNames A set of IAM action names to run simulations for. Each entry in this set adds an additional hypothetical request to the simulation.
         * 
         * Action names consist of a service prefix and an action verb separated by a colon, such as `s3:GetObject`. Refer to [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to see the full set of possible IAM action names across all AWS services.
         * 
         * @return builder
         * 
         */
        public Builder actionNames(Output<List<String>> actionNames) {
            $.actionNames = actionNames;
            return this;
        }

        /**
         * @param actionNames A set of IAM action names to run simulations for. Each entry in this set adds an additional hypothetical request to the simulation.
         * 
         * Action names consist of a service prefix and an action verb separated by a colon, such as `s3:GetObject`. Refer to [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to see the full set of possible IAM action names across all AWS services.
         * 
         * @return builder
         * 
         */
        public Builder actionNames(List<String> actionNames) {
            return actionNames(Output.of(actionNames));
        }

        /**
         * @param actionNames A set of IAM action names to run simulations for. Each entry in this set adds an additional hypothetical request to the simulation.
         * 
         * Action names consist of a service prefix and an action verb separated by a colon, such as `s3:GetObject`. Refer to [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to see the full set of possible IAM action names across all AWS services.
         * 
         * @return builder
         * 
         */
        public Builder actionNames(String... actionNames) {
            return actionNames(List.of(actionNames));
        }

        /**
         * @param additionalPoliciesJsons A set of additional principal policy documents to include in the simulation. The simulator will behave as if each of these policies were associated with the object specified in `policy_source_arn`, allowing you to test the effect of hypothetical policies not yet created.
         * 
         * @return builder
         * 
         */
        public Builder additionalPoliciesJsons(@Nullable Output<List<String>> additionalPoliciesJsons) {
            $.additionalPoliciesJsons = additionalPoliciesJsons;
            return this;
        }

        /**
         * @param additionalPoliciesJsons A set of additional principal policy documents to include in the simulation. The simulator will behave as if each of these policies were associated with the object specified in `policy_source_arn`, allowing you to test the effect of hypothetical policies not yet created.
         * 
         * @return builder
         * 
         */
        public Builder additionalPoliciesJsons(List<String> additionalPoliciesJsons) {
            return additionalPoliciesJsons(Output.of(additionalPoliciesJsons));
        }

        /**
         * @param additionalPoliciesJsons A set of additional principal policy documents to include in the simulation. The simulator will behave as if each of these policies were associated with the object specified in `policy_source_arn`, allowing you to test the effect of hypothetical policies not yet created.
         * 
         * @return builder
         * 
         */
        public Builder additionalPoliciesJsons(String... additionalPoliciesJsons) {
            return additionalPoliciesJsons(List.of(additionalPoliciesJsons));
        }

        /**
         * @param callerArn The ARN of an user that will appear as the &#34;caller&#34; of the simulated requests. If you do not specify `caller_arn` then the simulation will use the `policy_source_arn` instead, if it contains a user ARN.
         * 
         * @return builder
         * 
         */
        public Builder callerArn(@Nullable Output<String> callerArn) {
            $.callerArn = callerArn;
            return this;
        }

        /**
         * @param callerArn The ARN of an user that will appear as the &#34;caller&#34; of the simulated requests. If you do not specify `caller_arn` then the simulation will use the `policy_source_arn` instead, if it contains a user ARN.
         * 
         * @return builder
         * 
         */
        public Builder callerArn(String callerArn) {
            return callerArn(Output.of(callerArn));
        }

        /**
         * @param contexts Each `context` block defines an entry in the table of additional context keys in the simulated request.
         * 
         * IAM uses context keys for both custom conditions and for interpolating dynamic request-specific values into policy values. If you use policies that include those features then you will need to provide suitable example values for those keys to achieve a realistic simulation.
         * 
         * @return builder
         * 
         */
        public Builder contexts(@Nullable Output<List<GetPrincipalPolicySimulationContextArgs>> contexts) {
            $.contexts = contexts;
            return this;
        }

        /**
         * @param contexts Each `context` block defines an entry in the table of additional context keys in the simulated request.
         * 
         * IAM uses context keys for both custom conditions and for interpolating dynamic request-specific values into policy values. If you use policies that include those features then you will need to provide suitable example values for those keys to achieve a realistic simulation.
         * 
         * @return builder
         * 
         */
        public Builder contexts(List<GetPrincipalPolicySimulationContextArgs> contexts) {
            return contexts(Output.of(contexts));
        }

        /**
         * @param contexts Each `context` block defines an entry in the table of additional context keys in the simulated request.
         * 
         * IAM uses context keys for both custom conditions and for interpolating dynamic request-specific values into policy values. If you use policies that include those features then you will need to provide suitable example values for those keys to achieve a realistic simulation.
         * 
         * @return builder
         * 
         */
        public Builder contexts(GetPrincipalPolicySimulationContextArgs... contexts) {
            return contexts(List.of(contexts));
        }

        /**
         * @param permissionsBoundaryPoliciesJsons A set of [permissions boundary policy documents](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) to include in the simulation.
         * 
         * @return builder
         * 
         */
        public Builder permissionsBoundaryPoliciesJsons(@Nullable Output<List<String>> permissionsBoundaryPoliciesJsons) {
            $.permissionsBoundaryPoliciesJsons = permissionsBoundaryPoliciesJsons;
            return this;
        }

        /**
         * @param permissionsBoundaryPoliciesJsons A set of [permissions boundary policy documents](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) to include in the simulation.
         * 
         * @return builder
         * 
         */
        public Builder permissionsBoundaryPoliciesJsons(List<String> permissionsBoundaryPoliciesJsons) {
            return permissionsBoundaryPoliciesJsons(Output.of(permissionsBoundaryPoliciesJsons));
        }

        /**
         * @param permissionsBoundaryPoliciesJsons A set of [permissions boundary policy documents](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) to include in the simulation.
         * 
         * @return builder
         * 
         */
        public Builder permissionsBoundaryPoliciesJsons(String... permissionsBoundaryPoliciesJsons) {
            return permissionsBoundaryPoliciesJsons(List.of(permissionsBoundaryPoliciesJsons));
        }

        /**
         * @param policySourceArn The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IAM user, group, or role whose policies will be included in the simulation.
         * 
         * You must closely match the form of the real service request you are simulating in order to achieve a realistic result. You can use the following additional arguments to specify other characteristics of the simulated requests:
         * 
         * @return builder
         * 
         */
        public Builder policySourceArn(Output<String> policySourceArn) {
            $.policySourceArn = policySourceArn;
            return this;
        }

        /**
         * @param policySourceArn The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IAM user, group, or role whose policies will be included in the simulation.
         * 
         * You must closely match the form of the real service request you are simulating in order to achieve a realistic result. You can use the following additional arguments to specify other characteristics of the simulated requests:
         * 
         * @return builder
         * 
         */
        public Builder policySourceArn(String policySourceArn) {
            return policySourceArn(Output.of(policySourceArn));
        }

        /**
         * @param resourceArns A set of ARNs of resources to include in the simulation.
         * 
         * This argument is important for actions that have either required or optional resource types listed in [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html), and you must provide ARNs that identify AWS objects of the appropriate types for the chosen actions.
         * 
         * The policy simulator only automatically loads policies associated with the `policy_source_arn`, so if your given resources have their own resource-level policy then you&#39;ll also need to provide that explicitly using the `resource_policy_json` argument to achieve a realistic simulation.
         * 
         * @return builder
         * 
         */
        public Builder resourceArns(@Nullable Output<List<String>> resourceArns) {
            $.resourceArns = resourceArns;
            return this;
        }

        /**
         * @param resourceArns A set of ARNs of resources to include in the simulation.
         * 
         * This argument is important for actions that have either required or optional resource types listed in [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html), and you must provide ARNs that identify AWS objects of the appropriate types for the chosen actions.
         * 
         * The policy simulator only automatically loads policies associated with the `policy_source_arn`, so if your given resources have their own resource-level policy then you&#39;ll also need to provide that explicitly using the `resource_policy_json` argument to achieve a realistic simulation.
         * 
         * @return builder
         * 
         */
        public Builder resourceArns(List<String> resourceArns) {
            return resourceArns(Output.of(resourceArns));
        }

        /**
         * @param resourceArns A set of ARNs of resources to include in the simulation.
         * 
         * This argument is important for actions that have either required or optional resource types listed in [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html), and you must provide ARNs that identify AWS objects of the appropriate types for the chosen actions.
         * 
         * The policy simulator only automatically loads policies associated with the `policy_source_arn`, so if your given resources have their own resource-level policy then you&#39;ll also need to provide that explicitly using the `resource_policy_json` argument to achieve a realistic simulation.
         * 
         * @return builder
         * 
         */
        public Builder resourceArns(String... resourceArns) {
            return resourceArns(List.of(resourceArns));
        }

        /**
         * @param resourceHandlingOption Specifies a special simulation type to run. Some EC2 actions require special simulation behaviors and a particular set of resource ARNs to achieve a realistic result.
         * 
         * For more details, see the `ResourceHandlingOption` request parameter for [the underlying `iam:SimulatePrincipalPolicy` action](https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html).
         * 
         * @return builder
         * 
         */
        public Builder resourceHandlingOption(@Nullable Output<String> resourceHandlingOption) {
            $.resourceHandlingOption = resourceHandlingOption;
            return this;
        }

        /**
         * @param resourceHandlingOption Specifies a special simulation type to run. Some EC2 actions require special simulation behaviors and a particular set of resource ARNs to achieve a realistic result.
         * 
         * For more details, see the `ResourceHandlingOption` request parameter for [the underlying `iam:SimulatePrincipalPolicy` action](https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html).
         * 
         * @return builder
         * 
         */
        public Builder resourceHandlingOption(String resourceHandlingOption) {
            return resourceHandlingOption(Output.of(resourceHandlingOption));
        }

        /**
         * @param resourceOwnerAccountId An AWS account ID to use for any resource ARN in `resource_arns` that doesn&#39;t include its own AWS account ID. If unspecified, the simulator will use the account ID from the `caller_arn` argument as a placeholder.
         * 
         * @return builder
         * 
         */
        public Builder resourceOwnerAccountId(@Nullable Output<String> resourceOwnerAccountId) {
            $.resourceOwnerAccountId = resourceOwnerAccountId;
            return this;
        }

        /**
         * @param resourceOwnerAccountId An AWS account ID to use for any resource ARN in `resource_arns` that doesn&#39;t include its own AWS account ID. If unspecified, the simulator will use the account ID from the `caller_arn` argument as a placeholder.
         * 
         * @return builder
         * 
         */
        public Builder resourceOwnerAccountId(String resourceOwnerAccountId) {
            return resourceOwnerAccountId(Output.of(resourceOwnerAccountId));
        }

        /**
         * @param resourcePolicyJson An IAM policy document representing the resource-level policy of all of the resources specified in `resource_arns`.
         * 
         * The policy simulator cannot automatically load policies that are associated with individual resources, as described in the documentation for `resource_arns` above.
         * 
         * @return builder
         * 
         */
        public Builder resourcePolicyJson(@Nullable Output<String> resourcePolicyJson) {
            $.resourcePolicyJson = resourcePolicyJson;
            return this;
        }

        /**
         * @param resourcePolicyJson An IAM policy document representing the resource-level policy of all of the resources specified in `resource_arns`.
         * 
         * The policy simulator cannot automatically load policies that are associated with individual resources, as described in the documentation for `resource_arns` above.
         * 
         * @return builder
         * 
         */
        public Builder resourcePolicyJson(String resourcePolicyJson) {
            return resourcePolicyJson(Output.of(resourcePolicyJson));
        }

        public GetPrincipalPolicySimulationArgs build() {
            $.actionNames = Objects.requireNonNull($.actionNames, "expected parameter 'actionNames' to be non-null");
            $.policySourceArn = Objects.requireNonNull($.policySourceArn, "expected parameter 'policySourceArn' to be non-null");
            return $;
        }
    }

}
