// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.iam;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.iam.UserGroupMembershipArgs;
import com.pulumi.aws.iam.inputs.UserGroupMembershipState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Provides a resource for adding an IAM User to IAM Groups. This
 * resource can be used multiple times with the same user for non-overlapping
 * groups.
 * 
 * To exclusively manage the users in a group, see the
 * `aws.iam.GroupMembership` resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.UserGroupMembership;
 * import com.pulumi.aws.iam.UserGroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var user1 = new User(&#34;user1&#34;);
 * 
 *         var group1 = new Group(&#34;group1&#34;);
 * 
 *         var group2 = new Group(&#34;group2&#34;);
 * 
 *         var example1 = new UserGroupMembership(&#34;example1&#34;, UserGroupMembershipArgs.builder()        
 *             .user(user1.name())
 *             .groups(            
 *                 group1.name(),
 *                 group2.name())
 *             .build());
 * 
 *         var group3 = new Group(&#34;group3&#34;);
 * 
 *         var example2 = new UserGroupMembership(&#34;example2&#34;, UserGroupMembershipArgs.builder()        
 *             .user(user1.name())
 *             .groups(group3.name())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import IAM user group membership using the user name and group names separated by `/`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:iam/userGroupMembership:UserGroupMembership example1 user1/group1/group2
 * ```
 * 
 */
@ResourceType(type="aws:iam/userGroupMembership:UserGroupMembership")
public class UserGroupMembership extends com.pulumi.resources.CustomResource {
    /**
     * A list of IAM Groups to add the user to
     * 
     */
    @Export(name="groups", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> groups;

    /**
     * @return A list of IAM Groups to add the user to
     * 
     */
    public Output<List<String>> groups() {
        return this.groups;
    }
    /**
     * The name of the IAM User to add to groups
     * 
     */
    @Export(name="user", refs={String.class}, tree="[0]")
    private Output<String> user;

    /**
     * @return The name of the IAM User to add to groups
     * 
     */
    public Output<String> user() {
        return this.user;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public UserGroupMembership(String name) {
        this(name, UserGroupMembershipArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public UserGroupMembership(String name, UserGroupMembershipArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public UserGroupMembership(String name, UserGroupMembershipArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iam/userGroupMembership:UserGroupMembership", name, args == null ? UserGroupMembershipArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private UserGroupMembership(String name, Output<String> id, @Nullable UserGroupMembershipState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iam/userGroupMembership:UserGroupMembership", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static UserGroupMembership get(String name, Output<String> id, @Nullable UserGroupMembershipState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new UserGroupMembership(name, id, state, options);
    }
}
