// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.iam;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.iam.ServiceSpecificCredentialArgs;
import com.pulumi.aws.iam.inputs.ServiceSpecificCredentialState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an IAM Service Specific Credential.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.ServiceSpecificCredential;
 * import com.pulumi.aws.iam.ServiceSpecificCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleUser = new User(&#34;exampleUser&#34;);
 * 
 *         var exampleServiceSpecificCredential = new ServiceSpecificCredential(&#34;exampleServiceSpecificCredential&#34;, ServiceSpecificCredentialArgs.builder()        
 *             .serviceName(&#34;codecommit.amazonaws.com&#34;)
 *             .userName(exampleUser.name())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import IAM Service Specific Credentials using the `service_name:user_name:service_specific_credential_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:iam/serviceSpecificCredential:ServiceSpecificCredential default `codecommit.amazonaws.com:example:some-id`
 * ```
 * 
 */
@ResourceType(type="aws:iam/serviceSpecificCredential:ServiceSpecificCredential")
public class ServiceSpecificCredential extends com.pulumi.resources.CustomResource {
    /**
     * The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
     * 
     */
    @Export(name="serviceName", refs={String.class}, tree="[0]")
    private Output<String> serviceName;

    /**
     * @return The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.
     * 
     */
    public Output<String> serviceName() {
        return this.serviceName;
    }
    /**
     * The generated password for the service-specific credential.
     * 
     */
    @Export(name="servicePassword", refs={String.class}, tree="[0]")
    private Output<String> servicePassword;

    /**
     * @return The generated password for the service-specific credential.
     * 
     */
    public Output<String> servicePassword() {
        return this.servicePassword;
    }
    /**
     * The unique identifier for the service-specific credential.
     * 
     */
    @Export(name="serviceSpecificCredentialId", refs={String.class}, tree="[0]")
    private Output<String> serviceSpecificCredentialId;

    /**
     * @return The unique identifier for the service-specific credential.
     * 
     */
    public Output<String> serviceSpecificCredentialId() {
        return this.serviceSpecificCredentialId;
    }
    /**
     * The generated user name for the service-specific credential. This value is generated by combining the IAM user&#39;s name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
     * 
     */
    @Export(name="serviceUserName", refs={String.class}, tree="[0]")
    private Output<String> serviceUserName;

    /**
     * @return The generated user name for the service-specific credential. This value is generated by combining the IAM user&#39;s name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
     * 
     */
    public Output<String> serviceUserName() {
        return this.serviceUserName;
    }
    /**
     * The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> status;

    /**
     * @return The status to be assigned to the service-specific credential. Valid values are `Active` and `Inactive`. Default value is `Active`.
     * 
     */
    public Output<Optional<String>> status() {
        return Codegen.optional(this.status);
    }
    /**
     * The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
     * 
     */
    @Export(name="userName", refs={String.class}, tree="[0]")
    private Output<String> userName;

    /**
     * @return The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
     * 
     */
    public Output<String> userName() {
        return this.userName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ServiceSpecificCredential(String name) {
        this(name, ServiceSpecificCredentialArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ServiceSpecificCredential(String name, ServiceSpecificCredentialArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ServiceSpecificCredential(String name, ServiceSpecificCredentialArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iam/serviceSpecificCredential:ServiceSpecificCredential", name, args == null ? ServiceSpecificCredentialArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ServiceSpecificCredential(String name, Output<String> id, @Nullable ServiceSpecificCredentialState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:iam/serviceSpecificCredential:ServiceSpecificCredential", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "servicePassword"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ServiceSpecificCredential get(String name, Output<String> id, @Nullable ServiceSpecificCredentialState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ServiceSpecificCredential(name, id, state, options);
    }
}
