// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.guardduty;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.guardduty.MemberArgs;
import com.pulumi.aws.guardduty.inputs.MemberState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage a GuardDuty member. To accept invitations in member accounts, see the `aws.guardduty.InviteAccepter` resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.Member;
 * import com.pulumi.aws.guardduty.MemberArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var primary = new Detector(&#34;primary&#34;, DetectorArgs.builder()        
 *             .enable(true)
 *             .build());
 * 
 *         var memberDetector = new Detector(&#34;memberDetector&#34;, DetectorArgs.builder()        
 *             .enable(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.dev())
 *                 .build());
 * 
 *         var memberMember = new Member(&#34;memberMember&#34;, MemberArgs.builder()        
 *             .accountId(memberDetector.accountId())
 *             .detectorId(primary.id())
 *             .email(&#34;required@example.com&#34;)
 *             .invite(true)
 *             .invitationMessage(&#34;please accept guardduty invitation&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import GuardDuty members using the primary GuardDuty detector ID and member AWS account ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:guardduty/member:Member MyMember 00b00fd5aecc0ab60a708659477e9617:123456789012
 * ```
 * 
 */
@ResourceType(type="aws:guardduty/member:Member")
public class Member extends com.pulumi.resources.CustomResource {
    /**
     * AWS account ID for member account.
     * 
     */
    @Export(name="accountId", refs={String.class}, tree="[0]")
    private Output<String> accountId;

    /**
     * @return AWS account ID for member account.
     * 
     */
    public Output<String> accountId() {
        return this.accountId;
    }
    /**
     * The detector ID of the GuardDuty account where you want to create member accounts.
     * 
     */
    @Export(name="detectorId", refs={String.class}, tree="[0]")
    private Output<String> detectorId;

    /**
     * @return The detector ID of the GuardDuty account where you want to create member accounts.
     * 
     */
    public Output<String> detectorId() {
        return this.detectorId;
    }
    /**
     * Boolean whether an email notification is sent to the accounts. Defaults to `false`.
     * 
     */
    @Export(name="disableEmailNotification", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> disableEmailNotification;

    /**
     * @return Boolean whether an email notification is sent to the accounts. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> disableEmailNotification() {
        return Codegen.optional(this.disableEmailNotification);
    }
    /**
     * Email address for member account.
     * 
     */
    @Export(name="email", refs={String.class}, tree="[0]")
    private Output<String> email;

    /**
     * @return Email address for member account.
     * 
     */
    public Output<String> email() {
        return this.email;
    }
    /**
     * Message for invitation.
     * 
     */
    @Export(name="invitationMessage", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> invitationMessage;

    /**
     * @return Message for invitation.
     * 
     */
    public Output<Optional<String>> invitationMessage() {
        return Codegen.optional(this.invitationMessage);
    }
    /**
     * Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
     * 
     */
    @Export(name="invite", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> invite;

    /**
     * @return Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
     * 
     */
    public Output<Optional<Boolean>> invite() {
        return Codegen.optional(this.invite);
    }
    /**
     * The status of the relationship between the member account and its primary account. More information can be found in [Amazon GuardDuty API Reference](https://docs.aws.amazon.com/guardduty/latest/ug/get-members.html).
     * 
     */
    @Export(name="relationshipStatus", refs={String.class}, tree="[0]")
    private Output<String> relationshipStatus;

    /**
     * @return The status of the relationship between the member account and its primary account. More information can be found in [Amazon GuardDuty API Reference](https://docs.aws.amazon.com/guardduty/latest/ug/get-members.html).
     * 
     */
    public Output<String> relationshipStatus() {
        return this.relationshipStatus;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Member(String name) {
        this(name, MemberArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Member(String name, MemberArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Member(String name, MemberArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:guardduty/member:Member", name, args == null ? MemberArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Member(String name, Output<String> id, @Nullable MemberState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:guardduty/member:Member", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Member get(String name, Output<String> id, @Nullable MemberState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Member(name, id, state, options);
    }
}
