// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.guardduty;

import com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class FilterArgs extends com.pulumi.resources.ResourceArgs {

    public static final FilterArgs Empty = new FilterArgs();

    /**
     * Specifies the action that is to be applied to the findings that match the filter. Can be one of `ARCHIVE` or `NOOP`.
     * 
     */
    @Import(name="action", required=true)
    private Output<String> action;

    /**
     * @return Specifies the action that is to be applied to the findings that match the filter. Can be one of `ARCHIVE` or `NOOP`.
     * 
     */
    public Output<String> action() {
        return this.action;
    }

    /**
     * Description of the filter.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the filter.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * ID of a GuardDuty detector, attached to your account.
     * 
     */
    @Import(name="detectorId", required=true)
    private Output<String> detectorId;

    /**
     * @return ID of a GuardDuty detector, attached to your account.
     * 
     */
    public Output<String> detectorId() {
        return this.detectorId;
    }

    /**
     * Represents the criteria to be used in the filter for querying findings. Contains one or more `criterion` blocks, documented below.
     * 
     */
    @Import(name="findingCriteria", required=true)
    private Output<FilterFindingCriteriaArgs> findingCriteria;

    /**
     * @return Represents the criteria to be used in the filter for querying findings. Contains one or more `criterion` blocks, documented below.
     * 
     */
    public Output<FilterFindingCriteriaArgs> findingCriteria() {
        return this.findingCriteria;
    }

    /**
     * The name of your filter.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of your filter.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.
     * 
     */
    @Import(name="rank", required=true)
    private Output<Integer> rank;

    /**
     * @return Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.
     * 
     */
    public Output<Integer> rank() {
        return this.rank;
    }

    /**
     * The tags that you want to add to the Filter resource. A tag consists of a key and a value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return The tags that you want to add to the Filter resource. A tag consists of a key and a value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private FilterArgs() {}

    private FilterArgs(FilterArgs $) {
        this.action = $.action;
        this.description = $.description;
        this.detectorId = $.detectorId;
        this.findingCriteria = $.findingCriteria;
        this.name = $.name;
        this.rank = $.rank;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(FilterArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FilterArgs $;

        public Builder() {
            $ = new FilterArgs();
        }

        public Builder(FilterArgs defaults) {
            $ = new FilterArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param action Specifies the action that is to be applied to the findings that match the filter. Can be one of `ARCHIVE` or `NOOP`.
         * 
         * @return builder
         * 
         */
        public Builder action(Output<String> action) {
            $.action = action;
            return this;
        }

        /**
         * @param action Specifies the action that is to be applied to the findings that match the filter. Can be one of `ARCHIVE` or `NOOP`.
         * 
         * @return builder
         * 
         */
        public Builder action(String action) {
            return action(Output.of(action));
        }

        /**
         * @param description Description of the filter.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the filter.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param detectorId ID of a GuardDuty detector, attached to your account.
         * 
         * @return builder
         * 
         */
        public Builder detectorId(Output<String> detectorId) {
            $.detectorId = detectorId;
            return this;
        }

        /**
         * @param detectorId ID of a GuardDuty detector, attached to your account.
         * 
         * @return builder
         * 
         */
        public Builder detectorId(String detectorId) {
            return detectorId(Output.of(detectorId));
        }

        /**
         * @param findingCriteria Represents the criteria to be used in the filter for querying findings. Contains one or more `criterion` blocks, documented below.
         * 
         * @return builder
         * 
         */
        public Builder findingCriteria(Output<FilterFindingCriteriaArgs> findingCriteria) {
            $.findingCriteria = findingCriteria;
            return this;
        }

        /**
         * @param findingCriteria Represents the criteria to be used in the filter for querying findings. Contains one or more `criterion` blocks, documented below.
         * 
         * @return builder
         * 
         */
        public Builder findingCriteria(FilterFindingCriteriaArgs findingCriteria) {
            return findingCriteria(Output.of(findingCriteria));
        }

        /**
         * @param name The name of your filter.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of your filter.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param rank Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.
         * 
         * @return builder
         * 
         */
        public Builder rank(Output<Integer> rank) {
            $.rank = rank;
            return this;
        }

        /**
         * @param rank Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.
         * 
         * @return builder
         * 
         */
        public Builder rank(Integer rank) {
            return rank(Output.of(rank));
        }

        /**
         * @param tags The tags that you want to add to the Filter resource. A tag consists of a key and a value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags The tags that you want to add to the Filter resource. A tag consists of a key and a value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public FilterArgs build() {
            $.action = Objects.requireNonNull($.action, "expected parameter 'action' to be non-null");
            $.detectorId = Objects.requireNonNull($.detectorId, "expected parameter 'detectorId' to be non-null");
            $.findingCriteria = Objects.requireNonNull($.findingCriteria, "expected parameter 'findingCriteria' to be non-null");
            $.rank = Objects.requireNonNull($.rank, "expected parameter 'rank' to be non-null");
            return $;
        }
    }

}
