// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.grafana;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.grafana.WorkspaceApiKeyArgs;
import com.pulumi.aws.grafana.inputs.WorkspaceApiKeyState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides an Amazon Managed Grafana workspace API Key resource.
 * 
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.grafana.WorkspaceApiKey;
 * import com.pulumi.aws.grafana.WorkspaceApiKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var key = new WorkspaceApiKey(&#34;key&#34;, WorkspaceApiKeyArgs.builder()        
 *             .keyName(&#34;test-key&#34;)
 *             .keyRole(&#34;VIEWER&#34;)
 *             .secondsToLive(3600)
 *             .workspaceId(aws_grafana_workspace.test().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:grafana/workspaceApiKey:WorkspaceApiKey")
public class WorkspaceApiKey extends com.pulumi.resources.CustomResource {
    /**
     * The key token in JSON format. Use this value as a bearer token to authenticate HTTP requests to the workspace.
     * 
     */
    @Export(name="key", refs={String.class}, tree="[0]")
    private Output<String> key;

    /**
     * @return The key token in JSON format. Use this value as a bearer token to authenticate HTTP requests to the workspace.
     * 
     */
    public Output<String> key() {
        return this.key;
    }
    /**
     * Specifies the name of the API key. Key names must be unique to the workspace.
     * 
     */
    @Export(name="keyName", refs={String.class}, tree="[0]")
    private Output<String> keyName;

    /**
     * @return Specifies the name of the API key. Key names must be unique to the workspace.
     * 
     */
    public Output<String> keyName() {
        return this.keyName;
    }
    /**
     * Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
     * 
     */
    @Export(name="keyRole", refs={String.class}, tree="[0]")
    private Output<String> keyRole;

    /**
     * @return Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
     * 
     */
    public Output<String> keyRole() {
        return this.keyRole;
    }
    /**
     * Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
     * 
     */
    @Export(name="secondsToLive", refs={Integer.class}, tree="[0]")
    private Output<Integer> secondsToLive;

    /**
     * @return Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
     * 
     */
    public Output<Integer> secondsToLive() {
        return this.secondsToLive;
    }
    /**
     * The ID of the workspace that the API key is valid for.
     * 
     */
    @Export(name="workspaceId", refs={String.class}, tree="[0]")
    private Output<String> workspaceId;

    /**
     * @return The ID of the workspace that the API key is valid for.
     * 
     */
    public Output<String> workspaceId() {
        return this.workspaceId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public WorkspaceApiKey(String name) {
        this(name, WorkspaceApiKeyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public WorkspaceApiKey(String name, WorkspaceApiKeyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public WorkspaceApiKey(String name, WorkspaceApiKeyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:grafana/workspaceApiKey:WorkspaceApiKey", name, args == null ? WorkspaceApiKeyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private WorkspaceApiKey(String name, Output<String> id, @Nullable WorkspaceApiKeyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:grafana/workspaceApiKey:WorkspaceApiKey", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static WorkspaceApiKey get(String name, Output<String> id, @Nullable WorkspaceApiKeyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new WorkspaceApiKey(name, id, state, options);
    }
}
