// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue.inputs;

import com.pulumi.aws.glue.inputs.PartitionStorageDescriptorArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class PartitionState extends com.pulumi.resources.ResourceArgs {

    public static final PartitionState Empty = new PartitionState();

    /**
     * ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     * 
     */
    @Import(name="catalogId")
    private @Nullable Output<String> catalogId;

    /**
     * @return ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     * 
     */
    public Optional<Output<String>> catalogId() {
        return Optional.ofNullable(this.catalogId);
    }

    /**
     * The time at which the partition was created.
     * 
     */
    @Import(name="creationTime")
    private @Nullable Output<String> creationTime;

    /**
     * @return The time at which the partition was created.
     * 
     */
    public Optional<Output<String>> creationTime() {
        return Optional.ofNullable(this.creationTime);
    }

    /**
     * Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * 
     */
    @Import(name="databaseName")
    private @Nullable Output<String> databaseName;

    /**
     * @return Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * 
     */
    public Optional<Output<String>> databaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    /**
     * The last time at which the partition was accessed.
     * 
     */
    @Import(name="lastAccessedTime")
    private @Nullable Output<String> lastAccessedTime;

    /**
     * @return The last time at which the partition was accessed.
     * 
     */
    public Optional<Output<String>> lastAccessedTime() {
        return Optional.ofNullable(this.lastAccessedTime);
    }

    /**
     * The last time at which column statistics were computed for this partition.
     * 
     */
    @Import(name="lastAnalyzedTime")
    private @Nullable Output<String> lastAnalyzedTime;

    /**
     * @return The last time at which column statistics were computed for this partition.
     * 
     */
    public Optional<Output<String>> lastAnalyzedTime() {
        return Optional.ofNullable(this.lastAnalyzedTime);
    }

    /**
     * Properties associated with this table, as a list of key-value pairs.
     * 
     */
    @Import(name="parameters")
    private @Nullable Output<Map<String,String>> parameters;

    /**
     * @return Properties associated with this table, as a list of key-value pairs.
     * 
     */
    public Optional<Output<Map<String,String>>> parameters() {
        return Optional.ofNullable(this.parameters);
    }

    /**
     * The values that define the partition.
     * 
     */
    @Import(name="partitionValues")
    private @Nullable Output<List<String>> partitionValues;

    /**
     * @return The values that define the partition.
     * 
     */
    public Optional<Output<List<String>>> partitionValues() {
        return Optional.ofNullable(this.partitionValues);
    }

    /**
     * A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
     * 
     */
    @Import(name="storageDescriptor")
    private @Nullable Output<PartitionStorageDescriptorArgs> storageDescriptor;

    /**
     * @return A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
     * 
     */
    public Optional<Output<PartitionStorageDescriptorArgs>> storageDescriptor() {
        return Optional.ofNullable(this.storageDescriptor);
    }

    @Import(name="tableName")
    private @Nullable Output<String> tableName;

    public Optional<Output<String>> tableName() {
        return Optional.ofNullable(this.tableName);
    }

    private PartitionState() {}

    private PartitionState(PartitionState $) {
        this.catalogId = $.catalogId;
        this.creationTime = $.creationTime;
        this.databaseName = $.databaseName;
        this.lastAccessedTime = $.lastAccessedTime;
        this.lastAnalyzedTime = $.lastAnalyzedTime;
        this.parameters = $.parameters;
        this.partitionValues = $.partitionValues;
        this.storageDescriptor = $.storageDescriptor;
        this.tableName = $.tableName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PartitionState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PartitionState $;

        public Builder() {
            $ = new PartitionState();
        }

        public Builder(PartitionState defaults) {
            $ = new PartitionState(Objects.requireNonNull(defaults));
        }

        /**
         * @param catalogId ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
         * 
         * @return builder
         * 
         */
        public Builder catalogId(@Nullable Output<String> catalogId) {
            $.catalogId = catalogId;
            return this;
        }

        /**
         * @param catalogId ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
         * 
         * @return builder
         * 
         */
        public Builder catalogId(String catalogId) {
            return catalogId(Output.of(catalogId));
        }

        /**
         * @param creationTime The time at which the partition was created.
         * 
         * @return builder
         * 
         */
        public Builder creationTime(@Nullable Output<String> creationTime) {
            $.creationTime = creationTime;
            return this;
        }

        /**
         * @param creationTime The time at which the partition was created.
         * 
         * @return builder
         * 
         */
        public Builder creationTime(String creationTime) {
            return creationTime(Output.of(creationTime));
        }

        /**
         * @param databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(@Nullable Output<String> databaseName) {
            $.databaseName = databaseName;
            return this;
        }

        /**
         * @param databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(String databaseName) {
            return databaseName(Output.of(databaseName));
        }

        /**
         * @param lastAccessedTime The last time at which the partition was accessed.
         * 
         * @return builder
         * 
         */
        public Builder lastAccessedTime(@Nullable Output<String> lastAccessedTime) {
            $.lastAccessedTime = lastAccessedTime;
            return this;
        }

        /**
         * @param lastAccessedTime The last time at which the partition was accessed.
         * 
         * @return builder
         * 
         */
        public Builder lastAccessedTime(String lastAccessedTime) {
            return lastAccessedTime(Output.of(lastAccessedTime));
        }

        /**
         * @param lastAnalyzedTime The last time at which column statistics were computed for this partition.
         * 
         * @return builder
         * 
         */
        public Builder lastAnalyzedTime(@Nullable Output<String> lastAnalyzedTime) {
            $.lastAnalyzedTime = lastAnalyzedTime;
            return this;
        }

        /**
         * @param lastAnalyzedTime The last time at which column statistics were computed for this partition.
         * 
         * @return builder
         * 
         */
        public Builder lastAnalyzedTime(String lastAnalyzedTime) {
            return lastAnalyzedTime(Output.of(lastAnalyzedTime));
        }

        /**
         * @param parameters Properties associated with this table, as a list of key-value pairs.
         * 
         * @return builder
         * 
         */
        public Builder parameters(@Nullable Output<Map<String,String>> parameters) {
            $.parameters = parameters;
            return this;
        }

        /**
         * @param parameters Properties associated with this table, as a list of key-value pairs.
         * 
         * @return builder
         * 
         */
        public Builder parameters(Map<String,String> parameters) {
            return parameters(Output.of(parameters));
        }

        /**
         * @param partitionValues The values that define the partition.
         * 
         * @return builder
         * 
         */
        public Builder partitionValues(@Nullable Output<List<String>> partitionValues) {
            $.partitionValues = partitionValues;
            return this;
        }

        /**
         * @param partitionValues The values that define the partition.
         * 
         * @return builder
         * 
         */
        public Builder partitionValues(List<String> partitionValues) {
            return partitionValues(Output.of(partitionValues));
        }

        /**
         * @param partitionValues The values that define the partition.
         * 
         * @return builder
         * 
         */
        public Builder partitionValues(String... partitionValues) {
            return partitionValues(List.of(partitionValues));
        }

        /**
         * @param storageDescriptor A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
         * 
         * @return builder
         * 
         */
        public Builder storageDescriptor(@Nullable Output<PartitionStorageDescriptorArgs> storageDescriptor) {
            $.storageDescriptor = storageDescriptor;
            return this;
        }

        /**
         * @param storageDescriptor A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
         * 
         * @return builder
         * 
         */
        public Builder storageDescriptor(PartitionStorageDescriptorArgs storageDescriptor) {
            return storageDescriptor(Output.of(storageDescriptor));
        }

        public Builder tableName(@Nullable Output<String> tableName) {
            $.tableName = tableName;
            return this;
        }

        public Builder tableName(String tableName) {
            return tableName(Output.of(tableName));
        }

        public PartitionState build() {
            return $;
        }
    }

}
