// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GetCatalogTableArgs extends com.pulumi.resources.InvokeArgs {

    public static final GetCatalogTableArgs Empty = new GetCatalogTableArgs();

    /**
     * ID of the Glue Catalog and database where the table metadata resides. If omitted, this defaults to the current AWS Account ID.
     * 
     */
    @Import(name="catalogId")
    private @Nullable Output<String> catalogId;

    /**
     * @return ID of the Glue Catalog and database where the table metadata resides. If omitted, this defaults to the current AWS Account ID.
     * 
     */
    public Optional<Output<String>> catalogId() {
        return Optional.ofNullable(this.catalogId);
    }

    /**
     * Name of the metadata database where the table metadata resides.
     * 
     */
    @Import(name="databaseName", required=true)
    private Output<String> databaseName;

    /**
     * @return Name of the metadata database where the table metadata resides.
     * 
     */
    public Output<String> databaseName() {
        return this.databaseName;
    }

    /**
     * Name of the table.
     * 
     */
    @Import(name="name", required=true)
    private Output<String> name;

    /**
     * @return Name of the table.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     * The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with `transaction_id`. Specified in RFC 3339 format, e.g. `2006-01-02T15:04:05Z07:00`.
     * 
     */
    @Import(name="queryAsOfTime")
    private @Nullable Output<String> queryAsOfTime;

    /**
     * @return The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with `transaction_id`. Specified in RFC 3339 format, e.g. `2006-01-02T15:04:05Z07:00`.
     * 
     */
    public Optional<Output<String>> queryAsOfTime() {
        return Optional.ofNullable(this.queryAsOfTime);
    }

    /**
     * The transaction ID at which to read the table contents.
     * 
     */
    @Import(name="transactionId")
    private @Nullable Output<Integer> transactionId;

    /**
     * @return The transaction ID at which to read the table contents.
     * 
     */
    public Optional<Output<Integer>> transactionId() {
        return Optional.ofNullable(this.transactionId);
    }

    private GetCatalogTableArgs() {}

    private GetCatalogTableArgs(GetCatalogTableArgs $) {
        this.catalogId = $.catalogId;
        this.databaseName = $.databaseName;
        this.name = $.name;
        this.queryAsOfTime = $.queryAsOfTime;
        this.transactionId = $.transactionId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GetCatalogTableArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GetCatalogTableArgs $;

        public Builder() {
            $ = new GetCatalogTableArgs();
        }

        public Builder(GetCatalogTableArgs defaults) {
            $ = new GetCatalogTableArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param catalogId ID of the Glue Catalog and database where the table metadata resides. If omitted, this defaults to the current AWS Account ID.
         * 
         * @return builder
         * 
         */
        public Builder catalogId(@Nullable Output<String> catalogId) {
            $.catalogId = catalogId;
            return this;
        }

        /**
         * @param catalogId ID of the Glue Catalog and database where the table metadata resides. If omitted, this defaults to the current AWS Account ID.
         * 
         * @return builder
         * 
         */
        public Builder catalogId(String catalogId) {
            return catalogId(Output.of(catalogId));
        }

        /**
         * @param databaseName Name of the metadata database where the table metadata resides.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(Output<String> databaseName) {
            $.databaseName = databaseName;
            return this;
        }

        /**
         * @param databaseName Name of the metadata database where the table metadata resides.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(String databaseName) {
            return databaseName(Output.of(databaseName));
        }

        /**
         * @param name Name of the table.
         * 
         * @return builder
         * 
         */
        public Builder name(Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the table.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param queryAsOfTime The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with `transaction_id`. Specified in RFC 3339 format, e.g. `2006-01-02T15:04:05Z07:00`.
         * 
         * @return builder
         * 
         */
        public Builder queryAsOfTime(@Nullable Output<String> queryAsOfTime) {
            $.queryAsOfTime = queryAsOfTime;
            return this;
        }

        /**
         * @param queryAsOfTime The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with `transaction_id`. Specified in RFC 3339 format, e.g. `2006-01-02T15:04:05Z07:00`.
         * 
         * @return builder
         * 
         */
        public Builder queryAsOfTime(String queryAsOfTime) {
            return queryAsOfTime(Output.of(queryAsOfTime));
        }

        /**
         * @param transactionId The transaction ID at which to read the table contents.
         * 
         * @return builder
         * 
         */
        public Builder transactionId(@Nullable Output<Integer> transactionId) {
            $.transactionId = transactionId;
            return this;
        }

        /**
         * @param transactionId The transaction ID at which to read the table contents.
         * 
         * @return builder
         * 
         */
        public Builder transactionId(Integer transactionId) {
            return transactionId(Output.of(transactionId));
        }

        public GetCatalogTableArgs build() {
            $.databaseName = Objects.requireNonNull($.databaseName, "expected parameter 'databaseName' to be non-null");
            $.name = Objects.requireNonNull($.name, "expected parameter 'name' to be non-null");
            return $;
        }
    }

}
