// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class CrawlerS3TargetArgs extends com.pulumi.resources.ResourceArgs {

    public static final CrawlerS3TargetArgs Empty = new CrawlerS3TargetArgs();

    /**
     * The name of the connection to use to connect to the JDBC target.
     * 
     */
    @Import(name="connectionName")
    private @Nullable Output<String> connectionName;

    /**
     * @return The name of the connection to use to connect to the JDBC target.
     * 
     */
    public Optional<Output<String>> connectionName() {
        return Optional.ofNullable(this.connectionName);
    }

    /**
     * The ARN of the dead-letter SQS queue.
     * 
     * &gt; **Note:** `deletion_behavior` of catalog target doesn&#39;t support `DEPRECATE_IN_DATABASE`.
     * 
     * &gt; **Note:** `configuration` for catalog target crawlers will have `{ ... &#34;Grouping&#34;: { &#34;TableGroupingPolicy&#34;: &#34;CombineCompatibleSchemas&#34;} }` by default.
     * 
     */
    @Import(name="dlqEventQueueArn")
    private @Nullable Output<String> dlqEventQueueArn;

    /**
     * @return The ARN of the dead-letter SQS queue.
     * 
     * &gt; **Note:** `deletion_behavior` of catalog target doesn&#39;t support `DEPRECATE_IN_DATABASE`.
     * 
     * &gt; **Note:** `configuration` for catalog target crawlers will have `{ ... &#34;Grouping&#34;: { &#34;TableGroupingPolicy&#34;: &#34;CombineCompatibleSchemas&#34;} }` by default.
     * 
     */
    public Optional<Output<String>> dlqEventQueueArn() {
        return Optional.ofNullable(this.dlqEventQueueArn);
    }

    /**
     * The ARN of the SQS queue to receive S3 notifications from.
     * 
     */
    @Import(name="eventQueueArn")
    private @Nullable Output<String> eventQueueArn;

    /**
     * @return The ARN of the SQS queue to receive S3 notifications from.
     * 
     */
    public Optional<Output<String>> eventQueueArn() {
        return Optional.ofNullable(this.eventQueueArn);
    }

    /**
     * A list of glob patterns used to exclude from the crawl.
     * 
     */
    @Import(name="exclusions")
    private @Nullable Output<List<String>> exclusions;

    /**
     * @return A list of glob patterns used to exclude from the crawl.
     * 
     */
    public Optional<Output<List<String>>> exclusions() {
        return Optional.ofNullable(this.exclusions);
    }

    /**
     * The name of the DynamoDB table to crawl.
     * 
     */
    @Import(name="path", required=true)
    private Output<String> path;

    /**
     * @return The name of the DynamoDB table to crawl.
     * 
     */
    public Output<String> path() {
        return this.path;
    }

    /**
     * Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
     * 
     */
    @Import(name="sampleSize")
    private @Nullable Output<Integer> sampleSize;

    /**
     * @return Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
     * 
     */
    public Optional<Output<Integer>> sampleSize() {
        return Optional.ofNullable(this.sampleSize);
    }

    private CrawlerS3TargetArgs() {}

    private CrawlerS3TargetArgs(CrawlerS3TargetArgs $) {
        this.connectionName = $.connectionName;
        this.dlqEventQueueArn = $.dlqEventQueueArn;
        this.eventQueueArn = $.eventQueueArn;
        this.exclusions = $.exclusions;
        this.path = $.path;
        this.sampleSize = $.sampleSize;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CrawlerS3TargetArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CrawlerS3TargetArgs $;

        public Builder() {
            $ = new CrawlerS3TargetArgs();
        }

        public Builder(CrawlerS3TargetArgs defaults) {
            $ = new CrawlerS3TargetArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param connectionName The name of the connection to use to connect to the JDBC target.
         * 
         * @return builder
         * 
         */
        public Builder connectionName(@Nullable Output<String> connectionName) {
            $.connectionName = connectionName;
            return this;
        }

        /**
         * @param connectionName The name of the connection to use to connect to the JDBC target.
         * 
         * @return builder
         * 
         */
        public Builder connectionName(String connectionName) {
            return connectionName(Output.of(connectionName));
        }

        /**
         * @param dlqEventQueueArn The ARN of the dead-letter SQS queue.
         * 
         * &gt; **Note:** `deletion_behavior` of catalog target doesn&#39;t support `DEPRECATE_IN_DATABASE`.
         * 
         * &gt; **Note:** `configuration` for catalog target crawlers will have `{ ... &#34;Grouping&#34;: { &#34;TableGroupingPolicy&#34;: &#34;CombineCompatibleSchemas&#34;} }` by default.
         * 
         * @return builder
         * 
         */
        public Builder dlqEventQueueArn(@Nullable Output<String> dlqEventQueueArn) {
            $.dlqEventQueueArn = dlqEventQueueArn;
            return this;
        }

        /**
         * @param dlqEventQueueArn The ARN of the dead-letter SQS queue.
         * 
         * &gt; **Note:** `deletion_behavior` of catalog target doesn&#39;t support `DEPRECATE_IN_DATABASE`.
         * 
         * &gt; **Note:** `configuration` for catalog target crawlers will have `{ ... &#34;Grouping&#34;: { &#34;TableGroupingPolicy&#34;: &#34;CombineCompatibleSchemas&#34;} }` by default.
         * 
         * @return builder
         * 
         */
        public Builder dlqEventQueueArn(String dlqEventQueueArn) {
            return dlqEventQueueArn(Output.of(dlqEventQueueArn));
        }

        /**
         * @param eventQueueArn The ARN of the SQS queue to receive S3 notifications from.
         * 
         * @return builder
         * 
         */
        public Builder eventQueueArn(@Nullable Output<String> eventQueueArn) {
            $.eventQueueArn = eventQueueArn;
            return this;
        }

        /**
         * @param eventQueueArn The ARN of the SQS queue to receive S3 notifications from.
         * 
         * @return builder
         * 
         */
        public Builder eventQueueArn(String eventQueueArn) {
            return eventQueueArn(Output.of(eventQueueArn));
        }

        /**
         * @param exclusions A list of glob patterns used to exclude from the crawl.
         * 
         * @return builder
         * 
         */
        public Builder exclusions(@Nullable Output<List<String>> exclusions) {
            $.exclusions = exclusions;
            return this;
        }

        /**
         * @param exclusions A list of glob patterns used to exclude from the crawl.
         * 
         * @return builder
         * 
         */
        public Builder exclusions(List<String> exclusions) {
            return exclusions(Output.of(exclusions));
        }

        /**
         * @param exclusions A list of glob patterns used to exclude from the crawl.
         * 
         * @return builder
         * 
         */
        public Builder exclusions(String... exclusions) {
            return exclusions(List.of(exclusions));
        }

        /**
         * @param path The name of the DynamoDB table to crawl.
         * 
         * @return builder
         * 
         */
        public Builder path(Output<String> path) {
            $.path = path;
            return this;
        }

        /**
         * @param path The name of the DynamoDB table to crawl.
         * 
         * @return builder
         * 
         */
        public Builder path(String path) {
            return path(Output.of(path));
        }

        /**
         * @param sampleSize Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
         * 
         * @return builder
         * 
         */
        public Builder sampleSize(@Nullable Output<Integer> sampleSize) {
            $.sampleSize = sampleSize;
            return this;
        }

        /**
         * @param sampleSize Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
         * 
         * @return builder
         * 
         */
        public Builder sampleSize(Integer sampleSize) {
            return sampleSize(Output.of(sampleSize));
        }

        public CrawlerS3TargetArgs build() {
            $.path = Objects.requireNonNull($.path, "expected parameter 'path' to be non-null");
            return $;
        }
    }

}
