// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class CrawlerCatalogTargetArgs extends com.pulumi.resources.ResourceArgs {

    public static final CrawlerCatalogTargetArgs Empty = new CrawlerCatalogTargetArgs();

    /**
     * The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
     * 
     */
    @Import(name="connectionName")
    private @Nullable Output<String> connectionName;

    /**
     * @return The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
     * 
     */
    public Optional<Output<String>> connectionName() {
        return Optional.ofNullable(this.connectionName);
    }

    /**
     * The name of the Glue database to be synchronized.
     * 
     */
    @Import(name="databaseName", required=true)
    private Output<String> databaseName;

    /**
     * @return The name of the Glue database to be synchronized.
     * 
     */
    public Output<String> databaseName() {
        return this.databaseName;
    }

    /**
     * A valid Amazon SQS ARN.
     * 
     * &gt; **Note:** `deletion_behavior` of catalog target doesn&#39;t support `DEPRECATE_IN_DATABASE`.
     * 
     * &gt; **Note:** `configuration` for catalog target crawlers will have `{ ... &#34;Grouping&#34;: { &#34;TableGroupingPolicy&#34;: &#34;CombineCompatibleSchemas&#34;} }` by default.
     * 
     */
    @Import(name="dlqEventQueueArn")
    private @Nullable Output<String> dlqEventQueueArn;

    /**
     * @return A valid Amazon SQS ARN.
     * 
     * &gt; **Note:** `deletion_behavior` of catalog target doesn&#39;t support `DEPRECATE_IN_DATABASE`.
     * 
     * &gt; **Note:** `configuration` for catalog target crawlers will have `{ ... &#34;Grouping&#34;: { &#34;TableGroupingPolicy&#34;: &#34;CombineCompatibleSchemas&#34;} }` by default.
     * 
     */
    public Optional<Output<String>> dlqEventQueueArn() {
        return Optional.ofNullable(this.dlqEventQueueArn);
    }

    /**
     * A valid Amazon SQS ARN.
     * 
     */
    @Import(name="eventQueueArn")
    private @Nullable Output<String> eventQueueArn;

    /**
     * @return A valid Amazon SQS ARN.
     * 
     */
    public Optional<Output<String>> eventQueueArn() {
        return Optional.ofNullable(this.eventQueueArn);
    }

    /**
     * A list of catalog tables to be synchronized.
     * 
     */
    @Import(name="tables", required=true)
    private Output<List<String>> tables;

    /**
     * @return A list of catalog tables to be synchronized.
     * 
     */
    public Output<List<String>> tables() {
        return this.tables;
    }

    private CrawlerCatalogTargetArgs() {}

    private CrawlerCatalogTargetArgs(CrawlerCatalogTargetArgs $) {
        this.connectionName = $.connectionName;
        this.databaseName = $.databaseName;
        this.dlqEventQueueArn = $.dlqEventQueueArn;
        this.eventQueueArn = $.eventQueueArn;
        this.tables = $.tables;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CrawlerCatalogTargetArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CrawlerCatalogTargetArgs $;

        public Builder() {
            $ = new CrawlerCatalogTargetArgs();
        }

        public Builder(CrawlerCatalogTargetArgs defaults) {
            $ = new CrawlerCatalogTargetArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param connectionName The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
         * 
         * @return builder
         * 
         */
        public Builder connectionName(@Nullable Output<String> connectionName) {
            $.connectionName = connectionName;
            return this;
        }

        /**
         * @param connectionName The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
         * 
         * @return builder
         * 
         */
        public Builder connectionName(String connectionName) {
            return connectionName(Output.of(connectionName));
        }

        /**
         * @param databaseName The name of the Glue database to be synchronized.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(Output<String> databaseName) {
            $.databaseName = databaseName;
            return this;
        }

        /**
         * @param databaseName The name of the Glue database to be synchronized.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(String databaseName) {
            return databaseName(Output.of(databaseName));
        }

        /**
         * @param dlqEventQueueArn A valid Amazon SQS ARN.
         * 
         * &gt; **Note:** `deletion_behavior` of catalog target doesn&#39;t support `DEPRECATE_IN_DATABASE`.
         * 
         * &gt; **Note:** `configuration` for catalog target crawlers will have `{ ... &#34;Grouping&#34;: { &#34;TableGroupingPolicy&#34;: &#34;CombineCompatibleSchemas&#34;} }` by default.
         * 
         * @return builder
         * 
         */
        public Builder dlqEventQueueArn(@Nullable Output<String> dlqEventQueueArn) {
            $.dlqEventQueueArn = dlqEventQueueArn;
            return this;
        }

        /**
         * @param dlqEventQueueArn A valid Amazon SQS ARN.
         * 
         * &gt; **Note:** `deletion_behavior` of catalog target doesn&#39;t support `DEPRECATE_IN_DATABASE`.
         * 
         * &gt; **Note:** `configuration` for catalog target crawlers will have `{ ... &#34;Grouping&#34;: { &#34;TableGroupingPolicy&#34;: &#34;CombineCompatibleSchemas&#34;} }` by default.
         * 
         * @return builder
         * 
         */
        public Builder dlqEventQueueArn(String dlqEventQueueArn) {
            return dlqEventQueueArn(Output.of(dlqEventQueueArn));
        }

        /**
         * @param eventQueueArn A valid Amazon SQS ARN.
         * 
         * @return builder
         * 
         */
        public Builder eventQueueArn(@Nullable Output<String> eventQueueArn) {
            $.eventQueueArn = eventQueueArn;
            return this;
        }

        /**
         * @param eventQueueArn A valid Amazon SQS ARN.
         * 
         * @return builder
         * 
         */
        public Builder eventQueueArn(String eventQueueArn) {
            return eventQueueArn(Output.of(eventQueueArn));
        }

        /**
         * @param tables A list of catalog tables to be synchronized.
         * 
         * @return builder
         * 
         */
        public Builder tables(Output<List<String>> tables) {
            $.tables = tables;
            return this;
        }

        /**
         * @param tables A list of catalog tables to be synchronized.
         * 
         * @return builder
         * 
         */
        public Builder tables(List<String> tables) {
            return tables(Output.of(tables));
        }

        /**
         * @param tables A list of catalog tables to be synchronized.
         * 
         * @return builder
         * 
         */
        public Builder tables(String... tables) {
            return tables(List.of(tables));
        }

        public CrawlerCatalogTargetArgs build() {
            $.databaseName = Objects.requireNonNull($.databaseName, "expected parameter 'databaseName' to be non-null");
            $.tables = Objects.requireNonNull($.tables, "expected parameter 'tables' to be non-null");
            return $;
        }
    }

}
