// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.glue.SecurityConfigurationArgs;
import com.pulumi.aws.glue.inputs.SecurityConfigurationState;
import com.pulumi.aws.glue.outputs.SecurityConfigurationEncryptionConfiguration;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages a Glue Security Configuration.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.SecurityConfiguration;
 * import com.pulumi.aws.glue.SecurityConfigurationArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new SecurityConfiguration(&#34;example&#34;, SecurityConfigurationArgs.builder()        
 *             .encryptionConfiguration(SecurityConfigurationEncryptionConfigurationArgs.builder()
 *                 .cloudwatchEncryption(SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs.builder()
 *                     .cloudwatchEncryptionMode(&#34;DISABLED&#34;)
 *                     .build())
 *                 .jobBookmarksEncryption(SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs.builder()
 *                     .jobBookmarksEncryptionMode(&#34;DISABLED&#34;)
 *                     .build())
 *                 .s3Encryption(SecurityConfigurationEncryptionConfigurationS3EncryptionArgs.builder()
 *                     .kmsKeyArn(data.aws_kms_key().example().arn())
 *                     .s3EncryptionMode(&#34;SSE-KMS&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Glue Security Configurations using `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:glue/securityConfiguration:SecurityConfiguration example example
 * ```
 * 
 */
@ResourceType(type="aws:glue/securityConfiguration:SecurityConfiguration")
public class SecurityConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * Configuration block containing encryption configuration. Detailed below.
     * 
     */
    @Export(name="encryptionConfiguration", refs={SecurityConfigurationEncryptionConfiguration.class}, tree="[0]")
    private Output<SecurityConfigurationEncryptionConfiguration> encryptionConfiguration;

    /**
     * @return Configuration block containing encryption configuration. Detailed below.
     * 
     */
    public Output<SecurityConfigurationEncryptionConfiguration> encryptionConfiguration() {
        return this.encryptionConfiguration;
    }
    /**
     * Name of the security configuration.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the security configuration.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SecurityConfiguration(String name) {
        this(name, SecurityConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SecurityConfiguration(String name, SecurityConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SecurityConfiguration(String name, SecurityConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/securityConfiguration:SecurityConfiguration", name, args == null ? SecurityConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SecurityConfiguration(String name, Output<String> id, @Nullable SecurityConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:glue/securityConfiguration:SecurityConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SecurityConfiguration get(String name, Output<String> id, @Nullable SecurityConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SecurityConfiguration(name, id, state, options);
    }
}
