// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.glue;

import com.pulumi.aws.glue.inputs.PartitionStorageDescriptorArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class PartitionArgs extends com.pulumi.resources.ResourceArgs {

    public static final PartitionArgs Empty = new PartitionArgs();

    /**
     * ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     * 
     */
    @Import(name="catalogId")
    private @Nullable Output<String> catalogId;

    /**
     * @return ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     * 
     */
    public Optional<Output<String>> catalogId() {
        return Optional.ofNullable(this.catalogId);
    }

    /**
     * Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * 
     */
    @Import(name="databaseName", required=true)
    private Output<String> databaseName;

    /**
     * @return Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * 
     */
    public Output<String> databaseName() {
        return this.databaseName;
    }

    /**
     * Properties associated with this table, as a list of key-value pairs.
     * 
     */
    @Import(name="parameters")
    private @Nullable Output<Map<String,String>> parameters;

    /**
     * @return Properties associated with this table, as a list of key-value pairs.
     * 
     */
    public Optional<Output<Map<String,String>>> parameters() {
        return Optional.ofNullable(this.parameters);
    }

    /**
     * The values that define the partition.
     * 
     */
    @Import(name="partitionValues", required=true)
    private Output<List<String>> partitionValues;

    /**
     * @return The values that define the partition.
     * 
     */
    public Output<List<String>> partitionValues() {
        return this.partitionValues;
    }

    /**
     * A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
     * 
     */
    @Import(name="storageDescriptor")
    private @Nullable Output<PartitionStorageDescriptorArgs> storageDescriptor;

    /**
     * @return A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
     * 
     */
    public Optional<Output<PartitionStorageDescriptorArgs>> storageDescriptor() {
        return Optional.ofNullable(this.storageDescriptor);
    }

    @Import(name="tableName", required=true)
    private Output<String> tableName;

    public Output<String> tableName() {
        return this.tableName;
    }

    private PartitionArgs() {}

    private PartitionArgs(PartitionArgs $) {
        this.catalogId = $.catalogId;
        this.databaseName = $.databaseName;
        this.parameters = $.parameters;
        this.partitionValues = $.partitionValues;
        this.storageDescriptor = $.storageDescriptor;
        this.tableName = $.tableName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PartitionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PartitionArgs $;

        public Builder() {
            $ = new PartitionArgs();
        }

        public Builder(PartitionArgs defaults) {
            $ = new PartitionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param catalogId ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
         * 
         * @return builder
         * 
         */
        public Builder catalogId(@Nullable Output<String> catalogId) {
            $.catalogId = catalogId;
            return this;
        }

        /**
         * @param catalogId ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
         * 
         * @return builder
         * 
         */
        public Builder catalogId(String catalogId) {
            return catalogId(Output.of(catalogId));
        }

        /**
         * @param databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(Output<String> databaseName) {
            $.databaseName = databaseName;
            return this;
        }

        /**
         * @param databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(String databaseName) {
            return databaseName(Output.of(databaseName));
        }

        /**
         * @param parameters Properties associated with this table, as a list of key-value pairs.
         * 
         * @return builder
         * 
         */
        public Builder parameters(@Nullable Output<Map<String,String>> parameters) {
            $.parameters = parameters;
            return this;
        }

        /**
         * @param parameters Properties associated with this table, as a list of key-value pairs.
         * 
         * @return builder
         * 
         */
        public Builder parameters(Map<String,String> parameters) {
            return parameters(Output.of(parameters));
        }

        /**
         * @param partitionValues The values that define the partition.
         * 
         * @return builder
         * 
         */
        public Builder partitionValues(Output<List<String>> partitionValues) {
            $.partitionValues = partitionValues;
            return this;
        }

        /**
         * @param partitionValues The values that define the partition.
         * 
         * @return builder
         * 
         */
        public Builder partitionValues(List<String> partitionValues) {
            return partitionValues(Output.of(partitionValues));
        }

        /**
         * @param partitionValues The values that define the partition.
         * 
         * @return builder
         * 
         */
        public Builder partitionValues(String... partitionValues) {
            return partitionValues(List.of(partitionValues));
        }

        /**
         * @param storageDescriptor A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
         * 
         * @return builder
         * 
         */
        public Builder storageDescriptor(@Nullable Output<PartitionStorageDescriptorArgs> storageDescriptor) {
            $.storageDescriptor = storageDescriptor;
            return this;
        }

        /**
         * @param storageDescriptor A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
         * 
         * @return builder
         * 
         */
        public Builder storageDescriptor(PartitionStorageDescriptorArgs storageDescriptor) {
            return storageDescriptor(Output.of(storageDescriptor));
        }

        public Builder tableName(Output<String> tableName) {
            $.tableName = tableName;
            return this;
        }

        public Builder tableName(String tableName) {
            return tableName(Output.of(tableName));
        }

        public PartitionArgs build() {
            $.databaseName = Objects.requireNonNull($.databaseName, "expected parameter 'databaseName' to be non-null");
            $.partitionValues = Objects.requireNonNull($.partitionValues, "expected parameter 'partitionValues' to be non-null");
            $.tableName = Objects.requireNonNull($.tableName, "expected parameter 'tableName' to be non-null");
            return $;
        }
    }

}
